/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsEmbedString;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIFilePicker;
import org.eclipse.swt.internal.mozilla.nsIFilePicker_1_8;
import org.eclipse.swt.internal.mozilla.nsILocalFile;
import org.eclipse.swt.internal.mozilla.nsISupports;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

class FilePicker {
    XPCOMObject supports;
    XPCOMObject filePicker;
    int refCount = 0;
    short mode;
    int parentHandle;
    String[] files;
    String[] masks;
    String defaultFilename;
    String directory;
    String title;
    static final String SEPARATOR = System.getProperty("file.separator");

    FilePicker() {
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        int[] nArray = new int[3];
        nArray[0] = 2;
        this.supports = new XPCOMObject(nArray){

            public int method0(int[] nArray) {
                return FilePicker.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return FilePicker.this.AddRef();
            }

            public int method2(int[] nArray) {
                return FilePicker.this.Release();
            }
        };
        int[] nArray2 = new int[18];
        nArray2[0] = 2;
        nArray2[3] = 3;
        nArray2[4] = 1;
        nArray2[5] = 2;
        nArray2[6] = 1;
        nArray2[7] = 1;
        nArray2[8] = 1;
        nArray2[9] = 1;
        nArray2[10] = 1;
        nArray2[11] = 1;
        nArray2[12] = 1;
        nArray2[13] = 1;
        nArray2[14] = 1;
        nArray2[15] = 1;
        nArray2[16] = 1;
        nArray2[17] = 1;
        this.filePicker = new XPCOMObject(nArray2){

            public int method0(int[] nArray) {
                return FilePicker.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return FilePicker.this.AddRef();
            }

            public int method2(int[] nArray) {
                return FilePicker.this.Release();
            }

            public int method3(int[] nArray) {
                return FilePicker.this.Init(nArray[0], nArray[1], (short)nArray[2]);
            }

            public int method4(int[] nArray) {
                return FilePicker.this.AppendFilters(nArray[0]);
            }

            public int method5(int[] nArray) {
                return FilePicker.this.AppendFilter(nArray[0], nArray[1]);
            }

            public int method6(int[] nArray) {
                return FilePicker.this.GetDefaultString(nArray[0]);
            }

            public int method7(int[] nArray) {
                return FilePicker.this.SetDefaultString(nArray[0]);
            }

            public int method8(int[] nArray) {
                return FilePicker.this.GetDefaultExtension(nArray[0]);
            }

            public int method9(int[] nArray) {
                return FilePicker.this.SetDefaultExtension(nArray[0]);
            }

            public int method10(int[] nArray) {
                return FilePicker.this.GetFilterIndex(nArray[0]);
            }

            public int method11(int[] nArray) {
                return FilePicker.this.SetFilterIndex(nArray[0]);
            }

            public int method12(int[] nArray) {
                return FilePicker.this.GetDisplayDirectory(nArray[0]);
            }

            public int method13(int[] nArray) {
                return FilePicker.this.SetDisplayDirectory(nArray[0]);
            }

            public int method14(int[] nArray) {
                return FilePicker.this.GetFile(nArray[0]);
            }

            public int method15(int[] nArray) {
                return FilePicker.this.GetFileURL(nArray[0]);
            }

            public int method16(int[] nArray) {
                return FilePicker.this.GetFiles(nArray[0]);
            }

            public int method17(int[] nArray) {
                return FilePicker.this.Show(nArray[0]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.supports != null) {
            this.supports.dispose();
            this.supports = null;
        }
        if (this.filePicker != null) {
            this.filePicker.dispose();
            this.filePicker = null;
        }
    }

    int getAddress() {
        return this.filePicker.getAddress();
    }

    int QueryInterface(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return -2147467262;
        }
        nsID nsID2 = new nsID();
        XPCOM.memmove(nsID2, n, 16);
        if (nsID2.Equals(nsISupports.NS_ISUPPORTS_IID)) {
            XPCOM.memmove(n2, new int[]{this.supports.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (nsID2.Equals(nsIFilePicker.NS_IFILEPICKER_IID)) {
            XPCOM.memmove(n2, new int[]{this.filePicker.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (nsID2.Equals(nsIFilePicker_1_8.NS_IFILEPICKER_IID)) {
            XPCOM.memmove(n2, new int[]{this.filePicker.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (nsID2.Equals(nsIFilePicker_1_8.NS_IFILEPICKER_10_IID)) {
            XPCOM.memmove(n2, new int[]{this.filePicker.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        XPCOM.memmove(n2, new int[1], C.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    Browser getBrowser(int n) {
        if (n == 0) {
            return null;
        }
        return Mozilla.getBrowser(n);
    }

    String parseAString(int n) {
        return null;
    }

    int Init(int n, int n2, short s) {
        this.parentHandle = n;
        this.mode = s;
        this.title = this.parseAString(n2);
        return 0;
    }

    int Show(int n) {
        int n2;
        if (this.mode == 2) {
            int n3 = this.showDirectoryPicker();
            XPCOM.memmove(n, new short[]{(short)n3}, 2);
            return 0;
        }
        int n4 = n2 = this.mode == 1 ? 8192 : 4096;
        if (this.mode == 3) {
            n2 |= 2;
        }
        Browser browser = this.getBrowser(this.parentHandle);
        Shell shell = null;
        shell = browser != null ? browser.getShell() : new Shell();
        FileDialog fileDialog = new FileDialog(shell, n2);
        if (this.title != null) {
            fileDialog.setText(this.title);
        }
        if (this.directory != null) {
            fileDialog.setFilterPath(this.directory);
        }
        if (this.masks != null) {
            fileDialog.setFilterExtensions(this.masks);
        }
        if (this.defaultFilename != null) {
            fileDialog.setFileName(this.defaultFilename);
        }
        String string = fileDialog.open();
        this.files = fileDialog.getFileNames();
        this.directory = fileDialog.getFilterPath();
        this.defaultFilename = null;
        this.title = null;
        this.masks = null;
        boolean bl = string == null;
        XPCOM.memmove(n, new short[]{(short)(bl ? 1 : 0)}, 2);
        return 0;
    }

    int showDirectoryPicker() {
        Browser browser = this.getBrowser(this.parentHandle);
        Shell shell = null;
        shell = browser != null ? browser.getShell() : new Shell();
        DirectoryDialog directoryDialog = new DirectoryDialog(shell, 0);
        if (this.title != null) {
            directoryDialog.setText(this.title);
        }
        if (this.directory != null) {
            directoryDialog.setFilterPath(this.directory);
        }
        this.directory = directoryDialog.open();
        this.defaultFilename = null;
        this.title = null;
        this.masks = null;
        this.files = null;
        return this.directory == null ? 1 : 0;
    }

    int GetFiles(int n) {
        return -2147467263;
    }

    int GetFileURL(int n) {
        return -2147467263;
    }

    int GetFile(int n) {
        String string = "";
        if (this.directory != null) {
            string = String.valueOf(string) + this.directory + SEPARATOR;
        }
        if (this.files != null && this.files.length > 0) {
            string = String.valueOf(string) + this.files[0];
        }
        nsEmbedString nsEmbedString2 = new nsEmbedString(string);
        int[] nArray = new int[1];
        int n2 = XPCOM.NS_NewLocalFile(nsEmbedString2.getAddress(), 1, nArray);
        nsEmbedString2.dispose();
        if (n2 != 0) {
            Mozilla.error(n2);
        }
        if (nArray[0] == 0) {
            Mozilla.error(-2147467261);
        }
        XPCOM.memmove(n, nArray, C.PTR_SIZEOF);
        return 0;
    }

    int SetDisplayDirectory(int n) {
        if (n == 0) {
            return 0;
        }
        nsILocalFile nsILocalFile2 = new nsILocalFile(n);
        int n2 = XPCOM.nsEmbedString_new();
        int n3 = nsILocalFile2.GetPath(n2);
        if (n3 != 0) {
            Mozilla.error(n3);
        }
        int n4 = XPCOM.nsEmbedString_Length(n2);
        int n5 = XPCOM.nsEmbedString_get(n2);
        char[] cArray = new char[n4];
        XPCOM.memmove(cArray, n5, n4 * 2);
        XPCOM.nsEmbedString_delete(n2);
        this.directory = new String(cArray);
        return 0;
    }

    int GetDisplayDirectory(int n) {
        String string = this.directory != null ? this.directory : "";
        nsEmbedString nsEmbedString2 = new nsEmbedString(string);
        int[] nArray = new int[1];
        int n2 = XPCOM.NS_NewLocalFile(nsEmbedString2.getAddress(), 1, nArray);
        nsEmbedString2.dispose();
        if (n2 != 0) {
            Mozilla.error(n2);
        }
        if (nArray[0] == 0) {
            Mozilla.error(-2147467261);
        }
        XPCOM.memmove(n, nArray, C.PTR_SIZEOF);
        return 0;
    }

    int SetFilterIndex(int n) {
        return -2147467263;
    }

    int GetFilterIndex(int n) {
        return -2147467263;
    }

    int SetDefaultExtension(int n) {
        return -2147467263;
    }

    int GetDefaultExtension(int n) {
        return -2147467263;
    }

    int SetDefaultString(int n) {
        this.defaultFilename = this.parseAString(n);
        return 0;
    }

    int GetDefaultString(int n) {
        return -2147467263;
    }

    int AppendFilter(int n, int n2) {
        return -2147467263;
    }

    int AppendFilters(int n) {
        String[] stringArray = null;
        switch (n) {
            case 1: 
            case 64: {
                this.masks = null;
                break;
            }
            case 2: {
                stringArray = new String[]{"*.htm;*.html"};
                break;
            }
            case 8: {
                stringArray = new String[]{"*.gif;*.jpeg;*.jpg;*.png"};
                break;
            }
            case 4: {
                stringArray = new String[]{"*.txt"};
                break;
            }
            case 16: {
                stringArray = new String[]{"*.xml"};
                break;
            }
            case 32: {
                stringArray = new String[]{"*.xul"};
            }
        }
        if (this.masks == null) {
            this.masks = stringArray;
        } else if (stringArray != null) {
            String[] stringArray2 = new String[this.masks.length + stringArray.length];
            System.arraycopy(this.masks, 0, stringArray2, 0, this.masks.length);
            System.arraycopy(stringArray, 0, stringArray2, this.masks.length, stringArray.length);
            this.masks = stringArray2;
        }
        return 0;
    }
}

