/**
 * Copyright (C) 2009 root42 Inc. All rights reserved.
 */
package jp.root42.r42fw.export.web.ui.components;

import java.io.Writer;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.opensymphony.xwork2.util.ValueStack;

import org.apache.struts2.components.Component;

import jp.root42.r42fw.export.web.ui.components.scope.LocalVariableScope;
import jp.root42.r42fw.export.web.ui.components.scope.LocalVariableScopeAware;
import jp.root42.r42fw.export.web.ui.components.scope.LocalVariableScopeFactory;


/**
 * @since 1.0
 * @author root42 Inc.
 * @version $Id: Block.java 3 2009-07-30 18:02:43Z takahashikzn $
 */
public class Block
    extends Component
    implements LocalVariableScopeAware {

    /** {@link #localVariableScope} */
    private final LocalVariableScope localVariableScope;

    /**
     * @param stack
     * stack
     * @param request
     * request
     * @param response
     * response
     */
    public Block(
        final ValueStack stack, final HttpServletRequest request,
        final HttpServletResponse response) {
        super(stack);

        this.localVariableScope =
            LocalVariableScopeFactory.getInstance().create(stack, request,
                response);
    }

    /** {@inheritDoc} */
    @Override
    public boolean start(final Writer writer) {
        this.localVariableScope.openScope();

        return super.start(writer);
    }

    /** {@inheritDoc} */
    @Override
    public boolean end(final Writer writer, final String body) {
        final boolean result = super.end(writer, body);

        this.localVariableScope.closeScope();

        return result;
    }

    /** {@inheritDoc} */
    @Override
    public LocalVariableScope getLocalVariableScope() {
        return this.localVariableScope;
    }
}
