/*
 * Decompiled with CFR 0.152.
 */
package jp.root42.r42fw.export.web.ui.components.scope;

import com.opensymphony.xwork2.util.ValueStack;
import java.util.HashMap;
import java.util.Map;
import jp.root42.r42fw.export.web.ui.components.scope.LocalVariableScope;
import org.apache.commons.lang.StringUtils;

public class LocalVariableScopeImpl
implements LocalVariableScope {
    private final ValueStack stack;
    private final Map<String, Object> overridedVars = new HashMap<String, Object>();
    private final Map<String, Object> overridedAttrVars = new HashMap<String, Object>();

    protected LocalVariableScopeImpl(ValueStack stack) {
        this.stack = stack;
    }

    protected ValueStack getStack() {
        return this.stack;
    }

    @Override
    public void openScope() {
    }

    @Override
    public void closeScope() {
        Object value;
        for (String key : this.overridedAttrVars.keySet()) {
            value = this.overridedAttrVars.get(key);
            this.setAttrValue(key, value);
        }
        for (String key : this.overridedVars.keySet()) {
            value = this.overridedVars.get(key);
            this.setValue(key, value);
        }
    }

    @Override
    public void setVar(String key, Object value) {
        if (StringUtils.isBlank((String)key)) {
            return;
        }
        if (!this.overridedAttrVars.containsKey(key)) {
            Object attrVar = this.getAttrValue(key);
            this.overridedAttrVars.put(key, attrVar);
        }
        this.setAttrValue(key, value);
        if (!this.overridedVars.containsKey(key)) {
            Object var = this.getValue(key);
            this.overridedVars.put(key, var);
        }
        this.setValue(key, value);
    }

    protected Object getAttrValue(String key) {
        return this.getStack().findValue("#attr['" + key + "']");
    }

    protected void setAttrValue(String key, Object value) {
        this.getStack().setValue("#attr['" + key + "']", value, true);
    }

    protected Object getValue(String key) {
        return this.getStack().findValue("#" + key);
    }

    protected void setValue(String key, Object value) {
        this.getStack().setValue("#" + key, value, true);
    }
}

