<?php
class page_list_options extends myQuicty {

function __construct($page) {
	parent:__construct();
	$this->page = $page;
	$this->list = $this->page->list;
}

var $perPage = 20;

function get_pager_option() {
	$where_condition = $this->make_where_condition();
	$join_condition = $this->make_join_condition();
	$select_condition = $join_condition.' '.$where_condition;
	$pager_option = $this->set_pager_option($this->perPage,$select_condition);
	return $pager_option;
}

function make_where_condition() {
	$search_system = array(
		'keyword'=>array('title'=>'page.name','url'=>'page.url'), // keyword search target column
		'condition'=>array('id'=>'page.id','application_id'=>'page.application_id','folder_id'=>'page.folder_id') // id search target column
		);
	return $this->list->make_condition($search_system);
}

function make_join_condition() {
	//$this->list->real_count = true; // set this flag if join other table
	//$join_condition = "left join {table_name} on folder.id={table_name}.folder_id";
	return $join_condition;
}

function make_select_fields() {
	$select_system = array(
		'page'=>'*', // specify all column
		//'page'=>array('id','name','url'), // specify each column
		//'page'=>array('id'=>'page_id'), //specify another column name
		);
	return $this->list->make_select_fields($select_system);
}

function make_sort_condition() {
	$sort_system = array(
		'default'=>' order by id desc',
		'colums'=>array('id','name','url') // sort keys
		);
	return $this->list->make_order($sort_system);
}

} // end of class page_list_options
?>