<?php
class item_search_base extends myQuicty {


function pre_dispatch_index() {
	parent::pre_dispatch_index();
	$this->caching = 0; // caching page flag: 0 = none; 1 = simple; 2 = each query
	$this->cache_lifetime = 1800; // cache life time by seconds
	$this->cache_id = get_query_id();
	$this->page['base_url'] = quicty_base_url();
	$this->page['data_name'] = 'item_search';

	require_once 'includes/myAmazon.class.php';
	$myAmazon = new myAmazon();
	$this->amazon = $myAmazon->amazon;
	
	return true;
}

function list_records($condition='') {
	require_once 'list_options.class.php';
	$this->list = $this->new_data_set('item_search');
	$options = new item_search_list_options($this);
	$pager_option = $options->get_pager_option($condition);
	$this->list->bind_pager($pager_option);
	
	$fields = $options->make_select_fields();
	$sort_condition = $options->make_sort_condition();
	$list_table = $this->list->select_table_with_pager($sort_condition,$fields);
	return $list_table;
}


function display_record($condition='') {
	require_once 'form_options.class.php';
	$this->form = $this->new_data_set('item_search');
	$options = new item_search_form_options($this);
	$options->set_form_options();
	$this->form->validate_and_freeze();
	$this->set_qs_status('SEND');
	$this->form->bind_button_control();
	
	if($_POST['asin']) {
		$this->amazon->response_options = $this->set_response_option();
		$result = $this->amazon->asin_search($_POST['asin']);
	} elseif($_POST['keywords']) {
		$this->amazon->search_kind = $this->set_search_option();
		$this->amazon->response_options = $this->set_response_option();
		$result = $this->amazon->keyword_search($_POST['keywords']);
	}
	return $result;
}

function set_search_option() {
	if($_POST['search_option'] and 
		array_key_exists($_POST['search_option'],$this->amazon->search_kind_array)) {
		$search_option = $_POST['search_option'];
	} else {
		$search_option = 'Blended';
	}
	return $search_option;
}


function set_response_option() {
	if($_POST['sort_option'] and 
		array_key_exists($_POST['sort_option'],$this->amazon->sort_option_array)) {
		$sort_option = $_POST['sort_option'];
	} else {
		$sort_option = 'salesrank';
	}
	$sort_option = 'salesrank';
	$response_options = array(
		'Sort' => $sort_option,
		'ResponseGroup' => 'Small,Images,ItemAttributes',
		'ItemPage'=>$_POST['itempage'],
	);
	return $response_options;
}

function assign_page_and_pathlist() {
	$upper_path = 'ڡ';
	$this->add_pathlist('<!--{$folder_name}-->/item_search/',$upper_path,false);
	$this->add_pathlist('',$this->page['name']);
	$this->assign('page',$this->page);
}


} // end of item_search_base class
?>