<?php
/**
 *	Project:	Quicty: Quick application build environment depends on PEAR and Smarty
 *	File:		Mail.class.php
 *
 *	@copyright	Tomoyuki Negishi and ZubaPitaTech, Inc.
 *	@author		Tomoyuki Negishi <tomoyu-n@zubapita.jp>
 *	@license	http://www.opensource.org/licenses/bsd-license.php The BSD License
 *	@package	Quicty
 *	@version	$Id:$
 */

// QueueSet Class with Quicty::DataView
//
class QueueSet extends DataView {

	function QueueSet($formName='', $method='post', $action='', $target='', $attributes=null, $trackSubmit=false) 	{
		DataView::DataView($formName, $method, $action, $target, $attributes, $trackSubmit);
		$this->data_set_config_dir = '/etc/data_set';
	}
	
	function bind_queue_set($data_set_file) {
		//if(function_exists(apc_fetch)) {
		//	$mail_queue_params = unserialize(apc_fetch('DATA_SET_'.$data_set_file));
		//}
		if(!$mail_queue_params) {
			$config_dir = $this->__page_obj->home_dir.$this->data_set_config_dir;
			$data_set_array = $this->read_conf_to_array($config_dir,$data_set_file);
			$data_set = $data_set_array['root'];
			foreach($data_set as $data_set_name=>$attributes) {
				if($data_set_name=='dsn') {
					$system = $attributes['system'];
					$dbname = $attributes['dbname'];
					$host = $attributes['host'];
					$port = $attributes['port'];
					$user = $attributes['user'];
					$password = $attributes['password'];
					//$path = $attributes['path'];
					//if(substr($path,0,1)!='/') $path = $this->__page_obj->home_dir.'/'.$path;
					if(!$system) {
						die('dsn: no system type! e.g.:pgsql');
					} else {
						$dsn = $system.'://';
						if($user) {
							$dsn .= $user;
							if($password) $dsn .= ':'.$password;
							$dsn .= '@';
						}
						if($host) {
							$dsn .= $host;
							if($port) $dsn .= ':'.$port;
						}
						if($path and $dbname) {
							$dsn .= '/'.$path.'/'.$dbname;
						} elseif(!$path and $dbname) {
							$dsn .= '/'.$dbname;
						}
					}
					$mail_queue_params['dsn'] = $dsn;
				}
			}
		}
		//if(function_exists(apc_store)) {
		//	$result = apc_store('DATA_SET_'.$data_set_file,serialize($mail_queue_params));
		//}
		return $mail_queue_params;
	}
} // end of class QueueSet

// QS_Mail_Queue Class with pear Mail_Queue
//
class QS_Mail_Queue extends Mail_Queue {

	public function set_mail($mail_obj) {
		$result = $this->put(
			$mail_obj->from_address,
			$mail_obj->to_address,
			$mail_obj->headers_data,
			$mail_obj->body_data
		);
		return $result;
	}

} // end of class QS_Mail_Queue

// QS_Mail_mime Class with pear Mail_mime
//
class QS_Mail_mime extends Mail_mime {

	public $from_address;
	public $to_address;
	public $headers_data;
	public $body_data;
	
	public function set_data($from_data,$to_data,$subject,$article) {
		if(is_array($from_data)) {
			$from = mb_encode_mimeheader($from_data['name'],'ISO-2022-JP').
			'<'.$from_data['email'].'>';
			$this->from_address = $from_data['email'];
		} else {
			$from = $from_data;
			$this->from_address = $from_data;
		}
		if(is_array($to_data)) {
			$to = mb_encode_mimeheader($to_data['name'],'ISO-2022-JP').
			'<'.$to_data['email'].'>';
			$this->to_address = $to_data['email'];
		} else {
			$to = $to_data;
			$this->to_address = $to_data;
		}
		if(mb_detect_encoding($subject,'auto')!='ASCII')
			$subject = mb_encode_mimeheader($subject,'ISO-2022-JP');
		$this->headers_data = $this->headers(array('From'=>$from,'To'=>$to,'Subject'=>$subject));
		$this->setTXTBody(mb_convert_encoding($article,'JIS'));
		$this->body_data = $this->get(array("text_charset"=>"ISO-2022-JP"));
	}

} // end of class QS_Mail_mime

?>
