#ifndef TO_SJIS_STRING_H
#define TO_SJIS_STRING_H

/*!
  \file
  \brief SJIS 文字列への変換

  Windows XP 環境において、ファイルのパスを SJIS にするために用いる

  \author Satofumi KAMIMURA

  $Id$

  \attention Linux 環境における日本語文字が、どう扱われるかは未検証
*/

class QString;


namespace qrk {

  /*!
    \brief 文字列の SJIS 変換

    \param text [i] オリジナル文字列

    \return SJIS 文字列
  */
  extern const QString toSjisString(const QString& text);
};

#endif /* !TO_SJIS_STRING_H */
