/*!
  \example ScipUtils.cpp

  \brief SCIP 2.0 ̎M

  \author Satofumi KAMIMURA

  $Id: ScipUtils.cpp 1000 2009-06-13 22:22:06Z satofumi $
*/

#include "ScipUtils.h"
#include "Connection.h"
#include "ConnectionUtils.h"
#include <cstdlib>

using namespace qrk;
using namespace std;


int decode(const char code[], int byte) {

  int value = 0;
  int i;

  for (i = 0; i < byte; ++i) {
    value <<= 6;
    value &= ~0x3f;
    value |= code[i] - 0x30;
  }
  return value;
}


static char addSum(const char* buf, size_t count) {

  char sum = 0;
  for (size_t i = 0; i < count; ++i) {
    sum += buf[i];
  }
  return sum;
}


int recvReply(Connection* con, int timeout,
              vector<string>* lines) {

  // GR[obN̓ǂݏo
  enum { LineMax = 64 + 1};
  char buffer[LineMax];
  int n = readline(con, buffer, LineMax, timeout);
  if (n <= 0) {
    // !!! Ӗ enum ɒuBenum ̓wb_Ő錾
    return ReceiveTimeout;
  }

  // ̓ǂݏo
  n = readline(con, buffer, LineMax, timeout);
  if (n <= 0) {
    return ReceiveTimeout;
  }

  // `FbNT̊mF
  char checksum = (addSum(buffer, n - 1) & 0x3f) + 0x30;
  if (buffer[n - 1] != checksum) {
    return -3;
  }
  // Xe[^X̎擾
  buffer[2] = '\0';
  int reply_code = strtol(buffer, NULL, 16);

  // s(1 byte)̓ǂݎ̂
  char last_ch;
  n = con->receive(&last_ch, 1, timeout);
  if (n != 1) {
    return -4;
  }
  if (! isLF(last_ch)) {
    // słȂ΁Af[^̉\邽ߏ߂
    con->ungetc(last_ch);
  }

  // lines  NULL łȂ΁Aŏɉs܂ł𕶎f[^ƂĊi[
  if (lines != NULL) {
    while (true) {
      n = readline(con, buffer, LineMax, timeout);
      lines->push_back(buffer);
      if ((n == 1) && isLF(buffer[0])) {
        break;

      } else if (n <= 0) {
        // !!! reply_code ύXׂ
        break;
      }
    }
  }

  return reply_code;
}
