/*!
  \example viewVvSample.cpp

  \brief VV f[^e̕\

  \author Satofumi KAMIMURA

  $Id: viewVvSample.cpp 1474 2009-11-01 05:33:08Z satofumi $
*/

#include "UrgCtrl.h"
#include <iostream>
#include <cstdlib>
#include <cstdio>

using namespace qrk;
using namespace std;


//! main
int main(int argc, char *argv[])
{
  const char device[] = "COM3";
  //const char device[] = "/dev/ttyACM0";

  UrgCtrl urg;
  if (! urg.connect(device)) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }

  vector<string> lines;

  // o[W̎擾
  urg.versionLines(lines);
  if (lines.empty()) {
    cerr << "UrgCtrl::versionLines: " << urg.what() << endl;
    exit(1);
  }

  // o
  for (vector<string>::iterator it = lines.begin();
       it != lines.end(); ++it) {
    cout << *it << endl;
  }

#ifdef MSC
  getchar();
#endif

  return 0;
}
