/*!
  \example md_scan.c

  \brief MD XLTv

  MD R}hpāAf[^w񐔂AĎ擾

  \author Satofumi KAMIMURA

  $Id: md_scan.c 1298 2009-09-14 20:46:35Z satofumi $
*/

#include "urg_ctrl.h"
#include "delay.h"
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>


static void urg_exit(urg_t *urg, const char *message)
{
  printf("%s: %s\n", message, urg_error(urg));
  urg_disconnect(urg);

#ifdef MSC
  getchar();
#endif
  exit(1);
}


//! main
int main(int argc, char *argv[])
{
  enum {
    CaptureTimes = 10,          /* f[^擾 */
  };

  //const char device[] = "COM3"; /* Windows ł̗ */
  const char device[] = "/dev/ttyACM0"; /* Linux ł̗ */

  int data_max;
  long* data;
  int timestamp;
  int previous_timestamp;
  int remain_times;
  int scan_msec;
  urg_parameter_t parameter;
  int ret;
  int n;
  int i;

  /* ڑ */
  urg_t urg;
  ret = urg_connect(&urg, device, 115200);
  if (ret < 0) {
    urg_exit(&urg, "urg_connect()");
    exit(1);
  }

  /* Mobt@̊m */
  data_max = urg_dataMax(&urg);
  data = (long*)malloc(sizeof(long) * data_max);
  if (data == NULL) {
    fprintf(stderr, "data_max: %d\n", data_max);
    perror("data buffer");
    exit(1);
  }
  urg_parameters(&urg, &parameter);
  scan_msec = urg_scanMsec(&urg);

  /* MD ł̃f[^vB擾񐔂 CaptureTimes  */
  /* 100 ȏ̘Af[^擾ɂ́A擾񐔂𖳌ɐݒ肷邱 */
  /* urg_setCaptureTimes(&urg, UrgInfinityTimes); */
  assert(CaptureTimes < 100);
  urg_setCaptureTimes(&urg, CaptureTimes);

  /* f[^v */
  ret = urg_requestData(&urg, URG_MD, URG_FIRST, URG_LAST);
  if (ret < 0) {
    urg_exit(&urg, "urg_requestData()");
  }

  // !!! 킩ɂB蒼

  /* f[^擾 */
  for (i = 0; i < CaptureTimes; ++i) {
    /* M */
    n = urg_receiveData(&urg, data, data_max);
    printf("n = %d\n", n);
    if (n < 0) {
      urg_exit(&urg, "urg_receiveData()");
    } else if (n == 0) {
      //delay(scan_msec / 2);
      printf("n == 0\n");
      --i;
      continue;
    }

    /* Őf[^A^CX^vtŕ\ */
    /*
      PC ̎MxꍇAURG ͑MłȂf[^j邽߁A
      remain_times ͕sAɂȂꍇ
    */
    previous_timestamp = timestamp;
    timestamp = urg_recentTimestamp(&urg);
    remain_times = urg_remainCaptureTimes(&urg);

    /* urg_minDistance() ȉ̋f[^́Al\ */
    printf("%d/%d: %ld [mm], %d [msec], (%d)\n",
           remain_times, CaptureTimes, data[parameter.area_front_], timestamp,
           timestamp - previous_timestamp);

    printf("%d, %d\n", i, remain_times);

    if (remain_times <= 0) {
      break;
    }
  }

  urg_disconnect(&urg);
  free(data);

#ifdef MSC
  getchar();
#endif

  return 0;
}
