#ifndef QRK_RANGE_CAPTURE_MODE_H
#define QRK_RANGE_CAPTURE_MODE_H

/*!
  \file
  \brief 取得モード定義

  \author Satofumi KAMIMURA

  $Id: RangeCaptureMode.h 783 2009-05-05 08:56:26Z satofumi $
*/

namespace qrk
{
  /*!
    \brief データの取得形式

    データの取得形式には、コマンドを送信したタイミングでデータを取得する「逐次取得」と、コマンド送信後は自動的にデータが送信される「自動取得」がある。

    \image html gd_md_sequence.png 逐次取得(GD/GS) と 自動取得(MD/MS)

    強度データの取得は、自動取得の形式で行われる。
  */
  typedef enum {
    ManualCapture,              //!< 逐次取得
    AutoCapture,                //!< 自動取得
    IntensityCapture,           //!< 強度データ取得
  } RangeCaptureMode;
}

#endif /* !QRK_RANGE_CAPTURE_MODE_H */
