/*!
  \example scip_20_scip.cpp

  \brief SCIP 2.0 の "SCIP2.0" 実行サンプル

  \author Satofumi KAMIMURA

  $Id: scip_20_scip.cpp 1474 2009-11-01 05:33:08Z satofumi $
*/

#include "SerialDevice.h"
#include "ScipUtils.h"
#include "DetectOS.h"
#include <cstdlib>
#include <cstdio>

using namespace qrk;


//! main
int main(int argc, char *argv[]) {

  // 適切にポート名を変更すること
#if defined(WINDOWS_OS)
  const char device[] = "COM3";
#elif defined(LINUX_OS)
  const char device[] = "/dev/ttyACM0";
#else
  const char device[] = "/dev/tty.usbmodem1d11";
#endif

  SerialDevice con;
  if (! con.connect(device, 19200)) {
    printf("SerialDevice::connect: %s\n", con.what());
    exit(1);
  }

  // SCIP2.0 の呼び出しと、応答の可視化
  enum { Timeout = 200, BufferMax = 64 + 1 };
  char buffer[BufferMax];

  for (int i = 0; i < 2; ++i) {
    con.send("SCIP2.0\n", 8);

    int n = con.receive(buffer, BufferMax, Timeout);
    for (int j = 0; j < n; ++j) {
      char ch = buffer[j];
      if (isprint(ch)) {
        printf("%c", ch);
      } else {
        printf("[%02x]\n", static_cast<unsigned char>(ch));
      }
    }
    printf("\n");
  }

  return 0;
}
