#ifndef QRK_URG_UTILS_H
#define QRK_URG_UTILS_H

/*!
  \file
  \brief URG の補助関数

  \author Satofumi KAMIMURA

  $Id: UrgUtils.h 933 2009-05-27 11:29:37Z satofumi $
*/

#include <cstdlib>


namespace qrk
{
  /*!
    \brief シリアル ID の取得

    \param[in] urg urg オブジェクト

    \retval >= シリアル ID
    \retval <0 エラー
  */
  template <class T>
  long urgSerialId(T* urg)
  {
    std::vector<std::string> version_lines;
    if (! urg->versionLines(version_lines)) {
      return -1;
    }
    if (version_lines.size() < 5) {
      return -1;
    }

    std::string& serial_line = version_lines[4];
    if (serial_line.size() < 7) {
      return -1;
    }
    return atol(serial_line.substr(6).c_str());
  }
}

#endif /* !QRK_URG_UTILS_H */
