#ifndef QRK_M_DIFFERENTIAL_DRIVE_H
#define QRK_M_DIFFERENTIAL_DRIVE_H

/*!
  \file
  \brief j^Ή DifferentialDrive NX

  \author Satofumi KAMIMURA

  $Id: mDifferentialDrive.h 1199 2009-08-02 01:17:07Z satofumi $
*/

#include "Coordinate.h"
#include "Running.h"
#include "motor_t.h"
#include "encoder_t.h"
#include "wheel_t.h"
#include "body_t.h"


namespace qrk
{
  //! j^Ή DifferentialDrive NX
  class mDifferentialDrive : public Coordinate, public Running
  {
    mDifferentialDrive(const mDifferentialDrive& rhs);
    mDifferentialDrive& operator = (const mDifferentialDrive& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    enum {
      DefaultBaudrate = 115200, // [bps]
    };
    mDifferentialDrive(void);
    ~mDifferentialDrive(void);

    const char* what(void) const;

    bool connect(const char* device, long baudrate = DefaultBaudrate);
    void disconnect(void);
    bool isConnected(void) const;
    void setConnection(Connection* connection);
    Connection* connection(void);

    void followLine(const Position<long>& line,
                    const Coordinate* coordinate = NULL);
    void stopLine(const Position<long>& line,
                  const Coordinate* coordinate = NULL);
    void followCircle(const Point<long>& center, long radius,
                      const Coordinate* coordinate = NULL);
    void stopCircle(const Point<long>& center, long radius, const Angle& angle,
                    const Coordinate* coordinate = NULL);
    void spin(const Angle& angle_per_sec);
    void rotate(const Angle& angle, const Coordinate* coordinate = NULL);

    void stop(void);

    Position<long> position(Coordinate* coordinate = NULL) const;
    long straightVelocity(void) const;
    Angle rotateVelocity(void) const;

    void setRobotPosition(const Position<long>& position,
                          const Coordinate* coordinate);
    void setStraightVelocity(long mm_per_sec);
    void setRotateVelocity(const Angle& angle_per_sec);
    void setStraightAcceleration(long mm_per_sec2);
    void setRotateAcceleration(const Angle& angle_per_sec2);

    bool isStable(void) const;

    void setWheelVelocity(int id, long mm_per_sec);

    std::string currentCommand(void) const;
    void saveCommand(void);
    void restoreCommand(void);
    void commitParameters(void);
    void setMotorParameter(int id, const motor_t& motor);
    void setEncoderParameter(int id, const encoder_t& encoder);
    void setWheelParameter(int id, const wheel_t& wheel);
    void setBodyParameter(const body_t& body);
  };
}

#endif /* !QRK_M_DIFFERENTIAL_DRIVE_H */
