#ifndef QRK_URG_MODEL_H
#define QRK_URG_MODEL_H

/*!
  \file
  \brief URG  ODE pf

  \author Satofumi KAMIMURA

  $Id: UrgModel.h 1162 2009-07-19 13:33:31Z satofumi $
*/

#include "Position.h"
#include <ode/ode.h>
#include <memory>


namespace qrk
{
  class OdeModel;


  class UrgModel
  {
    UrgModel(const UrgModel& rhs);
    UrgModel& operator = (const UrgModel& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    typedef enum {
      URG_04LX,
      UTM_30LX,
    } SensorType;

    UrgModel(void);
    ~UrgModel(void);

    void setSensorType(SensorType type);

    void activate(void);

    void setPosition(const Position<long>& position,
                     OdeModel* model, bool fixed);
    Position<long> position(void) const;

    dBodyID objectId(void) const;

    void setLaser(long* buffer, double radian, long max_length);

    // !!! w肵͈͂̌vs
    // !!! 

    // !!! vς݂̋Ԃ
    // !!! ꊇ
  };
}

#endif /* !QRK_URG_MODEL_H */
