#ifndef QRK_MARKER_MANAGER_H
#define QRK_MARKER_MANAGER_H

/*!
  \file
  \brief }[J[̊Ǘ

  \author Satofumi KAMIMURA

  $Id: MarkerManager.h 1228 2009-08-16 21:54:14Z satofumi $
*/

#include "ModelManager.h"
#include "Point.h"
#include "Color.h"
#include <vector>


namespace qrk
{
  class MarkerManager
  {
    MarkerManager(const MarkerManager& rhs);
    MarkerManager& operator = (const MarkerManager& rhs);

    struct pImpl;
    pImpl* pimpl;

  public:
    enum {
      Infinity = -1,
      DefaultWidth = 2,
    };

    MarkerManager(void);
    ~MarkerManager(void);

    void clear(const char* name);
    void draw(const char* name, ModelManager::model_t* model,
              int life_msec = Infinity);
    void drawModels(const char* name, ModelManager::model_t models[], size_t n,
                    int life_msec = Infinity);

    void drawPoints(const char* name, std::vector<Point<long> >& points,
                    const Color& color, int radius = DefaultWidth,
                    long height = 10);
    void drawLines(const char* name, std::vector<Point<long> >& points,
                   const Color& color, int width = DefaultWidth,
                   int life_msec = Infinity);
    void drawLinesStrip(const char* name, std::vector<Point<long> >& points,
                        const Color& color, int width = DefaultWidth,
                        int life_msec = Infinity);
    void drawArrows(const char* name, std::vector<Point<long> >& points,
                    const Color& color, int width = DefaultWidth,
                    int life_msec = Infinity);
    void drawArrowsStrip(const char* name, std::vector<Point<long> >& points,
                         const Color& color, int width = DefaultWidth,
                         int life_msec = Infinity);
  };
}

#endif /* !QRK_MARKER_MANAGER_H */
