#ifndef QRK_EVENT_SCHEDULER_H
#define QRK_EVENT_SCHEDULER_H

/*!
  \file
  \brief Cxg̃XPW[Ǘ

  \author Satofumi KAMIMURA

  $Id: EventScheduler.h 1179 2009-07-24 12:29:47Z satofumi $
*/

#include <ode/ode.h>
#include <cstddef>


namespace qrk
{
  class Device;
  class ConditionVariable;


  class EventScheduler
  {
    EventScheduler(const EventScheduler& rhs);
    EventScheduler& operator = (const EventScheduler& rhs);

    struct pImpl;
    pImpl* pimpl;

  public:
    EventScheduler(void);
    ~EventScheduler(void);

    void lock(void);
    void unlock(void);

    void start(void);
    void terminate(void);

    long ticks(void) const;
    void play(void);
    void pause(void);
    void moreFaster(void);
    void moreSlower(void);

    void registerDevice(Device* device);
    void removeDevice(Device* device);
    bool registerDelayEvent(ConditionVariable* condition, size_t msec);

    void setLaser(long* buffer, dGeomID laser_id);
  };
}

#endif /* !QRK_EVENT_SCHEDULER_H */
