#ifndef QRK_DRAW_ENVIRONMENT_WIDGET_H
#define QRK_DRAW_ENVIRONMENT_WIDGET_H

/*!
  \file
  \brief V~[V̕`

  \author Satofumi KAMIMURA

  $Id: DrawEnvironmentWidget.h 1234 2009-08-20 14:02:35Z satofumi $
*/

#include <QGLWidget>
#include <memory>


namespace qrk
{
  class DrawEnvironmentWidget : public QGLWidget
  {
    DrawEnvironmentWidget(const DrawEnvironmentWidget& rhs);
    DrawEnvironmentWidget& operator = (const DrawEnvironmentWidget& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  protected:
    void initializeGL(void);
    void resizeGL(int width, int height);
    void paintGL(void);
    //void mousePressEvent(QMouseEvent *event);
    //void mouseMoveEvent(QMouseEvent *event);
    void wheelEvent(QWheelEvent* event);

    QSize minimumSizeHint(void) const;

  public:
    DrawEnvironmentWidget(QWidget* parent = 0);
    ~DrawEnvironmentWidget(void);

    void redraw(void);
  };
}

#endif /* !QRK_DRAW_ENVIRONMENT_WIDGET_H */
