#ifndef QRK_DIFFERENTIAL_DRIVE_DEVICE_H
#define QRK_DIFFERENTIAL_DRIVE_DEVICE_H

/*!
  \file
  \brief DifferentialDrive ̃V~[^

  \author Satofumi KAMIMURA

  $Id: DifferentialDrive_device.h 1142 2009-07-14 13:13:25Z satofumi $
*/

#include "Device.h"
#include "OdeModel.h"


namespace qrk
{
  class DifferentialDrive_device : public Device, public OdeModel
  {
    DifferentialDrive_device(const DifferentialDrive_device& rhs);
    DifferentialDrive_device& operator = (const DifferentialDrive_device& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    DifferentialDrive_device(const char* device);
    ~DifferentialDrive_device(void);

    void setParameter(const char* type, const char* parameter);
    void activate(void);

    void execute(void);
    size_t nextExecuteInterval(void) const;

    void setPosition(const Position<long>& position,
                     OdeModel* model = NULL, bool fixed = false);
    Position<long> position(void) const;

    dBodyID objectId(void) const;
  };
}

#endif /* !QRK_DIFFERENTIAL_DRIVE_DEVICE_H */
