#ifndef QRK_BOX_H
#define QRK_BOX_H

/*!
  \file
  \brief V~[Vp̏Q(Box)

  \author Satofumi KAMIMURA

  $Id: Box.h 1176 2009-07-23 12:49:52Z satofumi $
*/


#include "OdeModel.h"


namespace qrk
{
  class Color;


  class Box : public OdeModel
  {
    Box(void);
    Box(const Box& rhs);
    Box& operator = (const Box& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    Box(long x, long y, long z, dReal mass = 1.0);
    ~Box(void);

    void setPosition(const Position<long>& position,
                     OdeModel* model = NULL, bool fixed = false);
    Position<long> position(void) const;

    void setColor(const Color& color);

    dBodyID objectId(void) const;
  };
}

#endif /* !QRK_BOX_H */
