#ifndef QRK_BEEGO_MODEL_H
#define QRK_BEEGO_MODEL_H

/*!
  \file
  \brief r[S ODE pf

  \author Satofumi KAMIMURA

  $Id: BeegoModel.h 1162 2009-07-19 13:33:31Z satofumi $
*/

#include "Position.h"
#include <ode/ode.h>
#include <memory>


namespace qrk
{
  class OdeModel;


  class BeegoModel
  {
    BeegoModel(const BeegoModel& rhs);
    BeegoModel& operator = (const BeegoModel& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    BeegoModel(void);
    ~BeegoModel(void);

    void activate(void);

    void setPosition(const Position<long>& position,
                     OdeModel* model = NULL, bool fixed = false);
    Position<long> position(void) const;

    dBodyID objectId(void) const;

    // !!! 폜邱
    dBodyID wheelsId(int id) const;

    // !!! 폜邱
    dBodyID freeWheelBallId(void) const;

    // ԗւ̔a
    // !!! id ōEւɈႤp[^wł悤ɂ
    // !!!

    // [^Ǝԗւ̃M̎w
    // !!!

    // GR[_\̎w
    // !!!

    // ԗւ̑xw肷
    void setMotorVelocity(int id, int count_per_msec);

    // GR[_lǂݏo
    long encoderCount(int id) const;
  };
}

#endif /* ! QRK_BEEGO_MODEL_H */
