/*!
  \file
  \brief Lua ւ UrgDistance W[o^

  \author Satofumi KAMIMURA

  $Id: luabindUrgDistance.cpp 1239 2009-08-22 08:54:02Z satofumi $
*/

#include "luabindUrgDistance.h"
#include "mUrgDistance.h"
#include <luabind/luabind.hpp>

using namespace qrk;
using namespace luabind;


void qrk::luabindUrgDistance(lua_State* L)
{
  module(L)
    [
     class_<mUrgDistance>("mUrgDistance")
     .def(constructor<>())
     .def("what", &mUrgDistance::what)
     .def("connect", &mUrgDistance::connect)
     .def("disconnect", &mUrgDistance::disconnect)
     .def("minDistance", &mUrgDistance::minDistance)
     .def("requestData", &mUrgDistance::requestData)
     .def("receiveData",
          (bool(mUrgDistance::*)(void)) &mUrgDistance::receiveData)
     .def("at", &mUrgDistance::at)
     .def("deg2index", &mUrgDistance::deg2index)
     ];
}
