/*!
  \file
  \brief Lua ւ geometry W[o^

  \author Satofumi KAMIMURA

  $Id: luabindGeometry.cpp 1116 2009-07-07 11:16:53Z satofumi $
*/

#include "luabindGeometry.h"
#include "Point.h"
#include "Rect.h"
#include "Position.h"
#include <luabind/luabind.hpp>

using namespace qrk;
using namespace luabind;


void qrk::luabindGeometry(lua_State* L)
{
  module(L)
    [
     class_<Point<long> >("Point")
     .def(constructor<long, long>())
     .def_readwrite("x", &Point<long>::x)
     .def_readwrite("y", &Point<long>::y),

     class_<Point<double> >("fPoint")
     .def(constructor<double, double>())
     .def_readwrite("x", &Point<double>::x)
     .def_readwrite("y", &Point<double>::y),

     class_<Rect<long> >("Rect")
     .def(constructor<long, long, long, long>())
     .def_readwrite("x", &Rect<long>::x)
     .def_readwrite("y", &Rect<long>::y)
     .def_readwrite("w", &Rect<long>::w)
     .def_readwrite("h", &Rect<long>::h),

     class_<Rect<double> >("fRect")
     .def(constructor<double, double, double, double>())
     .def_readwrite("x", &Rect<double>::x)
     .def_readwrite("y", &Rect<double>::y)
     .def_readwrite("w", &Rect<double>::w)
     .def_readwrite("h", &Rect<double>::h),

     class_<Position<long> >("Position")
     .def(constructor<long, long, Angle>())
     .def_readwrite("x", &Position<long>::x)
     .def_readwrite("y", &Position<long>::y)
     .def_readwrite("angle", &Position<long>::angle)
     .def("deg", &Position<long>::deg)
     .def("rad", &Position<long>::rad),

     class_<Angle>("Angle"),

     def("deg", deg),
     def("rad", rad)
     ];
}
