#ifndef QRC_RANGE_SENSOR_H
#define QRC_RANGE_SENSOR_H

/*!
  \file
  \brief WEZT[̃C^[tF[X`

  \author Satofumi KAMIMURA

  $Id: RangeFinder.h 1027 2009-06-17 02:45:01Z satofumi $
*/

#include "MathUtils.h"
#include <vector>


namespace qrk
{
  class Connection;


  //! WEZT[̃C^[tF[X
  class RangeFinder
  {
  public:
    virtual ~RangeFinder(void) {}


    /*!
      \brief ԂԂ

      \return Ԃ

      <strong>Example</strong>
\code
UrgCtrl sensor;
if (! sensor.connect(device, baudrate)) {
  // ڑɎsƂɁAG[bZ[W\
  printf("connect: %s\n", sensor.what());
  exit(1);
} \endcode
    */
    virtual const char* what(void) const = 0;


    /*!
      \brief ڑ

      \param[in] device ڑfoCX
      \param[in] baudrate ڑ{[[g

      \retval true 
      \retval false s

      <strong>Example</strong>
\code
const char device[] = "/dev/ttyACM0";
const long baudrate = 115200;
UrgCtrl sensor;

// wfoCXɐڑ
if (! sensor.connect(device, baudrate)) {
  printf("connect: %s\n", sensor.what());
  exit(1);
} \endcode
    */
    virtual bool connect(const char* device, long baudrate) = 0;


    /*!
      \brief ؒf
    */
    virtual void disconnect(void) = 0;


    /*!
      \brief ڑԂԂ

      \retval true ڑ
      \retval false ؒf
    */
    virtual bool isConnected(void) const = 0;


    /*!
      \brief ڑIuWFNg̎w

      \param[in] connection ڑIuWFNg

      \attention ŕێĂڑIuWFNg̉̓[Uŕۏ؂邱
    */
    virtual void setConnection(Connection* connection) = 0;


    /*!
      \brief ڑIuWFNg̎擾

      \return ڑIuWFNg
    */
    virtual Connection* connection(void) = 0;


    /*!
      \brief P̃XLԂ̎擾

      \return P̃XL [msec]
    */
    virtual size_t scanMsec(void) const = 0;


    /*!
      \brief L̍ŏl擾

      \return L̍ŏl
    */
    virtual size_t minDistance(void) const = 0;


    /*!
      \brief L̍ől擾

      \return L̍ől
    */
    virtual size_t maxDistance(void) const = 0;


    /*!
      \brief XL̍őCfbNX擾

      \return XL̍őCfbN
    */
    virtual size_t maxRange(void) const = 0;


    /*!
      \brief ^CX^v̓o^

      ZTԂ^CX^v̒lo^B

      \param[in] timestamp ^CX^v [msec]
    */
    virtual void setTimestamp(long timestamp) = 0;


    /*!
      \brief f[^擾񐔂̐ݒ

      \param[in] times f[^̎擾
    */
    virtual void setCaptureTimes(size_t times) = 0;

    /*!
      \brief f[^擾͈͂̐ݒ

      \param[in] begin_index 擾̊JnCfbNX
      \param[in] end_index 擾̏ICfbNX
    */
    virtual void setCaptureRange(size_t begin_index, size_t end_index) = 0;


    /*!
      \brief f[^̎擾Jn

      f[^̎擾͈͂ݒ肷@\́AZT̃NXŒ񋟂
    */
    virtual void requestData(void) = 0;


    /*!
      \brief 擾f[^̎M

      \param[out] data f[^̊i[p
      \param[out] timestamp f[^擾̃^CX^v

      \retval true 
      \retval false G[
    */
    virtual bool receiveData(std::vector<long>& data, long* timestamp) = 0;


    /*!
      \brief pxɑΉCfbNX̎擾

      ZTOʂA0.0 [rad] ɑB

      \param[in] radian px [radian]

      \return CfbNX
    */
    virtual size_t rad2index(double radian) const = 0;


    /*!
      \brief pxɑΉCfbNX̎擾

      ZTOʂA0.0 [rad] ɑB

      \param[in] degree px [degree]

      \return CfbNX
    */
    int deg2index(const int degree) const
    {
      return rad2index(degree * M_PI / 180.0);
    }


    /*!
      \brief CfbNXɑΉpx̎擾

      ZTOʂA0.0 [rad] ɑB

      !!! }

      \param[in] index f[^CfbNX

      \return px [radian]
    */
    virtual double index2rad(size_t index) const = 0;


    /*!
      \brief CfbNXɑΉpx̎擾

      ZTOʂA0.0 [rad] ɑB

      !!! }

      \param[in] index f[^CfbNX

      \return px [degree]
    */
    int index2deg(const int index) const
    {
      return static_cast<int>(lrint(180.0 * index2rad(index) / M_PI));
    }
  };
}
#endif /* !QRC_RANGE_SENSOR_H */
