#ifndef PACKET_ACCESS_H
#define PACKET_ACCESS_H

#include "robot_t.h"
#include <vector>


extern void robot_reset_set(std::vector<char>& packet, char value);
extern char robot_reset_get(unsigned char*& p);
extern void robot_system_reset_set(std::vector<char>& packet, char value);
extern char robot_system_reset_get(unsigned char*& p);
extern void robot_system_major_set(std::vector<char>& packet, unsigned char value);
extern unsigned char robot_system_major_get(unsigned char*& p);
extern void robot_system_minor_set(std::vector<char>& packet, unsigned char value);
extern unsigned char robot_system_minor_get(unsigned char*& p);
extern void robot_system_micro_set(std::vector<char>& packet, unsigned char value);
extern unsigned char robot_system_micro_get(unsigned char*& p);
extern void robot_system_sec_set(std::vector<char>& packet, unsigned long value);
extern unsigned long robot_system_sec_get(unsigned char*& p);
extern void robot_system_msec_set(std::vector<char>& packet, unsigned short value);
extern unsigned short robot_system_msec_get(unsigned char*& p);
extern void robot_system_mode_set(std::vector<char>& packet, ControlMode value);
extern ControlMode robot_system_mode_get(unsigned char*& p);
extern void robot_encoder_0_reset_set(std::vector<char>& packet, char value);
extern char robot_encoder_0_reset_get(unsigned char*& p);
extern void robot_encoder_1_reset_set(std::vector<char>& packet, char value);
extern char robot_encoder_1_reset_get(unsigned char*& p);
extern void robot_motor_0_reset_set(std::vector<char>& packet, char value);
extern char robot_motor_0_reset_get(unsigned char*& p);
extern void robot_motor_0_gain_p_set(std::vector<char>& packet, long value);
extern long robot_motor_0_gain_p_get(unsigned char*& p);
extern void robot_motor_0_gain_i_set(std::vector<char>& packet, long value);
extern long robot_motor_0_gain_i_get(unsigned char*& p);
extern void robot_motor_1_reset_set(std::vector<char>& packet, char value);
extern char robot_motor_1_reset_get(unsigned char*& p);
extern void robot_motor_1_gain_p_set(std::vector<char>& packet, long value);
extern long robot_motor_1_gain_p_get(unsigned char*& p);
extern void robot_motor_1_gain_i_set(std::vector<char>& packet, long value);
extern long robot_motor_1_gain_i_get(unsigned char*& p);
extern void robot_body_reset_set(std::vector<char>& packet, char value);
extern char robot_body_reset_get(unsigned char*& p);
extern void robot_body_rotate_coeffecient_set(std::vector<char>& packet, long value);
extern long robot_body_rotate_coeffecient_get(unsigned char*& p);
extern void robot_position_reset_set(std::vector<char>& packet, char value);
extern char robot_position_reset_get(unsigned char*& p);
extern void robot_position_mm_0_set(std::vector<char>& packet, long value);
extern long robot_position_mm_0_get(unsigned char*& p);
extern void robot_position_mm_1_set(std::vector<char>& packet, long value);
extern long robot_position_mm_1_get(unsigned char*& p);
extern void robot_position_dir16_set(std::vector<char>& packet, unsigned short value);
extern unsigned short robot_position_dir16_get(unsigned char*& p);
extern void robot_follow_position_reset_set(std::vector<char>& packet, char value);
extern char robot_follow_position_reset_get(unsigned char*& p);
extern void robot_follow_position_mm_0_set(std::vector<char>& packet, long value);
extern long robot_follow_position_mm_0_get(unsigned char*& p);
extern void robot_follow_position_mm_1_set(std::vector<char>& packet, long value);
extern long robot_follow_position_mm_1_get(unsigned char*& p);
extern void robot_follow_position_dir16_set(std::vector<char>& packet, unsigned short value);
extern unsigned short robot_follow_position_dir16_get(unsigned char*& p);
extern void robot_path_reset_set(std::vector<char>& packet, char value);
extern char robot_path_reset_get(unsigned char*& p);
extern void robot_path_reset_offset_set(std::vector<char>& packet, char value);
extern char robot_path_reset_offset_get(unsigned char*& p);
extern void robot_path_mode_set(std::vector<char>& packet, PathMode value);
extern PathMode robot_path_mode_get(unsigned char*& p);
extern void robot_path_rotate_direction_set(std::vector<char>& packet, long value);
extern long robot_path_rotate_direction_get(unsigned char*& p);
extern void robot_path_circle_radius_set(std::vector<char>& packet, long value);
extern long robot_path_circle_radius_get(unsigned char*& p);
extern void robot_straight_reset_set(std::vector<char>& packet, char value);
extern char robot_straight_reset_get(unsigned char*& p);
extern void robot_straight_target_velocity_set(std::vector<char>& packet, long value);
extern long robot_straight_target_velocity_get(unsigned char*& p);
extern void robot_rotate_reset_set(std::vector<char>& packet, char value);
extern char robot_rotate_reset_get(unsigned char*& p);
extern void robot_rotate_target_velocity_set(std::vector<char>& packet, long value);
extern long robot_rotate_target_velocity_get(unsigned char*& p);
extern void robot_direct_reset_set(std::vector<char>& packet, char value);
extern char robot_direct_reset_get(unsigned char*& p);
extern void robot_direct_wheel_0_target_velocity_set(std::vector<char>& packet, long value);
extern long robot_direct_wheel_0_target_velocity_get(unsigned char*& p);
extern void robot_direct_wheel_1_target_velocity_set(std::vector<char>& packet, long value);
extern long robot_direct_wheel_1_target_velocity_get(unsigned char*& p);

#endif /* !PACKET_ACCESS_H */
