#ifndef QRK_MANAGED_TICKS_H
#define QRK_MANAGED_TICKS_H

/*!
  \file
  \brief Ԍo߂̊ǗNX

  \author Satofumi KAMIMURA

  $Id: ManagedTicks.h 1178 2009-07-24 11:50:10Z satofumi $
*/

#include <memory>


namespace qrk
{
  class ManagedTicks
  {
    ManagedTicks(const ManagedTicks& rhs);
    ManagedTicks& operator = (const ManagedTicks& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    typedef int (*TicksFunction)(void);

    ManagedTicks(void);
    ~ManagedTicks(void);

    void setTicksFunction(TicksFunction function);

    long ticks(void) const;

    // !!! x̍őAŏ`ł悤ɂ

    void play(void);
    void pause(void);
    void resume(void);
    void moreFaster(void);
    void moreSlower(void);
  };
}

#endif /* !QRK_MANAGED_TICKS_H */
