#ifndef QRK_FIND_COM_PORTS_H
#define QRK_FIND_COM_PORTS_H

/*!
  \file
  \brief COM |[gꗗ̎擾

  \author Satofumi KAMIMURA

  $Id: FindComPorts.h 1192 2009-07-30 09:10:18Z satofumi $

  \attention mF Windows XP ̂݁Bł͖
*/

#include <string>
#include <vector>
#include <memory>


namespace qrk
{
  class IsUsbCom;


  /*!
    \brief VA|[g̒Ts

    Windows ł́AWXg COM ꗗ擾ĕԂB\n
    Linux, MacOS ł́A^ꂽp^[Ɉvt@C擾ĕԂB
  */
  class FindComPorts
  {
    FindComPorts(const FindComPorts& rhs);
    FindComPorts& operator = (const FindComPorts& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    FindComPorts(IsUsbCom* is_usb = NULL);
    ~FindComPorts(void);

    void clear(void);
    void addBaseName(const char* base_name);
    std::vector<std::string> baseNames(void);

    /*!
      \brief COM |[gꗗ̎擾

      \retval COM ꗗi[ꂽ string z
    */
    size_t find(std::vector<std::string>& ports);
  };
}

#endif /* !QRK_FIND_COM_PORTS_H */
