#ifndef QRK_DIFFERENTIAL_DRIVE_H
#define QRK_DIFFERENTIAL_DRIVE_H

/*!
  \file
  \brief Ɨ쓮ւ̐

  \author Satofumi KAMIMURA

  $Id: DifferentialDrive.h 1199 2009-08-02 01:17:07Z satofumi $
*/

#include "Coordinate.h"
#include "Running.h"
#if 0
#include "motor_t.h"
#include "encoder_t.h"
#include "wheel_t.h"
#include "body_t.h"
#endif


namespace qrk
{
  //! Ɨ쓮ւ̐
  class DifferentialDrive : public Coordinate, public Running
  {
    DifferentialDrive(const DifferentialDrive& rhs);
    DifferentialDrive& operator = (const DifferentialDrive& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    enum {
      DefaultBaudrate = 115200, // [bps]
    };
    DifferentialDrive(void);
    ~DifferentialDrive(void);

    const char* what(void) const;

    bool connect(const char* device, long baudrate = DefaultBaudrate);
    void disconnect(void);
    bool isConnected(void) const;
    void setConnection(Connection* connection);
    Connection* connection(void);

    void followLine(const Position<long>& line,
                    const Coordinate* coordinate = NULL);
    void stopLine(const Position<long>& line,
                  const Coordinate* coordinate = NULL);
    void followCircle(const Point<long>& center, long radius,
                      const Coordinate* coordinate = NULL);
    void stopCircle(const Point<long>& center, long radius, const Angle& angle,
                    const Coordinate* coordinate = NULL);
    void spin(const Angle& angle_per_sec);
    void rotate(const Angle& angle, const Coordinate* coordinate = NULL);

    void stop(void);

    Position<long> position(Coordinate* coordinate = NULL) const;
    long straightVelocity(void) const;
    Angle rotateVelocity(void) const;

    void setRobotPosition(const Position<long>& position,
                          const Coordinate* coordinate);
    void setStraightVelocity(long mm_per_sec);
    void setRotateVelocity(const Angle& angle_per_sec);
    void setStraightAcceleration(long mm_per_sec2);
    void setRotateAcceleration(const Angle& angle_per_sec2);

    bool isStable(void) const;

    void setWheelVelocity(int id, long mm_per_sec);


    /*!
      \brief ݏĂړR}hԂ

      \return ړR}h̕

      Example
      \code
run.followLine(Position<long>(0, 0, deg(45)));

cout << run.currentCommand() << endl;
// "followLine()" \endcode
    */
    std::string currentCommand(void) const;


    /*!
      \brief ݏĂړR}hX^bNɐς
    */
    void saveCommand(void);


    /*!
      \brief X^bN̈ړR}hĕ]
    */
    void restoreCommand(void);


    /*!
      \brief p[^̍ČvZ𑖍sRg[Ɏw
    */
    void commitParameters(void);


#if 0
    /*!
      \brief [^Ep[^̓o^

      \param[in] id [^ ID
      \param[in] motor [^
    */
    void setMotorParameter(int id, const motor_t& motor);


    /*!
      \brief GR[_Ep[^̓o^

      \param[in] id GR[_ ID
      \param[in] encoder GR[_
    */
    void setEncoderParameter(int id, const encoder_t& encoder);


    /*!
      \brief ԗփp[^̓o^

      \param[in] id ԗ ID
      \param[in] wheel ԗւ̏
    */
    void setWheelParameter(int id, const wheel_t& wheel);


    /*!
      \brief ➑̃p[^̓o^

      \param[in] body ➑̂̏
    */
    void setBodyParameter(const body_t& body);
#endif
  };
}

#endif /* !QRK_DIFFERENTIAL_DRIVE_H */
