-- Lua スクリプトの利用サンプル
-- $Id: scriptSample.lua 1240 2009-08-22 08:55:11Z satofumi $

-- 接続
local run = mDifferentialDrive()
if not run:connect("/dev/usb/ttyUSB0", 115200) then
   print("DifferentialDrive::connect", run:what())
   return 1
end

local urg = mUrgDistance()
if not urg:connect("/dev/ttyACM0", 115200) then
   print("UrgDistance::connect", urg:what())
   return 1
end


-- 移動開始
run:followLine(Position(0, 0, deg(0)), nil) -- 直線追従
--run:followCircle(Point(0, 1000), 700, nil) -- 円弧追従

-- 前方に障害物を検出するまで移動し続ける
local StopDistance = 500        -- [mm]
local min_distance = urg:minDistance() -- 距離として有効な最小の値を取得
local front_index = urg:deg2index(0)
repeat
   urg:requestData()
   urg:receiveData()
   local front_length = urg:at(front_index)
   print(front_length .. " [mm]")
until (front_length > min_distance) and (front_length < StopDistance)

run:stop()
