#ifndef WII_POSE_DRAW_H
#define WII_POSE_DRAW_H

/*!
  \file
  \brief wii リモコン姿勢の OpenGL 表示

  \author Satofumi KAMIMURA

  $Id$
*/

#include <QGLWidget>


class WiiPoseDraw : public QGLWidget {
  Q_OBJECT;

  WiiPoseDraw(const WiiPoseDraw& rhs);
  WiiPoseDraw& operator = (const WiiPoseDraw& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

  void initializeGL(void);

  QSize minimumSizeHint(void) const;
  QSize sizeHint(void) const;

  void resizeGL(int width, int height);
  void paintGL(void);

public:
  WiiPoseDraw(QWidget* parent = 0);
  ~WiiPoseDraw(void);

  void rotate(int x, int y, int z);
};

#endif /* !WII_POSE_DRAW_H */
