/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.qrcode.codec.ecc;

public class ReedSolomon {
    int[] y;
    int[] gexp = new int[512];
    int[] glog = new int[256];
    final int NPAR;
    final int MAXDEG;
    int[] synBytes = new int[8];
    int[] Lambda = new int[8];
    int[] Omega = new int[8];
    int[] ErrorLocs = new int[256];
    int NErrors;
    int[] ErasureLocs = new int[256];
    int NErasures = 0;

    void initializeGaloisTables() {
        int p8 = 0;
        int p7 = 0;
        int p6 = 0;
        int p5 = 0;
        int p4 = 0;
        int p3 = 0;
        int p2 = 0;
        int pinit = 0;
        int p1 = 1;
        this.gexp[0] = 1;
        this.gexp[255] = this.gexp[0];
        this.glog[0] = 0;
        int i = 1;
        while (i < 256) {
            pinit = p8;
            p8 = p7;
            p7 = p6;
            p6 = p5;
            p5 = p4 ^ pinit;
            p4 = p3 ^ pinit;
            p3 = p2 ^ pinit;
            p2 = p1;
            p1 = pinit;
            this.gexp[i] = p1 + p2 * 2 + p3 * 4 + p4 * 8 + p5 * 16 + p6 * 32 + p7 * 64 + p8 * 128;
            this.gexp[i + 255] = this.gexp[i];
            ++i;
        }
        i = 1;
        while (i < 256) {
            int z = 0;
            while (z < 256) {
                if (this.gexp[z] == i) {
                    this.glog[i] = z;
                    break;
                }
                ++z;
            }
            ++i;
        }
    }

    int gmult(int a, int b) {
        if (a == 0 || b == 0) {
            return 0;
        }
        int i = this.glog[a];
        int j = this.glog[b];
        return this.gexp[i + j];
    }

    int ginv(int elt) {
        return this.gexp[255 - this.glog[elt]];
    }

    public ReedSolomon(int[] source) {
        this.NPAR = 4;
        this.MAXDEG = 8;
        this.initializeGaloisTables();
        this.y = source;
    }

    void decode_data(int[] data) {
        int j = 0;
        while (j < 8) {
            int sum = 0;
            int i = 0;
            while (i < data.length) {
                sum = data[i] ^ this.gmult(this.gexp[j + 1], sum);
                ++i;
            }
            this.synBytes[j] = sum;
            ++j;
        }
    }

    public void correct() {
        this.decode_data(this.y);
        boolean hasError = false;
        int i = 0;
        while (i < this.synBytes.length) {
            if (this.synBytes[i] != 0) {
                hasError = true;
            }
            ++i;
        }
        if (hasError) {
            this.correct_errors_erasures(this.y, this.y.length, 0, new int[1]);
        }
    }

    public int getNumCorrectedErrors() {
        return this.NErrors;
    }

    void Modified_Berlekamp_Massey() {
        int i;
        int[] psi = new int[8];
        int[] psi2 = new int[8];
        int[] D = new int[8];
        int[] gamma = new int[8];
        this.init_gamma(gamma);
        this.copy_poly(D, gamma);
        this.mul_z_poly(D);
        this.copy_poly(psi, gamma);
        int k = -1;
        int L = this.NErasures;
        int n = this.NErasures;
        while (n < 8) {
            int d = this.compute_discrepancy(psi, this.synBytes, L, n);
            if (d != 0) {
                i = 0;
                while (i < 8) {
                    psi2[i] = psi[i] ^ this.gmult(d, D[i]);
                    ++i;
                }
                if (L < n - k) {
                    int L2 = n - k;
                    k = n - L;
                    i = 0;
                    while (i < 8) {
                        D[i] = this.gmult(psi[i], this.ginv(d));
                        ++i;
                    }
                    L = L2;
                }
                i = 0;
                while (i < 8) {
                    psi[i] = psi2[i];
                    ++i;
                }
            }
            this.mul_z_poly(D);
            ++n;
        }
        i = 0;
        while (i < 8) {
            this.Lambda[i] = psi[i];
            ++i;
        }
        this.compute_modified_omega();
    }

    void compute_modified_omega() {
        int[] product = new int[16];
        this.mult_polys(product, this.Lambda, this.synBytes);
        this.zero_poly(this.Omega);
        int i = 0;
        while (i < 4) {
            this.Omega[i] = product[i];
            ++i;
        }
    }

    void mult_polys(int[] dst, int[] p1, int[] p2) {
        int[] tmp1 = new int[16];
        int i = 0;
        while (i < 16) {
            dst[i] = 0;
            ++i;
        }
        i = 0;
        while (i < 8) {
            int j = 8;
            while (j < 16) {
                tmp1[j] = 0;
                ++j;
            }
            j = 0;
            while (j < 8) {
                tmp1[j] = this.gmult(p2[j], p1[i]);
                ++j;
            }
            j = 15;
            while (j >= i) {
                tmp1[j] = tmp1[j - i];
                --j;
            }
            j = 0;
            while (j < i) {
                tmp1[j] = 0;
                ++j;
            }
            j = 0;
            while (j < 16) {
                int n = j;
                dst[n] = dst[n] ^ tmp1[j];
                ++j;
            }
            ++i;
        }
    }

    void init_gamma(int[] gamma) {
        int[] tmp = new int[8];
        this.zero_poly(gamma);
        this.zero_poly(tmp);
        gamma[0] = 1;
        int e = 0;
        while (e < this.NErasures) {
            this.copy_poly(tmp, gamma);
            this.scale_poly(this.gexp[this.ErasureLocs[e]], tmp);
            this.mul_z_poly(tmp);
            this.add_polys(gamma, tmp);
            ++e;
        }
    }

    void compute_next_omega(int d, int[] A, int[] dst, int[] src) {
        int i = 0;
        while (i < 8) {
            dst[i] = src[i] ^ this.gmult(d, A[i]);
            ++i;
        }
    }

    int compute_discrepancy(int[] lambda, int[] S, int L, int n) {
        int sum = 0;
        int i = 0;
        while (i <= L) {
            sum ^= this.gmult(lambda[i], S[n - i]);
            ++i;
        }
        return sum;
    }

    void add_polys(int[] dst, int[] src) {
        int i = 0;
        while (i < 8) {
            int n = i;
            dst[n] = dst[n] ^ src[i];
            ++i;
        }
    }

    void copy_poly(int[] dst, int[] src) {
        int i = 0;
        while (i < 8) {
            dst[i] = src[i];
            ++i;
        }
    }

    void scale_poly(int k, int[] poly) {
        int i = 0;
        while (i < 8) {
            poly[i] = this.gmult(k, poly[i]);
            ++i;
        }
    }

    void zero_poly(int[] poly) {
        int i = 0;
        while (i < 8) {
            poly[i] = 0;
            ++i;
        }
    }

    void mul_z_poly(int[] src) {
        int i = 7;
        while (i > 0) {
            src[i] = src[i - 1];
            --i;
        }
        src[0] = 0;
    }

    void Find_Roots() {
        this.NErrors = 0;
        int r = 1;
        while (r < 256) {
            int sum = 0;
            int k = 0;
            while (k < 5) {
                sum ^= this.gmult(this.gexp[k * r % 255], this.Lambda[k]);
                ++k;
            }
            if (sum == 0) {
                this.ErrorLocs[this.NErrors] = 255 - r;
                ++this.NErrors;
            }
            ++r;
        }
    }

    int correct_errors_erasures(int[] codeword, int csize, int nerasures, int[] erasures) {
        this.NErasures = nerasures;
        int i = 0;
        while (i < this.NErasures) {
            this.ErasureLocs[i] = erasures[i];
            ++i;
        }
        this.Modified_Berlekamp_Massey();
        this.Find_Roots();
        if (this.NErrors <= 4 && this.NErrors > 0) {
            int r = 0;
            while (r < this.NErrors) {
                if (this.ErrorLocs[r] >= csize) {
                    return 0;
                }
                ++r;
            }
            r = 0;
            while (r < this.NErrors) {
                i = this.ErrorLocs[r];
                int num = 0;
                int j = 0;
                while (j < 8) {
                    num ^= this.gmult(this.Omega[j], this.gexp[(255 - i) * j % 255]);
                    ++j;
                }
                int denom = 0;
                j = 1;
                while (j < 8) {
                    denom ^= this.gmult(this.Lambda[j], this.gexp[(255 - i) * (j - 1) % 255]);
                    j += 2;
                }
                int err = this.gmult(num, this.ginv(denom));
                int n = csize - i - 1;
                codeword[n] = codeword[n] ^ err;
                ++r;
            }
            return 1;
        }
        return 0;
    }
}

