/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.qrcode.codec.reader;

import jp.sourceforge.qrcode.codec.QRCodeDecoder;
import jp.sourceforge.qrcode.codec.data.QRCodeSymbol;
import jp.sourceforge.qrcode.codec.exception.AlignmentPatternNotFoundException;
import jp.sourceforge.qrcode.codec.exception.FinderPatternNotFoundException;
import jp.sourceforge.qrcode.codec.exception.SymbolNotFoundException;
import jp.sourceforge.qrcode.codec.exception.VersionInformationException;
import jp.sourceforge.qrcode.codec.geom.Axis;
import jp.sourceforge.qrcode.codec.geom.Line;
import jp.sourceforge.qrcode.codec.geom.Point;
import jp.sourceforge.qrcode.codec.geom.SamplingGrid;
import jp.sourceforge.qrcode.codec.reader.pattern.AlignmentPattern;
import jp.sourceforge.qrcode.codec.reader.pattern.FinderPattern;
import jp.sourceforge.qrcode.codec.util.DebugCanvas;
import jp.sourceforge.qrcode.codec.util.QRCodeUtility;

public class QRCodeImageReader {
    DebugCanvas canvas = QRCodeDecoder.getCanvas();
    public static int DECIMAL_POINT = 21;
    public static final boolean POINT_DARK = true;
    public static final boolean POINT_LIGHT = false;

    boolean[][] applyMedianFilter(boolean[][] image, int threshold) {
        boolean[][] filteredMatrix = new boolean[image.length][image[0].length];
        int y = 1;
        while (y < image[0].length - 1) {
            int x = 1;
            while (x < image.length - 1) {
                int numPointDark = 0;
                int fy = -1;
                while (fy < 2) {
                    int fx = -1;
                    while (fx < 2) {
                        if (image[x + fx][y + fy]) {
                            ++numPointDark;
                        }
                        ++fx;
                    }
                    ++fy;
                }
                if (numPointDark > threshold) {
                    filteredMatrix[x][y] = true;
                }
                ++x;
            }
            ++y;
        }
        return filteredMatrix;
    }

    boolean[][] processImage(int[][] image) {
        this.imageToGrayScale(image);
        boolean[][] bitmap = this.grayScaleToBitmap(image);
        return bitmap;
    }

    void imageToGrayScale(int[][] image) {
        int y = 0;
        while (y < image[0].length) {
            int x = 0;
            while (x < image.length) {
                int m;
                int r = image[x][y] >> 16 & 0xFF;
                int g = image[x][y] >> 8 & 0xFF;
                int b = image[x][y] & 0xFF;
                image[x][y] = m = (r * 30 + g * 59 + b * 11) / 100;
                ++x;
            }
            ++y;
        }
    }

    boolean[][] grayScaleToBitmap(int[][] grayScale) {
        int[][] middle = this.getMiddleBrightnessPerArea(grayScale);
        int sqrtNumArea = middle.length;
        int areaWidth = grayScale.length / sqrtNumArea;
        int areaHeight = grayScale[0].length / sqrtNumArea;
        boolean[][] bitmap = new boolean[grayScale.length][grayScale[0].length];
        int ay = 0;
        while (ay < sqrtNumArea) {
            int ax = 0;
            while (ax < sqrtNumArea) {
                int dy = 0;
                while (dy < areaHeight) {
                    int dx = 0;
                    while (dx < areaWidth) {
                        bitmap[areaWidth * ax + dx][areaHeight * ay + dy] = grayScale[areaWidth * ax + dx][areaHeight * ay + dy] < middle[ax][ay];
                        ++dx;
                    }
                    ++dy;
                }
                ++ax;
            }
            ++ay;
        }
        return bitmap;
    }

    int[][] getMiddleBrightnessPerArea(int[][] image) {
        int numSqrtArea = 4;
        int areaWidth = image.length / 4;
        int areaHeight = image[0].length / 4;
        int[][][] minmax = new int[4][4][2];
        int ay = 0;
        while (ay < 4) {
            int ax = 0;
            while (ax < 4) {
                minmax[ax][ay][0] = 255;
                int dy = 0;
                while (dy < areaHeight) {
                    int dx = 0;
                    while (dx < areaWidth) {
                        int target = image[areaWidth * ax + dx][areaHeight * ay + dy];
                        if (target < minmax[ax][ay][0]) {
                            minmax[ax][ay][0] = target;
                        }
                        if (target > minmax[ax][ay][1]) {
                            minmax[ax][ay][1] = target;
                        }
                        ++dx;
                    }
                    ++dy;
                }
                ++ax;
            }
            ++ay;
        }
        int[][] middle = new int[4][4];
        int ay2 = 0;
        while (ay2 < 4) {
            int ax = 0;
            while (ax < 4) {
                middle[ax][ay2] = (minmax[ax][ay2][0] + minmax[ax][ay2][1]) / 2;
                ++ax;
            }
            ++ay2;
        }
        return middle;
    }

    public QRCodeSymbol getQRCodeSymbol(int[][] image) throws SymbolNotFoundException {
        int longSide = image.length < image[0].length ? image[0].length : image.length;
        DECIMAL_POINT = 23 - QRCodeUtility.sqrt(longSide / 256);
        boolean[][] bitmap = this.processImage(image);
        this.canvas.println("Drawing matrix.");
        this.canvas.drawMatrix(bitmap);
        this.canvas.println("Scanning Finder Pattern.");
        FinderPattern finderPattern = null;
        try {
            finderPattern = FinderPattern.findFinderPattern(bitmap);
        }
        catch (FinderPatternNotFoundException e) {
            this.canvas.println("Not found, now retrying...");
            bitmap = this.applyMedianFilter(bitmap, 5);
            this.canvas.drawMatrix(bitmap);
            try {
                finderPattern = FinderPattern.findFinderPattern(bitmap);
            }
            catch (FinderPatternNotFoundException e2) {
                throw new SymbolNotFoundException(e2.getMessage());
            }
            catch (VersionInformationException e2) {
                throw new SymbolNotFoundException(e2.getMessage());
            }
        }
        catch (VersionInformationException e) {
            throw new SymbolNotFoundException(e.getMessage());
        }
        this.canvas.println("FinderPattern at");
        String finderPatternCoordinates = String.valueOf(finderPattern.getCenter(0).toString()) + finderPattern.getCenter(1).toString() + finderPattern.getCenter(2).toString();
        this.canvas.println(finderPatternCoordinates);
        int[] sincos = finderPattern.getAngle();
        this.canvas.println("Angle*4098: Sin " + Integer.toString(sincos[0]) + "  " + "Cos " + Integer.toString(sincos[1]));
        SamplingGrid samplingGrid = new SamplingGrid(1);
        int version = finderPattern.getVersion();
        this.canvas.println("Version: " + Integer.toString(version));
        AlignmentPattern alignmentPattern = null;
        if (version > 1) {
            try {
                alignmentPattern = AlignmentPattern.findAlignmentPattern(bitmap, finderPattern);
            }
            catch (AlignmentPatternNotFoundException e) {
                throw new SymbolNotFoundException(e.getMessage());
            }
            int matrixLength = alignmentPattern.getCenter().length;
            this.canvas.println("AlignmentPatterns at");
            int y = 0;
            while (y < matrixLength) {
                String alignmentPatternCoordinates = "";
                int x = 0;
                while (x < matrixLength) {
                    alignmentPatternCoordinates = String.valueOf(alignmentPatternCoordinates) + alignmentPattern.getCenter()[x][y].toString();
                    ++x;
                }
                this.canvas.println(alignmentPatternCoordinates);
                ++y;
            }
        }
        this.canvas.println("Creating sampling grid.");
        if (version == 1) {
            samplingGrid = this.getSamplingGrid1(finderPattern);
        } else if (version >= 2 && version <= 40) {
            samplingGrid = this.getSamplingGrid(finderPattern, alignmentPattern);
        }
        this.canvas.println("Reading grid.");
        boolean[][] qRCodeMatrix = this.getQRCodeMatrix(bitmap, samplingGrid);
        return new QRCodeSymbol(qRCodeMatrix);
    }

    SamplingGrid getSamplingGrid1(FinderPattern finderPattern) {
        int sqrtNumArea = 1;
        int sqrtNumModules = finderPattern.getSqrtNumModules();
        int sqrtNumAreaModules = sqrtNumModules / sqrtNumArea;
        Point[] centers = finderPattern.getCenter();
        int logicalDistance = 14;
        SamplingGrid samplingGrid = new SamplingGrid(sqrtNumArea);
        ModulePitch modulePitch = new ModulePitch();
        modulePitch.top = this.getAreaModulePitch(centers[0], centers[1], logicalDistance);
        modulePitch.left = this.getAreaModulePitch(centers[0], centers[2], logicalDistance);
        Line baseLineX = new Line(finderPattern.getCenter(0), finderPattern.getCenter(2));
        Axis axis = new Axis(finderPattern.getAngle(), modulePitch.top);
        axis.setOrigin(baseLineX.getP1());
        baseLineX.setP1(axis.translate(-3, -3));
        axis.setModulePitch(modulePitch.left);
        axis.setOrigin(baseLineX.getP2());
        baseLineX.setP2(axis.translate(-3, 3));
        Line baseLineY = new Line(finderPattern.getCenter(0), finderPattern.getCenter(1));
        axis.setModulePitch(modulePitch.left);
        axis.setOrigin(baseLineY.getP1());
        baseLineY.setP1(axis.translate(-3, -3));
        axis.setModulePitch(modulePitch.left);
        axis.setOrigin(baseLineY.getP2());
        baseLineY.setP2(axis.translate(3, -3));
        samplingGrid.initGrid(0, 0, sqrtNumAreaModules, sqrtNumAreaModules);
        int i = 0;
        while (i < sqrtNumAreaModules) {
            Line gridLineX = new Line(baseLineX.getP1(), baseLineX.getP2());
            axis.setOrigin(gridLineX.getP1());
            axis.setModulePitch(modulePitch.top);
            gridLineX.setP1(axis.translate(i, 0));
            axis.setOrigin(gridLineX.getP2());
            axis.setModulePitch(modulePitch.top);
            gridLineX.setP2(axis.translate(i, 0));
            Line gridLineY = new Line(baseLineY.getP1(), baseLineY.getP2());
            axis.setOrigin(gridLineY.getP1());
            axis.setModulePitch(modulePitch.left);
            gridLineY.setP1(axis.translate(0, i));
            axis.setOrigin(gridLineY.getP2());
            axis.setModulePitch(modulePitch.left);
            gridLineY.setP2(axis.translate(0, i));
            samplingGrid.setXLine(0, 0, i, gridLineX);
            samplingGrid.setYLine(0, 0, i, gridLineY);
            ++i;
        }
        int ay = 0;
        while (ay < samplingGrid.getHeight()) {
            int ax = 0;
            while (ax < samplingGrid.getWidth()) {
                this.canvas.drawLines(samplingGrid.getXLines(ax, ay), 0x8888FF);
                this.canvas.drawLines(samplingGrid.getYLines(ax, ay), 0x8888FF);
                ++ax;
            }
            ++ay;
        }
        return samplingGrid;
    }

    SamplingGrid getSamplingGrid(FinderPattern finderPattern, AlignmentPattern alignmentPattern) {
        Point[][] centers = alignmentPattern.getCenter();
        int version = finderPattern.getVersion();
        int sqrtCenters = version / 7 + 2;
        centers[0][0] = finderPattern.getCenter(0);
        centers[sqrtCenters - 1][0] = finderPattern.getCenter(1);
        centers[0][sqrtCenters - 1] = finderPattern.getCenter(2);
        int sqrtNumArea = sqrtCenters - 1;
        SamplingGrid samplingGrid = new SamplingGrid(sqrtNumArea);
        Axis axis = new Axis(finderPattern.getAngle(), finderPattern.getModuleSize());
        int ay = 0;
        while (ay < sqrtNumArea) {
            int ax = 0;
            while (ax < sqrtNumArea) {
                ModulePitch modulePitch = new ModulePitch();
                Line baseLineX = new Line();
                Line baseLineY = new Line();
                axis.setModulePitch(finderPattern.getModuleSize());
                Point[][] logicalCenters = AlignmentPattern.getLogicalCenter(finderPattern);
                Point upperLeftPoint = centers[ax][ay];
                Point upperRightPoint = centers[ax + 1][ay];
                Point lowerLeftPoint = centers[ax][ay + 1];
                Point lowerRightPoint = centers[ax + 1][ay + 1];
                Point logicalUpperLeftPoint = logicalCenters[ax][ay];
                Point logicalUpperRightPoint = logicalCenters[ax + 1][ay];
                Point logicalLowerLeftPoint = logicalCenters[ax][ay + 1];
                Point logicalLowerRightPoint = logicalCenters[ax + 1][ay + 1];
                if (ax == 0 && ay == 0) {
                    if (sqrtNumArea == 1) {
                        upperLeftPoint = axis.translate(upperLeftPoint, -3, -3);
                        upperRightPoint = axis.translate(upperRightPoint, 3, -3);
                        lowerLeftPoint = axis.translate(lowerLeftPoint, -3, 3);
                        lowerRightPoint = axis.translate(lowerRightPoint, 6, 6);
                        logicalUpperLeftPoint.translate(-6, -6);
                        logicalUpperRightPoint.translate(3, -3);
                        logicalLowerLeftPoint.translate(-3, 3);
                        logicalLowerRightPoint.translate(6, 6);
                    } else {
                        upperLeftPoint = axis.translate(upperLeftPoint, -3, -3);
                        upperRightPoint = axis.translate(upperRightPoint, 0, -6);
                        lowerLeftPoint = axis.translate(lowerLeftPoint, -6, 0);
                        logicalUpperLeftPoint.translate(-6, -6);
                        logicalUpperRightPoint.translate(0, -6);
                        logicalLowerLeftPoint.translate(-6, 0);
                    }
                } else if (ax == 0 && ay == sqrtNumArea - 1) {
                    upperLeftPoint = axis.translate(upperLeftPoint, -6, 0);
                    lowerLeftPoint = axis.translate(lowerLeftPoint, -3, 3);
                    lowerRightPoint = axis.translate(lowerRightPoint, 0, 6);
                    logicalUpperLeftPoint.translate(-6, 0);
                    logicalLowerLeftPoint.translate(-6, 6);
                    logicalLowerRightPoint.translate(0, 6);
                } else if (ax == sqrtNumArea - 1 && ay == 0) {
                    upperLeftPoint = axis.translate(upperLeftPoint, 0, -6);
                    upperRightPoint = axis.translate(upperRightPoint, 3, -3);
                    lowerRightPoint = axis.translate(lowerRightPoint, 6, 0);
                    logicalUpperLeftPoint.translate(0, -6);
                    logicalUpperRightPoint.translate(6, -6);
                    logicalLowerRightPoint.translate(6, 0);
                } else if (ax == sqrtNumArea - 1 && ay == sqrtNumArea - 1) {
                    lowerLeftPoint = axis.translate(lowerLeftPoint, 0, 6);
                    upperRightPoint = axis.translate(upperRightPoint, 6, 0);
                    lowerRightPoint = axis.translate(lowerRightPoint, 6, 6);
                    logicalLowerLeftPoint.translate(0, 6);
                    logicalUpperRightPoint.translate(6, 0);
                    logicalLowerRightPoint.translate(6, 6);
                } else if (ax == 0) {
                    upperLeftPoint = axis.translate(upperLeftPoint, -6, 0);
                    lowerLeftPoint = axis.translate(lowerLeftPoint, -6, 0);
                    logicalUpperLeftPoint.translate(-6, 0);
                    logicalLowerLeftPoint.translate(-6, 0);
                } else if (ax == sqrtNumArea - 1) {
                    upperRightPoint = axis.translate(upperRightPoint, 6, 0);
                    lowerRightPoint = axis.translate(lowerRightPoint, 6, 0);
                    logicalUpperRightPoint.translate(6, 0);
                    logicalLowerRightPoint.translate(6, 0);
                } else if (ay == 0) {
                    upperLeftPoint = axis.translate(upperLeftPoint, 0, -6);
                    upperRightPoint = axis.translate(upperRightPoint, 0, -6);
                    logicalUpperLeftPoint.translate(0, -6);
                    logicalUpperRightPoint.translate(0, -6);
                } else if (ay == sqrtNumArea - 1) {
                    lowerLeftPoint = axis.translate(lowerLeftPoint, 0, 6);
                    lowerRightPoint = axis.translate(lowerRightPoint, 0, 6);
                    logicalLowerLeftPoint.translate(0, 6);
                    logicalLowerRightPoint.translate(0, 6);
                }
                if (ax == 0) {
                    logicalUpperRightPoint.translate(1, 0);
                    logicalLowerRightPoint.translate(1, 0);
                } else {
                    logicalUpperLeftPoint.translate(-1, 0);
                    logicalLowerLeftPoint.translate(-1, 0);
                }
                if (ay == 0) {
                    logicalLowerLeftPoint.translate(0, 1);
                    logicalLowerRightPoint.translate(0, 1);
                } else {
                    logicalUpperLeftPoint.translate(0, -1);
                    logicalUpperRightPoint.translate(0, -1);
                }
                int logicalWidth = logicalUpperRightPoint.getX() - logicalUpperLeftPoint.getX();
                int logicalHeight = logicalLowerLeftPoint.getY() - logicalUpperLeftPoint.getY();
                if (version < 7) {
                    logicalWidth += 3;
                    logicalHeight += 3;
                }
                modulePitch.top = this.getAreaModulePitch(upperLeftPoint, upperRightPoint, logicalWidth - 1);
                modulePitch.left = this.getAreaModulePitch(upperLeftPoint, lowerLeftPoint, logicalHeight - 1);
                modulePitch.bottom = this.getAreaModulePitch(lowerLeftPoint, lowerRightPoint, logicalWidth - 1);
                modulePitch.right = this.getAreaModulePitch(upperRightPoint, lowerRightPoint, logicalHeight - 1);
                baseLineX.setP1(upperLeftPoint);
                baseLineY.setP1(upperLeftPoint);
                baseLineX.setP2(lowerLeftPoint);
                baseLineY.setP2(upperRightPoint);
                samplingGrid.initGrid(ax, ay, logicalWidth, logicalHeight);
                int i = 0;
                while (i < logicalWidth) {
                    Line gridLineX = new Line(baseLineX.getP1(), baseLineX.getP2());
                    axis.setOrigin(gridLineX.getP1());
                    axis.setModulePitch(modulePitch.top);
                    gridLineX.setP1(axis.translate(i, 0));
                    axis.setOrigin(gridLineX.getP2());
                    axis.setModulePitch(modulePitch.bottom);
                    gridLineX.setP2(axis.translate(i, 0));
                    samplingGrid.setXLine(ax, ay, i, gridLineX);
                    ++i;
                }
                i = 0;
                while (i < logicalHeight) {
                    Line gridLineY = new Line(baseLineY.getP1(), baseLineY.getP2());
                    axis.setOrigin(gridLineY.getP1());
                    axis.setModulePitch(modulePitch.left);
                    gridLineY.setP1(axis.translate(0, i));
                    axis.setOrigin(gridLineY.getP2());
                    axis.setModulePitch(modulePitch.right);
                    gridLineY.setP2(axis.translate(0, i));
                    samplingGrid.setYLine(ax, ay, i, gridLineY);
                    ++i;
                }
                ++ax;
            }
            ++ay;
        }
        return samplingGrid;
    }

    int getAreaModulePitch(Point start, Point end, int logicalDistance) {
        Line tempLine = new Line(start, end);
        int realDistance = tempLine.getLength();
        int modulePitch = (realDistance << DECIMAL_POINT) / logicalDistance;
        return modulePitch;
    }

    boolean[][] getQRCodeMatrix(boolean[][] image, SamplingGrid gridLines) throws ArrayIndexOutOfBoundsException {
        int gridSize = gridLines.getTotalWidth();
        this.canvas.println("gridSize=" + gridSize);
        boolean[][] sampledMatrix = new boolean[gridSize][gridSize];
        int ay = 0;
        while (ay < gridLines.getHeight()) {
            int ax = 0;
            while (ax < gridLines.getWidth()) {
                int y = 0;
                while (y < gridLines.getHeight(ax, ay)) {
                    int x = 0;
                    while (x < gridLines.getWidth(ax, ay)) {
                        int x1 = gridLines.getXLine(ax, ay, x).getP1().getX();
                        int y1 = gridLines.getXLine(ax, ay, x).getP1().getY();
                        int x2 = gridLines.getXLine(ax, ay, x).getP2().getX();
                        int y2 = gridLines.getXLine(ax, ay, x).getP2().getY();
                        int x3 = gridLines.getYLine(ax, ay, y).getP1().getX();
                        int y3 = gridLines.getYLine(ax, ay, y).getP1().getY();
                        int x4 = gridLines.getYLine(ax, ay, y).getP2().getX();
                        int y4 = gridLines.getYLine(ax, ay, y).getP2().getY();
                        int e = (y2 - y1) * (x3 - x4) - (y4 - y3) * (x1 - x2);
                        int f = (x1 * y2 - x2 * y1) * (x3 - x4) - (x3 * y4 - x4 * y3) * (x1 - x2);
                        int g = (x3 * y4 - x4 * y3) * (y2 - y1) - (x1 * y2 - x2 * y1) * (y4 - y3);
                        try {
                            sampledMatrix[gridLines.getX((int)ax, (int)x)][gridLines.getY((int)ay, (int)y)] = image[f / e][g / e];
                        }
                        catch (ArrayIndexOutOfBoundsException imageOverflowException) {
                            sampledMatrix[gridLines.getX((int)ax, (int)x)][gridLines.getY((int)ay, (int)y)] = false;
                        }
                        if (sampledMatrix[gridLines.getX(ax, x)][gridLines.getY(ay, y)]) {
                            this.canvas.drawPoint(new Point(f / e, g / e), 0x444444);
                        } else {
                            this.canvas.drawPoint(new Point(f / e, g / e), 0xBBBBBB);
                        }
                        ++x;
                    }
                    ++y;
                }
                ++ax;
            }
            ++ay;
        }
        return sampledMatrix;
    }

    private class ModulePitch {
        public int top;
        public int left;
        public int bottom;
        public int right;

        private ModulePitch() {
        }
    }
}

