/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.localstore;

import com.qbrowser.QBrowserV2;
import com.qbrowser.localstore.LocalMessageContainer;
import com.qbrowser.localstore.LocalStoreDef;
import com.qbrowser.localstore.LocalStoreProperty;
import com.qbrowser.persist.BytesMessagePersister;
import com.qbrowser.persist.MapMessagePersister;
import com.qbrowser.persist.MessagePersister;
import com.qbrowser.persist.ObjectMessagePersister;
import com.qbrowser.persist.StreamMessagePersister;
import com.qbrowser.persist.TextMessagePersister;
import com.qbrowser.util.QBrowserUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.jms.BytesMessage;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.swing.JDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalStoreManager {
    private LocalStoreDef lsd;
    private static HashMap local_store_index = new HashMap();
    private static ResourceBundle resources = QBrowserV2.resources;
    private static HashMap destName_LocalSubscriptionDest = new HashMap();
    private static String saved_def_name;

    /*
     * WARNING - void declaration
     */
    public LocalStoreManager(String id) {
        void var1_1;
        local_store_index = new HashMap();
        destName_LocalSubscriptionDest = new HashMap();
        this.lsd = new LocalStoreDef();
        saved_def_name = QBrowserUtil.getQBrowserTempFileDir() + "localstoredef" + id;
        File lsdef = new File(saved_def_name);
        if (!lsdef.exists()) {
            File qvd = new File(QBrowserUtil.getQBrowserTempFileDir());
            if (!qvd.exists()) {
                qvd.mkdirs();
            }
            LocalStoreProperty lsp1 = new LocalStoreProperty();
            lsp1.setDestName("TMPWORK");
            lsp1.setReal_file_directory(QBrowserUtil.getQBrowserTempFileDir() + "tmpwork_localstore");
            lsp1.setValid(true);
            this.lsd.setLocalStoreProperty(lsp1);
            this.lsd.save(new File(saved_def_name));
            return;
        }
        this.lsd.readAndParseLocalStoreDefFile((File)var1_1, destName_LocalSubscriptionDest);
    }

    public static void addMsgIndex(String puredest, String msgid, String msg_filepath) {
        HashMap<String, String> msgid_filepath = (HashMap<String, String>)local_store_index.get(puredest);
        if (msgid_filepath == null) {
            msgid_filepath = new HashMap<String, String>();
        }
        msgid_filepath.put(msgid, msg_filepath);
        local_store_index.put(puredest, msgid_filepath);
    }

    public final ArrayList<String> getAllLocalStoreNames() {
        LocalStoreDef localStoreDef = this.lsd;
        Collection col1 = localStoreDef.local_store_properties_map.values();
        Iterator icol1 = col1.iterator();
        ArrayList<String> retval = new ArrayList<String>();
        while (icol1.hasNext()) {
            LocalStoreProperty lsp = (LocalStoreProperty)icol1.next();
            retval.add(lsp.getDestName());
        }
        Collections.sort(retval);
        return retval;
    }

    public final ArrayList<String> getAllValidLocalStoreNames() {
        LocalStoreDef localStoreDef = this.lsd;
        Collection col1 = localStoreDef.local_store_properties_map.values();
        Iterator icol1 = col1.iterator();
        ArrayList<String> retval = new ArrayList<String>();
        while (icol1.hasNext()) {
            LocalStoreProperty lsp = (LocalStoreProperty)icol1.next();
            if (!lsp.isValid()) continue;
            retval.add(lsp.getDestName());
        }
        Collections.sort(retval);
        return retval;
    }

    public final Collection<LocalStoreProperty> listLocalStoreProperties() {
        LocalStoreDef localStoreDef = this.lsd;
        return localStoreDef.local_store_properties_map.values();
    }

    public final LocalStoreProperty getLocalStoreProperty(String local_dest_without_suffix) {
        return this.lsd.getLocalStoreProperty(local_dest_without_suffix);
    }

    public final LocalStore getLocalStoreInstance(String local_dest_without_suffix) {
        LocalStoreProperty lsp = this.lsd.getLocalStoreProperty(local_dest_without_suffix);
        try {
            return new LocalStore(lsp);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static ArrayList<String> getCopyToListOfTheDestination(String dest_name_with_suffix) {
        Iterator local_and_selector = (HashMap)destName_LocalSubscriptionDest.get(dest_name_with_suffix);
        ArrayList<String> retval = new ArrayList<String>();
        if (local_and_selector != null) {
            for (String local_dest : ((HashMap)((Object)local_and_selector)).keySet()) {
                retval.add(local_dest);
            }
        }
        return retval;
    }

    public final void addDestCopySubscriptionToLocalStore(String local_store_name_without_suffix, String subscribe_dest_name_with_suffix, String selector) throws Exception {
        LocalStoreProperty lsp = this.lsd.getLocalStoreProperty(local_store_name_without_suffix);
        if (lsp == null) {
            throw new Exception("Local Store not found.");
        }
        if (lsp.getDestNameWithSuffix().equals(subscribe_dest_name_with_suffix)) {
            throw new Exception("Subscription target cannot be itself.");
        }
        HashMap<String, String> local_and_selector = (HashMap<String, String>)destName_LocalSubscriptionDest.get(subscribe_dest_name_with_suffix);
        if (local_and_selector == null) {
            local_and_selector = new HashMap<String, String>();
        }
        local_and_selector.put(local_store_name_without_suffix, selector);
        destName_LocalSubscriptionDest.put(subscribe_dest_name_with_suffix, local_and_selector);
        lsp.addFromDests(subscribe_dest_name_with_suffix, selector);
        this.lsd.setLocalStoreProperty(lsp);
        this.lsd.save(new File(saved_def_name));
    }

    public static void removeRelatedEntryOfSubscribeDest(String subscribe_dest_name_with_suffix) {
        destName_LocalSubscriptionDest.remove(subscribe_dest_name_with_suffix);
    }

    public static void removeDestCopySubscriptionToLocalStore(String local_store_name_without_suffix, String subscribe_dest_name_with_suffix) throws Exception {
        HashMap local_and_selector = (HashMap)destName_LocalSubscriptionDest.get(subscribe_dest_name_with_suffix);
        if (local_and_selector == null) {
            local_and_selector = new HashMap();
        }
        local_and_selector.remove(local_store_name_without_suffix);
        destName_LocalSubscriptionDest.put(subscribe_dest_name_with_suffix, local_and_selector);
    }

    public final void updateAndSaveLocalStoreProperty(LocalStoreProperty lsp) throws Exception {
        if (lsp == null) {
            throw new Exception("LocalStoreProperty is not set.");
        }
        this.lsd.setLocalStoreProperty(lsp);
        this.lsd.save(new File(saved_def_name));
    }

    public final void addNewLocalStoreProperty(LocalStoreProperty lsp) throws Exception {
        if (lsp == null) {
            throw new Exception("LocalStoreProperty is not set.");
        }
        LocalStoreProperty glsp = this.lsd.getLocalStoreProperty(lsp.getDestName());
        if (glsp != null) {
            throw new Exception(resources.getString("qkey.msg.msg299"));
        }
        this.lsd.setLocalStoreProperty(lsp);
        this.lsd.save(new File(saved_def_name));
    }

    public final void removeLocalStoreProperty(LocalStoreProperty lsp) {
        String string = ((LocalStoreProperty)lsp).getDestName();
        lsp = this.lsd;
        ((LocalStoreDef)lsp).local_store_properties_map.remove(string);
        this.lsd.save(new File(saved_def_name));
    }

    public final void clearLocalStore(String local_store_name_without_suffix) throws IOException {
        LocalStoreProperty target = this.lsd.getLocalStoreProperty(local_store_name_without_suffix);
        File targetdir = new File(target.getReal_file_directory());
        if (targetdir.exists() && targetdir.isDirectory()) {
            File[] files = targetdir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getName().endsWith("Message.zip")) continue;
                files[i].delete();
            }
        }
    }

    public static final class LocalStore {
        private static ResourceBundle resources = QBrowserV2.resources;
        private LocalStoreProperty thisproperty;

        public LocalStore(LocalStoreProperty thisvalue) throws Exception {
            if (thisvalue == null) {
                throw new Exception("local store property is not set.");
            }
            this.thisproperty = thisvalue;
        }

        /*
         * WARNING - void declaration
         */
        public final File localMessageToFile(Session session, LocalMessageContainer lmc, StringBuilder sbuf, JDialog cmp) throws Exception {
            void ex2;
            String file_target_string;
            MessagePersister mp;
            File tf = null;
            File workdir = null;
            Message innermessage = lmc.getMessage();
            if (innermessage == null) {
                innermessage = lmc.getRealMessage(session);
            }
            if (innermessage instanceof TextMessage) {
                mp = new TextMessagePersister(lmc);
                mp.setTextBuffer(sbuf);
                try {
                    workdir = ((TextMessagePersister)mp).persistToFile();
                    file_target_string = this.thisproperty.getReal_file_directory() + QBrowserUtil.eliminateDameMoji(lmc.getVmsgid()) + "_TextMessage.zip";
                    tf = new File(file_target_string);
                    mp.zipUp(workdir, tf);
                    sbuf.append(resources.getString("qkey.msg.msg253"));
                    sbuf.append("\n\n");
                    cmp.getRootPane().updateUI();
                    lmc.setReal_file_path(file_target_string);
                    return tf;
                }
                catch (Exception ex2) {
                    mp.cleanupWorkDir(workdir);
                    ex2.printStackTrace();
                }
            } else if (ex2 instanceof BytesMessage) {
                mp = new BytesMessagePersister(lmc);
                mp.setTextBuffer(sbuf);
                try {
                    workdir = ((BytesMessagePersister)mp).persistToFile();
                    file_target_string = this.thisproperty.getReal_file_directory() + QBrowserUtil.eliminateDameMoji(lmc.getVmsgid()) + "_BytesMessage.zip";
                    tf = new File(file_target_string);
                    mp.zipUp(workdir, tf);
                    sbuf.append(resources.getString("qkey.msg.msg253"));
                    sbuf.append("\n\n");
                    cmp.getRootPane().updateUI();
                    lmc.setReal_file_path(file_target_string);
                    return tf;
                }
                catch (Exception ex3) {
                    mp.cleanupWorkDir(workdir);
                    ex3.printStackTrace();
                }
            } else if (ex2 instanceof MapMessage) {
                mp = new MapMessagePersister(lmc);
                mp.setTextBuffer(sbuf);
                try {
                    workdir = ((MapMessagePersister)mp).persistToFile();
                    file_target_string = this.thisproperty.getReal_file_directory() + QBrowserUtil.eliminateDameMoji(lmc.getVmsgid()) + "_MapMessage.zip";
                    tf = new File(file_target_string);
                    mp.zipUp(workdir, tf);
                    sbuf.append(resources.getString("qkey.msg.msg253"));
                    sbuf.append("\n\n");
                    cmp.getRootPane().updateUI();
                    lmc.setReal_file_path(file_target_string);
                    return tf;
                }
                catch (Exception ex4) {
                    mp.cleanupWorkDir(workdir);
                    ex4.printStackTrace();
                }
            } else if (ex2 instanceof StreamMessage) {
                mp = new StreamMessagePersister(lmc);
                mp.setTextBuffer(sbuf);
                try {
                    workdir = ((StreamMessagePersister)mp).persistToFile();
                    file_target_string = this.thisproperty.getReal_file_directory() + QBrowserUtil.eliminateDameMoji(lmc.getVmsgid()) + "_StreamMessage.zip";
                    tf = new File(file_target_string);
                    mp.zipUp(workdir, tf);
                    sbuf.append(resources.getString("qkey.msg.msg253"));
                    sbuf.append("\n\n");
                    cmp.getRootPane().updateUI();
                    lmc.setReal_file_path(file_target_string);
                    return tf;
                }
                catch (Exception ex5) {
                    mp.cleanupWorkDir(workdir);
                    ex5.printStackTrace();
                }
            } else if (ex2 instanceof ObjectMessage) {
                mp = new ObjectMessagePersister(lmc);
                mp.setTextBuffer(sbuf);
                try {
                    workdir = ((ObjectMessagePersister)mp).persistToFile();
                    file_target_string = this.thisproperty.getReal_file_directory() + QBrowserUtil.eliminateDameMoji(lmc.getVmsgid()) + "_ObjectMessage.zip";
                    tf = new File(file_target_string);
                    mp.zipUp(workdir, tf);
                    sbuf.append(resources.getString("qkey.msg.msg253"));
                    sbuf.append("\n\n");
                    cmp.getRootPane().updateUI();
                    lmc.setReal_file_path(file_target_string);
                    return tf;
                }
                catch (Exception ex6) {
                    mp.cleanupWorkDir(workdir);
                    ex6.printStackTrace();
                }
            } else if (ex2 instanceof Message) {
                mp = new MessagePersister(lmc);
                mp.setTextBuffer(sbuf);
                try {
                    workdir = mp.persistToFile();
                    file_target_string = this.thisproperty.getReal_file_directory() + QBrowserUtil.eliminateDameMoji(lmc.getVmsgid()) + "_Message.zip";
                    tf = new File(file_target_string);
                    mp.zipUp(workdir, tf);
                    sbuf.append(resources.getString("qkey.msg.msg253"));
                    sbuf.append("\n\n");
                    cmp.getRootPane().updateUI();
                    lmc.setReal_file_path(file_target_string);
                    return tf;
                }
                catch (Exception ex7) {
                    mp.cleanupWorkDir(workdir);
                    ex7.printStackTrace();
                }
            }
            return tf;
        }
    }
}

