/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.localstore;

import com.jidesoft.swing.FolderChooser;
import com.qbrowser.QBrowserV2;
import com.qbrowser.icons.QBrowserIconsFactory;
import com.qbrowser.localstore.LocalStoreManager;
import com.qbrowser.localstore.LocalStoreProperty;
import com.qbrowser.util.QBrowserUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class LocalStoreConfigPanel {
    HashMap config_frames = new HashMap();
    static ResourceBundle resources = QBrowserV2.resources;
    static FolderChooser _folderChooser;
    static File _currentFolder;
    static List<String> _recentList;
    static HashMap parameters;
    QBrowserV2 vqb2;

    public final void showCreateLSConfigPanel(QBrowserV2 qb2, LocalStoreManager lsm) {
        this.vqb2 = qb2;
        JFrame configFrame = new JFrame();
        Dimension d = new Dimension();
        configFrame.setPreferredSize(d);
        configFrame.setIconImage(QBrowserIconsFactory.getImageIcon("icons/flag6.png").getImage());
        configFrame.setTitle(resources.getString("qkey.msg.msg297"));
        configFrame.setBackground(Color.white);
        configFrame.getContentPane().setLayout(new BorderLayout());
        JLabel expl = new JLabel(resources.getString("qkey.msg.msg298"));
        if (_folderChooser == null) {
            _folderChooser = new FolderChooser();
            _folderChooser.setAvailableButtons(_folderChooser.getAvailableButtons() & 0xFFFFFFFE);
            _folderChooser.setNavigationFieldVisible(true);
        }
        JPanel con_panel = new JPanel();
        GridBagLayout gbag = new GridBagLayout();
        con_panel.setLayout(gbag);
        GridBagConstraints vcs = new GridBagConstraints();
        JTextField local_store_name = new JTextField(20);
        JTextField local_store_dir_path = new JTextField(30);
        d.setSize(600, 200);
        JCheckBox local_store_valid = new JCheckBox();
        local_store_valid.setSelected(true);
        HashMap<String, JComponent> ps = new HashMap<String, JComponent>();
        ps.put("local_store_name", local_store_name);
        ps.put("local_store_dir_path", local_store_dir_path);
        ps.put("local_store_valid", local_store_valid);
        String panelid = String.valueOf(System.nanoTime());
        parameters.put(panelid, ps);
        QBrowserUtil.addLabelAndValueComponent(vcs, con_panel, gbag, resources.getString("qkey.msg.msg287") + "  ", local_store_name, 0);
        QBrowserUtil.addLabelAndValueComponent(vcs, con_panel, gbag, resources.getString("qkey.msg.msg288") + "  ", local_store_dir_path, 1);
        JButton folderc = (JButton)this.createFolderChooseButton(local_store_dir_path);
        vcs.gridx = 2;
        vcs.gridy = 1;
        vcs.weightx = 1.0;
        vcs.weighty = 1.0;
        vcs.anchor = 17;
        gbag.setConstraints(folderc, vcs);
        con_panel.add(folderc);
        QBrowserUtil.addLabelAndValueComponent(vcs, con_panel, gbag, resources.getString("qkey.msg.msg289") + "  ", local_store_valid, 2);
        configFrame.getContentPane().add("North", expl);
        configFrame.getContentPane().add("Center", con_panel);
        JButton okbutton1 = new JButton("          OK          ");
        okbutton1.addActionListener(new CreateOKListener(this, panelid, lsm));
        JButton cancelbutton = new JButton("             " + resources.getString("qkey.msg.msg035") + "          ");
        cancelbutton.addActionListener(new ConfigCancelListener(this, panelid));
        JPanel pbuttonpanel = new JPanel();
        pbuttonpanel.setLayout(new BorderLayout());
        pbuttonpanel.add("West", okbutton1);
        pbuttonpanel.add("Center", cancelbutton);
        JPanel temppanel = new JPanel();
        temppanel.setLayout(new BorderLayout());
        temppanel.add("South", pbuttonpanel);
        configFrame.getContentPane().add("South", temppanel);
        configFrame.pack();
        this.config_frames.put(panelid, configFrame);
        configFrame.setLocationRelativeTo(qb2);
        configFrame.setVisible(true);
    }

    public final void showConfigPanel(LocalStoreProperty lsp, LocalStoreManager lsm, QBrowserV2 qb2) {
        this.vqb2 = qb2;
        if (lsp == null) {
            return;
        }
        String destname = lsp.getDestName();
        if (this.config_frames.containsKey(destname)) {
            JFrame configFrame = (JFrame)this.config_frames.get(destname);
            configFrame.setLocationRelativeTo(qb2);
            configFrame.setVisible(true);
            return;
        }
        JFrame configFrame = new JFrame();
        Dimension d = new Dimension();
        configFrame.setPreferredSize(d);
        configFrame.setIconImage(QBrowserIconsFactory.getImageIcon("icons/flag6.png").getImage());
        configFrame.setTitle(resources.getString("qkey.msg.msg286") + " " + destname);
        configFrame.setBackground(Color.white);
        configFrame.getContentPane().setLayout(new BorderLayout());
        JLabel expl = new JLabel(resources.getString("qkey.msg.msg290"));
        if (_folderChooser == null) {
            _folderChooser = new FolderChooser();
            _folderChooser.setAvailableButtons(_folderChooser.getAvailableButtons() & 0xFFFFFFFE);
            _folderChooser.setNavigationFieldVisible(true);
        }
        JPanel con_panel = new JPanel();
        GridBagLayout gbag = new GridBagLayout();
        con_panel.setLayout(gbag);
        GridBagConstraints vcs = new GridBagConstraints();
        JTextField local_store_name = new JTextField(20);
        local_store_name.setText(destname);
        int prefl = lsp.getReal_file_directory().length();
        if (prefl > 50) {
            prefl = 50;
        }
        if (prefl < 20) {
            prefl = 20;
        }
        JTextField local_store_dir_path = new JTextField(prefl);
        d.setSize(300 + prefl * 10, 200);
        local_store_dir_path.setText(lsp.getReal_file_directory());
        JCheckBox local_store_valid = new JCheckBox();
        if (lsp.isValid()) {
            local_store_valid.setSelected(true);
        }
        JCheckBox auto_migration = new JCheckBox();
        auto_migration.setSelected(true);
        HashMap<String, JComponent> ps = new HashMap<String, JComponent>();
        ps.put("local_store_name", local_store_name);
        ps.put("local_store_dir_path", local_store_dir_path);
        ps.put("local_store_valid", local_store_valid);
        ps.put("auto_migration", auto_migration);
        parameters.put(destname, ps);
        QBrowserUtil.addLabelAndValueComponent(vcs, con_panel, gbag, resources.getString("qkey.msg.msg287") + "  ", local_store_name, 0);
        QBrowserUtil.addLabelAndValueComponent(vcs, con_panel, gbag, resources.getString("qkey.msg.msg288") + "  ", local_store_dir_path, 1);
        JButton folderc = (JButton)this.createFolderChooseButton(local_store_dir_path);
        vcs.gridx = 2;
        vcs.gridy = 1;
        vcs.weightx = 1.0;
        vcs.weighty = 1.0;
        vcs.anchor = 17;
        gbag.setConstraints(folderc, vcs);
        con_panel.add(folderc);
        QBrowserUtil.addLabelAndValueComponent(vcs, con_panel, gbag, resources.getString("qkey.msg.msg289") + "  ", local_store_valid, 2);
        QBrowserUtil.addLabelAndValueComponent(vcs, con_panel, gbag, resources.getString("qkey.msg.msg296") + "  ", auto_migration, 3);
        configFrame.getContentPane().add("North", expl);
        configFrame.getContentPane().add("Center", con_panel);
        JButton okbutton1 = new JButton("          " + resources.getString("qkey.msg.msg306") + "          ");
        okbutton1.addActionListener(new ConfigOKListener(this, destname, lsm));
        JButton cancelbutton = new JButton("         " + resources.getString("qkey.msg.msg035") + "             ");
        cancelbutton.addActionListener(new ConfigCancelListener(this, destname));
        JPanel pbuttonpanel = new JPanel();
        pbuttonpanel.setLayout(new BorderLayout());
        pbuttonpanel.add("West", okbutton1);
        pbuttonpanel.add("Center", cancelbutton);
        JPanel temppanel = new JPanel();
        temppanel.setLayout(new BorderLayout());
        temppanel.add("South", pbuttonpanel);
        configFrame.getContentPane().add("South", temppanel);
        configFrame.pack();
        this.config_frames.put(destname, configFrame);
        configFrame.setLocationRelativeTo(qb2);
        configFrame.setVisible(true);
    }

    private AbstractButton createFolderChooseButton(JTextField dirpath) {
        JButton button = new JButton("...");
        button.setMnemonic('B');
        button.addActionListener(new AbstractAction(this, dirpath, button){
            private /* synthetic */ JTextField val$dirpath;
            private /* synthetic */ JButton val$button;
            {
                this.val$dirpath = jTextField;
                this.val$button = jButton;
            }

            public final void actionPerformed(ActionEvent e) {
                if (this.val$dirpath.getText().length() > 0) {
                    _currentFolder = _folderChooser.getFileSystemView().createFileObject(this.val$dirpath.getText());
                }
                _folderChooser.setCurrentDirectory(_currentFolder);
                _folderChooser.setRecentList(_recentList);
                _folderChooser.setFileHidingEnabled(true);
                int result = _folderChooser.showOpenDialog((Component)this.val$button.getTopLevelAncestor());
                if (result == 0) {
                    _currentFolder = _folderChooser.getSelectedFile();
                    if (_recentList.contains(_currentFolder.toString())) {
                        _recentList.remove(_currentFolder.toString());
                    }
                    _recentList.add(0, _currentFolder.toString());
                    File selectedFile = _folderChooser.getSelectedFile();
                    if (selectedFile != null) {
                        this.val$dirpath.setText(selectedFile.toString());
                        return;
                    }
                    this.val$dirpath.setText("");
                }
            }
        });
        button.setRequestFocusEnabled(false);
        button.setFocusable(false);
        return button;
    }

    static {
        _currentFolder = null;
        _recentList = new ArrayList<String>();
        parameters = new HashMap();
    }

    final class CreateOKListener
    implements ActionListener {
        private String panelid;
        private LocalStoreManager lsm;
        private /* synthetic */ LocalStoreConfigPanel this$0;

        public CreateOKListener(LocalStoreConfigPanel localStoreConfigPanel, String panelidv, LocalStoreManager vlsm) {
            this.this$0 = localStoreConfigPanel;
            this.panelid = panelidv;
            this.lsm = vlsm;
        }

        public final void actionPerformed(ActionEvent e) {
            Exception createdir_ex;
            JFrame frame = (JFrame)this.this$0.config_frames.get(this.panelid);
            HashMap ps = (HashMap)parameters.get(this.panelid);
            frame.setVisible(false);
            JTextField local_store_name = (JTextField)ps.get("local_store_name");
            if (local_store_name.getText().length() == 0) {
                QBrowserUtil.popupErrorMessageDialog(new Exception(resources.getString("qkey.msg.msg295")), frame.getRootPane());
                return;
            }
            JTextField local_store_dir_path = (JTextField)ps.get("local_store_dir_path");
            File ifile = new File(local_store_dir_path.getText());
            if (!ifile.exists()) {
                try {
                    ifile.mkdirs();
                }
                catch (Exception exception) {
                    createdir_ex = exception;
                    exception.printStackTrace();
                    QBrowserUtil.popupErrorMessageDialog(new Exception(resources.getString("qkey.msg.msg403")), frame.getRootPane());
                    return;
                }
            } else if (!ifile.isDirectory()) {
                QBrowserUtil.popupErrorMessageDialog(new Exception(resources.getString("qkey.msg.msg294")), frame.getRootPane());
                return;
            }
            JCheckBox local_store_valid = (JCheckBox)((HashMap)((Object)createdir_ex)).get("local_store_valid");
            LocalStoreProperty lsp = new LocalStoreProperty();
            lsp.setDestName(local_store_name.getText());
            lsp.setReal_file_directory(ifile.getAbsolutePath());
            if (local_store_valid.getSelectedObjects() != null) {
                lsp.setValid(true);
            } else {
                lsp.setValid(false);
            }
            try {
                this.lsm.addNewLocalStoreProperty(lsp);
            }
            catch (Exception exception) {
                Exception lspe = exception;
                QBrowserUtil.popupErrorMessageDialog(exception, frame.getRootPane());
                return;
            }
            try {
                if (lsp.isValid()) {
                    QBrowserV2.destinationNamesForDisplayQueue = new ArrayList();
                    QBrowserV2.destinationNamesForDisplayTopic = new ArrayList();
                    this.this$0.vqb2.collectDestination();
                }
                this.this$0.vqb2.setMainDestComboBox(lsp.getDestNameWithSuffix());
                this.this$0.vqb2.initLocalStoreManager();
                this.this$0.vqb2.initTreePane();
                return;
            }
            catch (Exception exception) {
                Exception colex = exception;
                exception.printStackTrace();
                return;
            }
        }
    }

    final class ConfigCancelListener
    implements ActionListener {
        private String local_dest_name;
        private /* synthetic */ LocalStoreConfigPanel this$0;

        public ConfigCancelListener(LocalStoreConfigPanel localStoreConfigPanel, String dest_name) {
            this.this$0 = localStoreConfigPanel;
            this.local_dest_name = dest_name;
        }

        public final void actionPerformed(ActionEvent e) {
            JFrame frame = (JFrame)this.this$0.config_frames.get(this.local_dest_name);
            frame.setVisible(false);
        }
    }

    final class ConfigOKListener
    implements ActionListener {
        private String local_dest_name;
        private LocalStoreManager lsm;
        private /* synthetic */ LocalStoreConfigPanel this$0;

        public ConfigOKListener(LocalStoreConfigPanel localStoreConfigPanel, String dest_name, LocalStoreManager vlsm) {
            this.this$0 = localStoreConfigPanel;
            this.local_dest_name = dest_name;
            this.lsm = vlsm;
        }

        public final void actionPerformed(ActionEvent e) {
            JFrame frame = (JFrame)this.this$0.config_frames.get(this.local_dest_name);
            HashMap ps = (HashMap)parameters.get(this.local_dest_name);
            JTextField local_store_name = (JTextField)ps.get("local_store_name");
            if (local_store_name.getText().length() == 0) {
                QBrowserUtil.popupErrorMessageDialog(new Exception(resources.getString("qkey.msg.msg295")), frame.getRootPane());
                return;
            }
            JTextField local_store_dir_path = (JTextField)ps.get("local_store_dir_path");
            File ifile = new File(local_store_dir_path.getText());
            if (!ifile.exists() || !ifile.isDirectory()) {
                QBrowserUtil.popupErrorMessageDialog(new Exception(resources.getString("qkey.msg.msg294")), frame.getRootPane());
                return;
            }
            JCheckBox local_store_valid = (JCheckBox)ps.get("local_store_valid");
            JCheckBox auto_migration = (JCheckBox)ps.get("auto_migration");
            LocalStoreProperty lsp = this.lsm.getLocalStoreProperty(this.local_dest_name);
            File from = new File(lsp.getReal_file_directory());
            if (!ifile.getAbsolutePath().equals(from.getAbsolutePath()) && auto_migration.getSelectedObjects() != null) {
                File[] fromfiles = from.listFiles();
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < fromfiles.length; ++i) {
                    if (!fromfiles[i].isFile() || !fromfiles[i].getName().endsWith("Message.zip")) continue;
                    try {
                        QBrowserUtil.copy(fromfiles[i], new File(ifile.getAbsolutePath() + File.separator + fromfiles[i].getName()));
                        continue;
                    }
                    catch (Throwable thex) {
                        sb.append(thex.getMessage()).append("\n");
                    }
                }
                if (sb.length() != 0) {
                    QBrowserUtil.popupErrorMessageDialog(new Exception(sb.toString()), frame.getRootPane());
                }
            }
            if (!lsp.getDestName().equals(local_store_name.getText())) {
                this.this$0.vqb2.removeNamedTabbedPane(lsp.getDestNameWithSuffix());
                this.lsm.removeLocalStoreProperty(lsp);
            }
            lsp.setDestName(local_store_name.getText());
            lsp.setReal_file_directory(ifile.getAbsolutePath());
            if (local_store_valid.getSelectedObjects() != null) {
                lsp.setValid(true);
            } else {
                lsp.setValid(false);
            }
            try {
                this.lsm.updateAndSaveLocalStoreProperty(lsp);
            }
            catch (Exception exception) {
                Exception lspe = exception;
                QBrowserUtil.popupErrorMessageDialog(exception, frame.getRootPane());
            }
            frame.setVisible(false);
            if (lsp.isValid()) {
                try {
                    this.this$0.vqb2.collectDestination();
                }
                catch (Exception exception) {
                    Exception iie = exception;
                    exception.printStackTrace();
                }
            }
            this.this$0.vqb2.setMainDestComboBox(lsp.getDestNameWithSuffix());
            this.this$0.vqb2.initLocalStoreManager();
            this.this$0.vqb2.refreshLocalStoreMsgTableWithFileReloading(lsp.getDestNameWithSuffix());
            this.this$0.vqb2.initTreePane();
        }
    }
}

