/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.consumer.table;

import com.qbrowser.QBrowserV2;
import com.qbrowser.consumer.table.MessageRecordProperty;
import java.util.LinkedList;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.table.DefaultTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MessageRecordTable
extends DefaultTableModel {
    private static ResourceBundle resources = QBrowserV2.resources;
    private String[] columnNames = new String[]{resources.getString("qkey.recordtable.header.dest_name"), resources.getString("qkey.recordtable.header.status"), resources.getString("qkey.recordtable.header.count"), resources.getString("qkey.recordtable.header.button")};
    private LinkedList list = null;

    public MessageRecordTable() {
        MessageRecordTable messageRecordTable = this;
        this.list = new LinkedList();
    }

    @Override
    public final int getRowCount() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    @Override
    public final int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public final String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public final Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: {
                return Object.class;
            }
        }
        return Object.class;
    }

    @Override
    public final boolean isCellEditable(int row, int column) {
        Object robj = this.getValueAt(row, column);
        return robj instanceof JButton;
    }

    @Override
    public final void setValueAt(Object value, int row, int column) {
        if (this.list == null) {
            return;
        }
        if (this.list.size() <= row) {
            return;
        }
        MessageRecordProperty p = (MessageRecordProperty)this.list.get(row);
        if (p == null) {
            return;
        }
        try {
            switch (column) {
                case 0: {
                    if (value instanceof String) {
                        p.setDestName((String)value);
                    }
                    return;
                }
                case 1: {
                    if (value instanceof String) {
                        p.setConsumerThreadStatus((String)value);
                    }
                    return;
                }
                case 2: {
                    if (value instanceof Integer) {
                        p.setCount((Integer)value);
                    }
                }
                case 3: {
                    if (value instanceof JButton) {
                        p.setButton((JButton)value);
                    }
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return;
        }
    }

    @Override
    public final Object getValueAt(int row, int column) {
        if (this.list == null) {
            return null;
        }
        MessageRecordProperty p = (MessageRecordProperty)this.list.get(row);
        if (p == null) {
            return "";
        }
        try {
            switch (column) {
                case 0: {
                    return p.getDestName();
                }
                case 1: {
                    return p.getConsumerThreadStatus();
                }
                case 2: {
                    return p.getCount();
                }
                case 3: {
                    JButton no4 = p.getButton();
                    if (no4 != null) {
                        if (no4 instanceof JButton) {
                            return no4;
                        }
                        return "";
                    }
                    return "";
                }
            }
        }
        catch (Exception e) {
            return "Error: " + e;
        }
        return "Bad column value: " + column;
    }

    public final void add_one_row(MessageRecordProperty value) {
        this.list.add(value);
        this.fireTableDataChanged();
    }

    public final void deletePropertyAtRow(int row) {
        if (this.list == null) {
            return;
        }
        this.list.remove(row);
        this.fireTableDataChanged();
    }

    public final MessageRecordProperty getPropertyAtRow(int row) {
        if (this.list == null) {
            return null;
        }
        return (MessageRecordProperty)this.list.get(row);
    }
}

