/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Searchable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeSearchable
extends Searchable
implements PropertyChangeListener,
TreeModelListener {
    private boolean _recursive = false;
    private transient List<TreePath> _treePathes;

    public TreeSearchable(JTree jTree) {
        super(jTree);
        if (jTree.getModel() != null) {
            jTree.getModel().addTreeModelListener(this);
        }
        jTree.addPropertyChangeListener("model", this);
    }

    public final void uninstallListeners() {
        super.uninstallListeners();
        if (this._component instanceof JTree && ((JTree)this._component).getModel() != null) {
            ((JTree)this._component).getModel().removeTreeModelListener(this);
        }
        this._component.removePropertyChangeListener("model", this);
    }

    protected final void setSelectedIndex(int n, boolean bl) {
        TreeSearchable treeSearchable = this;
        if (bl) {
            ((JTree)this._component).addSelectionInterval(n, n);
        } else {
            ((JTree)this._component).setSelectionRow(n);
        }
        ((JTree)this._component).scrollRowToVisible(n);
    }

    protected final int getSelectedIndex() {
        Object object = this;
        int[] nArray = ((JTree)this._component).getSelectionRows();
        object = nArray;
        if (nArray != null && ((Object)object).length != 0) {
            return (int)object[0];
        }
        return -1;
    }

    protected final Object getElementAt(int n) {
        if (n == -1) {
            return null;
        }
        TreeSearchable treeSearchable = this;
        return ((JTree)this._component).getPathForRow(n);
    }

    protected final int getElementCount() {
        TreeSearchable treeSearchable = this;
        return ((JTree)this._component).getRowCount();
    }

    protected String convertElementToString(Object object) {
        if (object instanceof TreePath) {
            object = ((TreePath)object).getLastPathComponent();
            return object.toString();
        }
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public void treeNodesChanged(TreeModelEvent object) {
        this.hidePopup();
        object = this;
        this._treePathes = null;
    }

    public void treeNodesInserted(TreeModelEvent object) {
        this.hidePopup();
        object = this;
        this._treePathes = null;
    }

    public void treeNodesRemoved(TreeModelEvent object) {
        this.hidePopup();
        object = this;
        this._treePathes = null;
    }

    public void treeStructureChanged(TreeModelEvent object) {
        this.hidePopup();
        object = this;
        this._treePathes = null;
    }

    public void propertyChange(PropertyChangeEvent object) {
        if ("model".equals(((PropertyChangeEvent)object).getPropertyName())) {
            this.hidePopup();
            if (((PropertyChangeEvent)object).getOldValue() instanceof TreeModel) {
                ((TreeModel)((PropertyChangeEvent)object).getOldValue()).removeTreeModelListener(this);
            }
            if (((PropertyChangeEvent)object).getNewValue() instanceof TreeModel) {
                ((TreeModel)((PropertyChangeEvent)object).getNewValue()).addTreeModelListener(this);
            }
            object = this;
            this._treePathes = null;
        }
    }
}

