/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.Contour;
import com.jidesoft.swing.HeavyweightWrapper;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideSplitPaneDivider;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Arrays;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public final class JideSplitPane
extends JPanel
implements ComponentListener,
ContainerListener,
Accessible {
    private int _orientation = 1;
    private int _dividerSize = UIDefaultsLookup.getInt("JideSplitPane.dividerSize");
    private HeavyweightWrapper _nonContinuousLayoutDividerWrapper;
    private boolean _continuousLayout = false;
    private Container _layeredPane;
    private boolean _showGripper = false;
    private boolean _proportionalLayout = false;
    private double[] _proportions;
    private boolean _initiallyEven = true;
    private boolean _heavyweightComponentEnabled = false;
    public WindowAdapter _windowDeactivatedListener;
    private boolean _oneTouchExpandable = false;
    private ImageIcon _leftOneTouchButtonImageIcon = null;
    private ImageIcon _rightOneTouchButtonImageIcon = null;

    public JideSplitPane() {
        this(1);
    }

    private JideSplitPane(int n) {
        if (this._orientation != 1 && this._orientation != 0) {
            throw new IllegalArgumentException("cannot create JideSplitPane, orientation must be one of JideSplitPane.HORIZONTAL_SPLIT or JideSplitPane.VERTICAL_SPLIT");
        }
        Serializable serializable = this._orientation == 1 ? new JideSplitPaneLayout(this, this, 0) : new JideSplitPaneLayout(this, this, 1);
        super.setLayout((LayoutManager)((Object)serializable));
        this.setOpaque(false);
        serializable = this;
        ((Container)serializable).addContainerListener((ContainerListener)((Object)serializable));
    }

    public final void updateUI() {
        if (UIDefaultsLookup.get("JideSplitPane.dividerSize") == null) {
            LookAndFeelFactory.installJideExtension();
        }
        super.updateUI();
    }

    public final int getDividerSize() {
        return this._dividerSize;
    }

    public final int getOrientation() {
        return this._orientation;
    }

    public final void setProportions(double[] dArray) {
        int n;
        if (dArray != null) {
            throw new IllegalStateException("Can't set proportions on a non-proportional split pane");
        }
        if (Arrays.equals(dArray, this._proportions)) {
            return;
        }
        if (dArray != null && dArray.length != this.getPaneCount() - 1) {
            throw new IllegalArgumentException("Must provide one fewer proportions than there are panes: got " + dArray.length + ", expected " + (this.getPaneCount() - 1));
        }
        if (dArray != null) {
            double d = 0.0;
            for (n = 0; n < dArray.length; ++n) {
                if (dArray[n] < 0.0) {
                    dArray[n] = 0.0;
                }
                if (dArray[n] > 1.0) {
                    dArray[n] = 1.0;
                }
                d += dArray[n];
            }
            if (d > 1.0) {
                throw new IllegalArgumentException("Sum of proportions must be no more than 1, got " + d);
            }
        }
        double[] dArray2 = this._proportions;
        this._proportions = dArray == null ? null : (double[])dArray.clone();
        LayoutManager layoutManager = this.getLayout();
        n = 0;
        if (layoutManager instanceof JideBoxLayout) {
            n = ((JideBoxLayout)layoutManager).isResetWhenInvalidate() ? 1 : 0;
            ((JideBoxLayout)layoutManager).setResetWhenInvalidate(true);
        }
        this.revalidate();
        if (n != 0) {
            ((JideBoxLayout)layoutManager).setResetWhenInvalidate(n != 0);
        }
        this.firePropertyChange("proportions", dArray2, dArray);
    }

    public final boolean isValidateRoot() {
        return true;
    }

    protected final void startDragging$51c316b3() {
        JideSplitPane jideSplitPane = this;
        Serializable serializable = this.getTopLevelAncestor();
        if (this._windowDeactivatedListener == null) {
            this._windowDeactivatedListener = new WindowAdapter(this){
                private /* synthetic */ JideSplitPane this$0;
                {
                    this.this$0 = jideSplitPane;
                }

                public final void windowDeactivated(WindowEvent windowEvent) {
                    this.this$0.stopDragging();
                    if (windowEvent.getWindow() != null) {
                        windowEvent.getWindow().removeWindowListener(this.this$0._windowDeactivatedListener);
                    }
                }
            };
        }
        if (serializable instanceof Window) {
            ((Window)serializable).addWindowListener(this._windowDeactivatedListener);
        }
        if (serializable instanceof RootPaneContainer) {
            this._layeredPane = ((RootPaneContainer)((Object)serializable)).getLayeredPane();
            if (this._nonContinuousLayoutDividerWrapper == null) {
                serializable = new Contour();
                this._nonContinuousLayoutDividerWrapper = new HeavyweightWrapper((Component)serializable);
                serializable = this;
                this._nonContinuousLayoutDividerWrapper.setHeavyweight(false);
            }
            this._nonContinuousLayoutDividerWrapper.delegateSetCursor(this._orientation == 1 ? JideSplitPaneDivider.HORIZONTAL_CURSOR : JideSplitPaneDivider.VERTICAL_CURSOR);
            this._nonContinuousLayoutDividerWrapper.delegateSetVisible(false);
            this._nonContinuousLayoutDividerWrapper.delegateAdd(this._layeredPane, JLayeredPane.DRAG_LAYER);
            serializable = this.getVisibleRect();
            serializable = SwingUtilities.convertRectangle(this, (Rectangle)serializable, this._layeredPane);
            jideSplitPane = this;
            int n = Math.min(4, jideSplitPane._dividerSize);
            jideSplitPane = this;
            if (jideSplitPane._orientation == 1) {
                this._nonContinuousLayoutDividerWrapper.delegateSetBounds(((Rectangle)serializable).x, ((Rectangle)serializable).y, n, ((Rectangle)serializable).height);
                return;
            }
            this._nonContinuousLayoutDividerWrapper.delegateSetBounds(((Rectangle)serializable).x, ((Rectangle)serializable).y, ((Rectangle)serializable).width, n);
        }
    }

    private void stopDragging() {
        JideSplitPane jideSplitPane = this;
        if (this._layeredPane != null && this._nonContinuousLayoutDividerWrapper != null) {
            this._nonContinuousLayoutDividerWrapper.delegateSetVisible(false);
            this._nonContinuousLayoutDividerWrapper.delegateRemove(this._layeredPane);
            this._nonContinuousLayoutDividerWrapper.delegateSetNull();
            this._nonContinuousLayoutDividerWrapper = null;
        }
    }

    protected final void dragDividerTo(JideSplitPaneDivider serializable, int n) {
        if (this._layeredPane == null) {
            this.setDividerLocation((JideSplitPaneDivider)serializable, n);
            return;
        }
        JideSplitPane jideSplitPane = this;
        if (this._nonContinuousLayoutDividerWrapper != null) {
            jideSplitPane = this;
            serializable = jideSplitPane._orientation == 1 ? SwingUtilities.convertPoint(this, n, 0, this._layeredPane) : SwingUtilities.convertPoint(this, 0, n, this._layeredPane);
            jideSplitPane = this;
            n = Math.min(4, jideSplitPane._dividerSize);
            jideSplitPane = this;
            if (jideSplitPane._orientation == 1) {
                jideSplitPane = this;
                ((Point)serializable).x += jideSplitPane._dividerSize - n >> 1;
            } else {
                jideSplitPane = this;
                ((Point)serializable).y += jideSplitPane._dividerSize - n >> 1;
            }
            this._nonContinuousLayoutDividerWrapper.delegateSetLocation((Point)serializable);
            this._nonContinuousLayoutDividerWrapper.delegateSetVisible(true);
        }
    }

    protected final void finishDraggingTo(JideSplitPaneDivider jideSplitPaneDivider, int n) {
        JideSplitPane jideSplitPane = this;
        if (this._nonContinuousLayoutDividerWrapper != null) {
            this.stopDragging();
            this.setDividerLocation(jideSplitPaneDivider, n);
        }
    }

    public final int indexOfDivider(JideSplitPaneDivider jideSplitPaneDivider) {
        int n = this.indexOf(jideSplitPaneDivider);
        if (n == -1) {
            return n;
        }
        if (n % 2 == 0) {
            System.err.println("Warning: divider's index is even. (index = " + n + ")");
        }
        return (n - 1) / 2;
    }

    public final int indexOf(Component component) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!this.getComponent(i).equals(component)) continue;
            return i;
        }
        return -1;
    }

    private JideSplitPaneDivider getDividerAt(int n) {
        if (n < 0 || (n << 1) + 1 >= this.getComponentCount()) {
            return null;
        }
        return (JideSplitPaneDivider)this.getComponent((n << 1) + 1);
    }

    public final Component getPaneAt(int n) {
        if (n < 0 || n << 1 >= this.getComponentCount()) {
            return null;
        }
        return this.getComponent(n << 1);
    }

    public final int getPaneCount() {
        return this.getComponentCount() + 1 >> 1;
    }

    public final void setDividerLocation(JideSplitPaneDivider jPanel, int n) {
        int n2 = n;
        n = this.indexOfDivider((JideSplitPaneDivider)jPanel);
        jPanel = this;
        int n3 = ((JideSplitPaneLayout)jPanel.getLayout()).getDividerLocation(n);
        ((JideSplitPaneLayout)jPanel.getLayout()).setDividerLocation(n, n2);
        jPanel.firePropertyChange("dividerLocation", n3, n2);
        jPanel.revalidate();
    }

    public final int getDividerLocation(int n) {
        return ((JideSplitPaneLayout)this.getLayout()).getDividerLocation(n);
    }

    public final void componentAdded(ContainerEvent serializable) {
        ((ContainerEvent)serializable).getChild().addComponentListener(this);
        if (!(((ContainerEvent)serializable).getChild() instanceof JideSplitPaneDivider)) {
            serializable = this;
            int n = 0;
            for (int i = 0; i < ((Container)serializable).getComponentCount(); ++i) {
                Component component = ((Container)serializable).getComponent(i);
                if (!(component instanceof JideSplitPaneDivider)) {
                    if (++n != 2) continue;
                    Serializable serializable2 = serializable;
                    ((Container)serializable).add(new JideSplitPaneDivider((JideSplitPane)serializable2), "fix", i);
                    if (((JideSplitPane)serializable)._proportions != null && ((JideSplitPane)serializable).getPaneCount() == ((JideSplitPane)serializable)._proportions.length + 2) {
                        int n2 = (i + 1) / 2;
                        serializable2 = serializable;
                        double[] dArray = ((JideSplitPane)serializable2)._proportions;
                        if (((JideSplitPane)serializable2)._proportions != null) {
                            double[] dArray2 = new double[dArray.length + 1];
                            double d = 1.0 / (double)(dArray2.length + 1);
                            double d2 = 1.0 - d;
                            for (int j = 0; j < dArray2.length; ++j) {
                                int n3;
                                dArray2[j] = j != n2 && (n3 = j < n2 ? j : j - 1) < dArray.length ? dArray[n3] * d2 : d;
                            }
                            ((JideSplitPane)serializable2).setProportions(dArray2);
                        }
                    }
                    n = 0;
                    continue;
                }
                n = 0;
            }
        }
        this.setDividersVisible();
        serializable = this;
        ((JideSplitPane)serializable).doLayout();
    }

    public final void componentRemoved(ContainerEvent serializable) {
        serializable.getChild().removeComponentListener(this);
        if (!(serializable.getChild() instanceof JideSplitPaneDivider)) {
            this.removeExtraDividers();
        }
        this.setDividersVisible();
        serializable = this;
        ((JideSplitPane)serializable).doLayout();
    }

    public final void componentResized(ComponentEvent componentEvent) {
    }

    public final void componentMoved(ComponentEvent componentEvent) {
    }

    public final void componentShown(ComponentEvent serializable) {
        if (serializable.getComponent() instanceof JideSplitPaneDivider) {
            return;
        }
        this.setDividersVisible();
        serializable = this;
        ((JideSplitPane)serializable).doLayout();
    }

    public final void componentHidden(ComponentEvent serializable) {
        if (serializable.getComponent() instanceof JideSplitPaneDivider) {
            return;
        }
        this.setDividersVisible();
        serializable = this;
        ((JideSplitPane)serializable).doLayout();
    }

    private boolean removeExtraDividers() {
        int n = 0;
        if (this.getComponentCount() == 0) {
            if (this._proportions != null) {
                this.setProportions(null);
            }
            return false;
        }
        boolean bl = false;
        if (this.getComponent(0) instanceof JideSplitPaneDivider) {
            this.remove(0);
            this.removeProportion(0);
            bl = true;
        }
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (component instanceof JideSplitPaneDivider) {
                if (++n != 2) continue;
                this.remove(component);
                if (this._proportions != null && this.getPaneCount() == this._proportions.length) {
                    this.removeProportion(i / 2);
                }
                bl = true;
                --n;
                --i;
                continue;
            }
            n = 0;
        }
        if (n == 1) {
            this.remove(this.getComponentCount() - 1);
            this.removeProportion((this.getComponentCount() + 1) / 2);
            bl = true;
        }
        return bl;
    }

    private void removeProportion(int n) {
        int n2;
        double d;
        double[] dArray = this._proportions;
        if (this._proportions == null) {
            return;
        }
        if (dArray.length <= 1) {
            this.setProportions(null);
            return;
        }
        double[] dArray2 = new double[dArray.length - 1];
        if (n < dArray.length) {
            d = dArray[n];
        } else {
            d = 1.0;
            double[] dArray3 = dArray;
            int n3 = dArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                double d2 = dArray3[n2];
                d -= d2;
            }
        }
        double d3 = 1.0 - d;
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            int n4 = n2 < n ? n2 : n2 + 1;
            dArray2[n2] = dArray[n4] / d3;
        }
        this.setProportions(dArray2);
    }

    private void setDividersVisible() {
        if (this.getComponentCount() == 1) {
            this.setVisible(this.getComponent(0).isVisible());
            return;
        }
        if (this.getComponentCount() > 1) {
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                if (!(component instanceof JideSplitPaneDivider)) {
                    if (!component.isVisible() || bl) continue;
                    bl = true;
                    continue;
                }
                boolean bl3 = this.getComponent(i - 1).isVisible();
                boolean bl4 = this.getComponent(i + 1).isVisible();
                if (bl3 && bl4) {
                    component.setVisible(true);
                    continue;
                }
                if (bl3 || bl4) {
                    if (bl3 && !bl4) {
                        component.setVisible(false);
                        bl2 = true;
                        continue;
                    }
                    if (bl2) {
                        component.setVisible(true);
                        bl2 = false;
                        continue;
                    }
                }
                component.setVisible(false);
            }
            this.setVisible(bl);
        }
    }

    protected final int getPreviousDividerLocation(JideSplitPaneDivider jideSplitPaneDivider, boolean bl, boolean bl2) {
        int n = this.indexOfDivider(jideSplitPaneDivider);
        int n2 = -1;
        if (bl2) {
            if ((n + 1 << 1) + 1 <= this.getComponentCount()) {
                ++n;
                while ((n << 1) + 1 < this.getComponentCount()) {
                    if (bl || this.getDividerAt(n).isVisible()) {
                        n2 = this._orientation == 1 ? this.getDividerAt((int)n).getBounds().x : this.getDividerAt((int)n).getBounds().y;
                        break;
                    }
                    ++n;
                }
            }
        } else if (n > 0) {
            --n;
            while (n >= 0) {
                if (bl || this.getDividerAt(n).isVisible()) {
                    n2 = this._orientation == 1 ? this.getDividerAt((int)n).getBounds().x : this.getDividerAt((int)n).getBounds().y;
                    break;
                }
                --n;
            }
        }
        if (n2 != -1) {
            JideSplitPane jideSplitPane = this;
            return n2 + jideSplitPane._dividerSize;
        }
        return 0;
    }

    public final int getNextDividerLocation(JideSplitPaneDivider jideSplitPaneDivider, boolean bl, boolean bl2) {
        int n = this.indexOfDivider(jideSplitPaneDivider);
        int n2 = -1;
        if (!bl2) {
            if ((n + 1 << 1) + 1 <= this.getComponentCount()) {
                ++n;
                while ((n << 1) + 1 < this.getComponentCount()) {
                    if (bl || this.getDividerAt(n).isVisible()) {
                        n2 = this._orientation == 1 ? this.getDividerAt((int)n).getBounds().x : this.getDividerAt((int)n).getBounds().y;
                        break;
                    }
                    ++n;
                }
            }
        } else if (n > 0) {
            --n;
            while (n >= 0) {
                if (bl || this.getDividerAt(n).isVisible()) {
                    n2 = this._orientation == 1 ? this.getDividerAt((int)n).getBounds().x : this.getDividerAt((int)n).getBounds().y;
                    break;
                }
                --n;
            }
        }
        if (n2 != -1) {
            JideSplitPane jideSplitPane = this;
            return n2 - jideSplitPane._dividerSize;
        }
        JideSplitPane jideSplitPane = this;
        if (jideSplitPane._orientation == 1) {
            jideSplitPane = this;
            return this.getWidth() - jideSplitPane._dividerSize;
        }
        jideSplitPane = this;
        return this.getHeight() - jideSplitPane._dividerSize;
    }

    public final void doLayout() {
        if (this.removeExtraDividers()) {
            ((JideSplitPaneLayout)this.getLayout()).invalidateLayout(this);
        }
        super.doLayout();
    }

    public final AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJideSplitPane(this);
        }
        return this.accessibleContext;
    }

    public final class AccessibleJideSplitPane
    extends JComponent.AccessibleJComponent {
        private /* synthetic */ JideSplitPane this$0;

        protected AccessibleJideSplitPane(JideSplitPane jideSplitPane) {
            this.this$0 = jideSplitPane;
            super(jideSplitPane);
        }

        public final AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (this.this$0.getOrientation() == 0) {
                accessibleStateSet.add(AccessibleState.VERTICAL);
            } else {
                accessibleStateSet.add(AccessibleState.HORIZONTAL);
            }
            return accessibleStateSet;
        }

        public final AccessibleRole getAccessibleRole() {
            return AccessibleRole.SPLIT_PANE;
        }
    }

    final class JideSplitPaneLayout
    extends JideBoxLayout {
        private /* synthetic */ JideSplitPane this$0;

        public JideSplitPaneLayout(JideSplitPane jideSplitPane, Container container, int n) {
            this.this$0 = jideSplitPane;
            super(container, n);
            this.setResetWhenInvalidate(false);
        }

        final int getDividerLocation(int n) {
            Insets insets;
            int n2;
            if (this._componentSizes == null) {
                return -1;
            }
            if (n < 0 || n + 1 << 1 >= this._componentSizes.length) {
                return -1;
            }
            boolean bl = this.this$0.getComponentOrientation().isLeftToRight();
            bl = !bl && this.this$0.getOrientation() == 1;
            int n3 = 0;
            if (bl) {
                for (n2 = this._componentSizes.length - 1; n2 >= (n << 1) + 1; --n2) {
                    n3 += this._componentSizes[n2];
                }
            } else {
                for (n2 = 0; n2 < (n << 1) + 1; ++n2) {
                    n3 += this._componentSizes[n2];
                }
            }
            if ((insets = this.this$0.getInsets()) != null) {
                n3 = this.this$0.getOrientation() == 1 ? (n3 += bl ? insets.right : insets.left) : (n3 += insets.top);
            }
            return n3;
        }

        final void setDividerLocation(int n, int n2) {
            int n3;
            int n4 = this.getDividerLocation(n);
            if (n4 == -1 || n4 == n2) {
                return;
            }
            int n5 = this.this$0.getComponentOrientation().isLeftToRight();
            n5 = n5 == 0 && this.this$0.getOrientation() == 1 ? 1 : 0;
            if (n5 != 0) {
                n5 = n * 2 + 2;
                for (n3 = n *= 2; !(n3 < 0 || this._target.getComponent(n3).isVisible() && this.getConstraintMap().get(this._target.getComponent(n3)) != "fix"); --n3) {
                    --n;
                }
                for (n3 = n5; !(n3 >= this._target.getComponentCount() || this._target.getComponent(n3).isVisible() && this.getConstraintMap().get(this._target.getComponent(n3)) != "fix"); ++n3) {
                    ++n5;
                }
                if (n < 0 || n5 >= this._componentSizes.length) {
                    return;
                }
            } else {
                n5 = n * 2;
                n = n5 + 2;
                for (n3 = n5; !(n3 < 0 || this._target.getComponent(n3).isVisible() && this.getConstraintMap().get(this._target.getComponent(n3)) != "fix"); --n3) {
                    --n5;
                }
                for (n3 = n; !(n3 >= this._target.getComponentCount() || this._target.getComponent(n3).isVisible() && this.getConstraintMap().get(this._target.getComponent(n3)) != "fix"); ++n3) {
                    ++n;
                }
                if (n5 < 0 || n >= this._componentSizes.length) {
                    return;
                }
            }
            int n6 = n5;
            this._componentSizes[n6] = this._componentSizes[n6] + (n2 - n4);
            int n7 = n;
            this._componentSizes[n7] = this._componentSizes[n7] - (n2 - n4);
            Component component = this._target.getComponent(n5);
            Component component2 = this._target.getComponent(n);
            Serializable serializable = this.this$0;
            serializable = this._target.getComponentOrientation();
            if (JideSplitPaneLayout.resolveAxis(this._axis, (ComponentOrientation)serializable) == 0) {
                if (component instanceof JComponent) {
                    ((JComponent)component).setPreferredSize(new Dimension(this._componentSizes[n5], component.getPreferredSize().height));
                }
                if (component2 instanceof JComponent) {
                    ((JComponent)component2).setPreferredSize(new Dimension(this._componentSizes[n], component2.getPreferredSize().height));
                    return;
                }
            } else {
                if (component instanceof JComponent) {
                    ((JComponent)component).setPreferredSize(new Dimension(component.getPreferredSize().width, this._componentSizes[n5]));
                }
                if (component2 instanceof JComponent) {
                    ((JComponent)component2).setPreferredSize(new Dimension(component2.getPreferredSize().width, this._componentSizes[n]));
                }
            }
        }

        protected final boolean calculateComponentSizes(int n, int n2, int n3) {
            JideSplitPane jideSplitPane = this.this$0;
            return super.calculateComponentSizes(n, n2, n3);
        }
    }
}

