/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.UIDefaultsLookup;
import java.lang.reflect.Method;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;

public class LazyActionMap
extends ActionMapUIResource {
    private transient Object _loader;

    public static void installLazyActionMap(JComponent jComponent, Class clazz, String string) {
        ActionMap actionMap = (ActionMap)UIDefaultsLookup.get(string);
        if (actionMap == null) {
            actionMap = new LazyActionMap(clazz);
            UIManager.getLookAndFeelDefaults().put(string, actionMap);
        }
        SwingUtilities.replaceUIActionMap(jComponent, actionMap);
    }

    private LazyActionMap(Class clazz) {
        this._loader = clazz;
    }

    public void put(Object object, Action action) {
        this.loadIfNecessary();
        super.put(object, action);
    }

    public Action get(Object object) {
        this.loadIfNecessary();
        return super.get(object);
    }

    public void remove(Object object) {
        this.loadIfNecessary();
        super.remove(object);
    }

    public void clear() {
        this.loadIfNecessary();
        super.clear();
    }

    public Object[] keys() {
        this.loadIfNecessary();
        return super.keys();
    }

    public int size() {
        this.loadIfNecessary();
        return super.size();
    }

    public Object[] allKeys() {
        this.loadIfNecessary();
        return super.allKeys();
    }

    public void setParent(ActionMap actionMap) {
        this.loadIfNecessary();
        super.setParent(actionMap);
    }

    private void loadIfNecessary() {
        if (this._loader != null) {
            Object object = this._loader;
            this._loader = null;
            object = (Class)object;
            try {
                Method method = ((Class)object).getDeclaredMethod("loadActionMap", LazyActionMap.class);
                method.invoke(object, this);
                return;
            }
            catch (Exception exception) {
                System.out.println("LazyActionMap unable to load actions " + object);
            }
        }
    }
}

