/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.Resource;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.ResourceBundle;

public final class QuarterNameConverter
implements ObjectConverter {
    public static ConverterContext CONTEXT = new ConverterContext("QuarterName");

    public final String toString(Object object, ConverterContext converterContext) {
        if (object == null || !(object instanceof Number)) {
            return "";
        }
        int n = ((Number)object).intValue();
        if (n >= 0 && n < 4) {
            return MessageFormat.format(this.getQuarterNamePattern(), n + 1);
        }
        return "";
    }

    public final Object fromString(String objectArray, ConverterContext object) {
        object = this.getQuarterNamePattern();
        try {
            objectArray = new MessageFormat((String)object).parse((String)objectArray);
            if (objectArray.length > 0) {
                return Integer.parseInt("" + objectArray[0]) - 1;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return 0;
    }

    public final boolean supportFromString$5f33f571() {
        return true;
    }

    private String getQuarterNamePattern() {
        String string = "Quarter.quarter";
        ResourceBundle resourceBundle = Resource.getResourceBundle(Locale.getDefault());
        return resourceBundle.getString(string);
    }
}

