/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.Resource;
import java.util.Locale;

public final class BooleanConverter
implements ObjectConverter {
    public final String toString(Object object, ConverterContext converterContext) {
        if (Boolean.FALSE.equals(object)) {
            return BooleanConverter.getFalse();
        }
        if (Boolean.TRUE.equals(object)) {
            return BooleanConverter.getTrue();
        }
        return "";
    }

    public final Object fromString(String string, ConverterContext converterContext) {
        if (string.equalsIgnoreCase(BooleanConverter.getTrue())) {
            return Boolean.TRUE;
        }
        if (string.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (string.equalsIgnoreCase(BooleanConverter.getFalse())) {
            return Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        return null;
    }

    public final boolean supportFromString$5f33f571() {
        return true;
    }

    private static String getTrue() {
        String string = Resource.getResourceBundle(Locale.getDefault()).getString("Boolean.true");
        if (string != null) {
            return string.trim();
        }
        return string;
    }

    private static String getFalse() {
        String string = Resource.getResourceBundle(Locale.getDefault()).getString("Boolean.false");
        if (string != null) {
            return string.trim();
        }
        return string;
    }
}

