######################################################################
# linktrack.inc.pl - This is PyukiWiki, yet another Wiki clone.
# $Id: linktrack.inc.pl,v 1.72 2011/10/10 09:46:21 papu Exp $
#
# "PyukiWiki" version 0.2.0-alpha15 $$
# Author: Nanami http://nanakochi.daiba.cx/
# Copyright (C) 2004-2011 by Nekyo.
# http://nekyo.qp.land.to/
# Copyright (C) 2005-2011 PyukiWiki Developers Team
# http://pyukiwiki.sourceforge.jp/
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sourceforge.jp/
# License: GPL2 and/or Artistic or each later version
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return:LF Code=UTF-8 1TAB=4Spaces
######################################################################
# This is extented plugin.
# To use this plugin, rename to 'linktrack.inc.cgi'
######################################################################
#
# リンクトラッキングカウンター
#
######################################################################

# この変数に自分のURL（http://等を除く) を入れれば、
# その分のカウンターを弾く
#
$linktrack::ignoredomain = $ENV{HTTP_HOST}
	if($linktrack::ignoredomain eq '');
######################################################################

# Initlize												# comment

sub plugin_linktrack_init {
	my $header=<<EOM;
<script type="text/javascript"><!--
function Ck(b,a){b="?cmd=ck&amp;lk="+b;if(a=="r"){b=b+"&amp;r=y";d.location=b;return true}else{if(a!=""){openURI(b,a)}else{d.location=b}}return false};
//-->
</script>
EOM
	return ('init'=>1 ,  'header'=>$header
		, 'func'=>'make_link_target', 'make_link_target'=>\&make_link_target);
}

$::linktrack_link_id=0;

sub make_link_target {
	my($url,$class,$target,$escapedchunk,$flag)=@_;
	$flag=$::use_popup if($flag eq '');
	$class=&htmlspecialchars($class);
	$target=&htmlspecialchars($target);
	$escapedchunk=&htmlspecialchars($escapedchunk);
	my $popup_allow=$::setting_cookie{popup} ne '' ? $::setting_cookie{popup}
					: $flag+0 ? 1 : 0;
	my $target=$popup_allow != 0 ? $target : '';
	$target='' if($flag eq 2 && $url=~/ttp\:\/\/$ENV{HTTP_HOST}/);
	if($target ne '' && $flag eq 3) {
		my $tmp=$::basehref;
		$tmp=~s/\/.*//g;
		$target='' if($url=~/\Q$tmp/);
	}
	my $mydomain=0;
	foreach(split(/,/,$linktrack::ignoredomain)) {
		if($url=~/\/\/$_/) {
			$mydomain=1;
		}
	}
	my $escapedurl;
	if($mydomain eq 0) {
		$escapedurl="?cmd=ck&amp;lk=" . &dbmname(&unescape($url));
		$::linktrack_link_id++;
		if($target eq '') {
			return qq(<a href="$url" @{[$class eq '' ? '' : qq(class="$class")]} title="$escapedchunk" onclick="return Ck('$escapedurl','');" oncontextmenu="return Ck('$escapedurl','r');">);
		} elsif($::is_xhtml) {
			return qq(<a href="$url" @{[$class eq '' ? '' : qq(class="$class")]} title="$escapedchunk" onclick="return Ck('$escapedurl','$target');" oncontextmenu="return Ck('$escapedurl','r');">);
		} else {
			return qq(<a href="$url" @{[$class eq '' ? '' : qq(class="$class")]} title="$escapedchunk" onclick="return Ck('$escapedurl','$target');" oncontextmenu="return Ck('$escapedurl','r');">);
		}
	} else {
		if($target eq '') {
			return qq(<a href="$url" @{[$class eq '' ? '' : qq(class="$class")]} title="$escapedchunk">);
		} elsif($::is_xhtml) {
			return qq(<a href="$url" @{[$class eq '' ? '' : qq(class="$class")]} title="$escapedchunk" onclick="return openURI('$url','$target');">);
		} else {
			return qq(<a href="$url" @{[$class eq '' ? '' : qq(class="$class")]} target="$target" title="$escapedchunk">);
		}
	}
}

1;
__DATA__
sub plugin_linktrack_setup {
	return(
	'en'=>'Out link to tracking counter.',
	'jp'=>'外部リンクへのカウンターを取る',
	'override'=>'make_link_target',
	'url'=>'http://pyukiwiki.sourceforge.jp/PyukiWiki/Plugin/ExPlugin/linktrack/'
	);
__END__
=head1 NAME

linktrack.inc.pl - PyukiWiki Plugin

=head1 SYNOPSIS

Out link to tracking counter

=head1 USAGE

rename to linktrack.inc.cgi

setting info/setup.cgi to this value for use.

$linktrack::ignoredomain : my wiki url (default = Hostname)

Example, http:// prefix do not writte.

To specify multiple Separate of [,]

example : abcdefg.com/~user,example.com

=head1 OVERRIDE

make_link_target function was overrided.

=head1 SEE ALSO

=over 4

=item PyukiWiki/Plugin/ExPlugin/linktrack

L<http://pyukiwiki.sourceforge.jp/PyukiWiki/Plugin/ExPlugin/linktrack/>

=item PyukiWiki CVS

L<http://sourceforge.jp/cvs/view/pyukiwiki/PyukiWiki-Devel/lib/linktrack.inc.pl?view=log>

=back

=head1 AUTHOR

=over 4

=item Nanami

L<http://nanakochi.daiba.cx/> etc...

=item PyukiWiki Developers Team

L<http://pyukiwiki.sourceforge.jp/>

=back

=head1 LICENSE

Copyright (C) 2005-2011 by Nanami.

Copyright (C) 2005-2011 by PyukiWiki Developers Team

License is GNU GENERAL PUBLIC LICENSE 2 and/or Artistic 1 or each later version.

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=cut
