#!/usr/bin/python
"""pydicfunc.cgi

  Author: tgz <tgz@users.sourceforge.jp>
  Version: 1.2
  Last Modified: 2004/01/18

  This program is based on GPL.

"""
import cgi
from re import compile
from string import replace
import ndtplib


class NDTPSession:
    def __init__(self, server):
        self.server = server
        self.NDTP = ndtplib.NDTP(self.server)
        self.version, self.dictdict = self.NDTP.version(), self.NDTP.listdic()
        self.NDTP.quit()
        self.MAXHIT = 5

    def show_header(self, word = None):
        print 'Content-type: text/html'
        print ''
        print '<html>'
        print '<head>'
        if word != None:
            print '<title>Result of \"%s\"</title>' % word
        print '</head>'
        print '<body>'

    def show_footer(self):
        print '<hr>'
        print '%s' % self.version
        print '</body>'
        print '</html>'

    def show_result(self, num, word):
        self.NDTP.connect(self.server)
        self.NDTP.setdic(num)
        result = self.NDTP.ask(word)
        hit = len(result.keys())
        self.NDTP.quit()
        print '[Query: %s]' % word
        print '[Result: %d hits]' % hit
        if hit >= self.MAXHIT:
            print '<hr>'
            for key in result.keys():
                print '<a href=\"/cgi-bin/pydicfunc.cgi?server=%s&num=%s&\
header=%s\">%s</a><br>' % (self.server, num, result[key], key)
        else:
            print '<hr>'
            for key in result.keys():
                self.show_main(num, result[key])

    def show_main(self, num, addr):
        prog = compile('&lt;(?P<link>[0-9a-zA-Z^>]+:[0-9a-zA-Z^>]+)&gt;')
        self.NDTP.connect(self.server)
        self.NDTP.setdic(num)
        result = self.NDTP.getmain(addr)
        self.NDTP.quit()
        result = replace(result, '<', '&lt;')
        result = replace(result, '>', '&gt;')
        link = prog.search(result)
        while link != None:
            result = replace(result, link.group(), \
'<a href=\"/cgi-bin/pydicfunc.cgi?server=%s&num=%s&header=%s\">%s</a>' % \
(self.server, num, link.group('link'), '(link)'))
            link = prog.search(result)
        result = replace(result, '\n', '<br>\n')
        print result

def show_error(message):
    print '<html>'
    print '<head>'
    print '<body>'
    print '<h2>Error</h2><br>'
    print '%s<br>' % message
    print '</body>'
    print '</html>'

def main():
    try:
        form = cgi.FieldStorage()
        if form.has_key('server'):
            server = form['server'].value
        if form.has_key('num'):
            num = int(form['num'].value)

        n = NDTPSession(server)

        if form.has_key('word'):
            word = form['word'].value
            n.show_header(word)
            print '<h1>%s</h1>' % n.dictdict[num]
            n.show_result(num, word)
        elif form.has_key('header'):
            header = form['header'].value
            n.show_header(header)
            print '<h1>%s</h1>\n<hr>' % n.dictdict[num]
            n.show_main(num, header)

        n.show_footer()

    except Exception, message:
        show_error(message)

if __name__=='__main__':
    main()
