# coding: utf-8

import utils.weakvaluelist as weakvaluelist
import weakref, inspect, warnings, re

# class ConcreteTerminal(object)

# TRACE = True
try: TRACE #@UndefinedVariable
except NameError: TRACE=False

def getobservers(logic,name):
    return [a().owner for a in getattr(logic.__class__,name).attr(logic).node.observers]

pylafii_getobservers = getobservers

class _PortException(Exception):
    def __init__(self, value):
        self.value = value
    def __str__(self):
        return repr(self.value)

class RulePortSetError(_PortException): pass

class RuleRecursiveCall(Exception): pass

class Node:
    '''監視対象。いずれからも監視されなくなったら自動的に削除される。メンバ変数による参照禁止'''
    def __init__(self,value):
        self.value = value
        self.getlog = weakref.WeakKeyDictionary() # この node に依存するを get 参照した Rule Terminal の attr を記録
        self.observers = weakvaluelist.WeakValueList() # オブザーバへの逆参照を格納する弱参照リスト（循環参照を防止するために逆参照を用いた）
    def register(self,observer):
        if not self.observers.count(observer): # もし、observerに対する弱参照を保持していなければ
            self.observers.append(observer) # オブザーバの弱参照をリストに保持
    def unregister(self,observer):
        self.observers.cleanup() # 削除したオブジェクトをコールしないよう空になった弱参照をクリア
        self.observers.remove(observer) # 与えられたobserverに対する弱参照をリストから削除
    def notify(self,event,ignore={}):
        '''監視者へ変更を通知する。observer.update(event)を起動する。起動の順番は登録順。'''
        ''' ！！！【変更予定】Ruleを優先しないとだめ！！！'''
        self.observers.cleanup() # 削除したオブジェクトをコールしないよう空になった弱参照をクリア
        for o in self.observers.tolist():
            #if TRACE:
            #    if o in ignore:
            #        print 'ignored %s set event' % o.term.name
            #if not o in ignore: o.notify(event) # オブザーバひとつひとつのupdate()をobserversの順番に起動
            o.notify(event)
    def get_observers(self):
        self.observers.cleanup()
        return self.observers.tolist()
    @property
    def observers_(self):
        self.observers.cleanup()
        return self.observers.tolist()
    @property
    def rule(self):
        for attr in self.observers_:
            if attr:
                if isinstance(attr.term,Rule):
                    return attr
        return
        
#
# evaluating_rule
# ルールが実行されている間、依存しているターミナルおよびルールが結合しているターミナル自身の当該メンバに
# ルールが結合しているアトリビュートを保持するリスト
#

class Attribute(object):
    def __init__(self,owner,terminal,value):
        self.owner    = weakref.ref(owner)
        self.terminal = weakref.ref(terminal)
        self.ignore   = weakref.WeakKeyDictionary()
        self.node     = None
        self.evaluating_rule = []
        self.register(Node(value))
    def register(self,node):
        self.unregister() # 監視を解除
        node.register(self) # 監視していることを通知
        self.node = node # 監視対象を保持するために参照を保持する
    def unregister(self):
        if not self.node == None: # すでになにかを監視しているならば
            self.node.unregister(self) # 監視をやめることを通知
            self.node = None # 監視対象を保持するための参照を削除
    def notify(self,event):
        self.terminal().notify(self,event)
    @property
    def term(self): return self.terminal()
        
# Generator ?
class Terminal(object):
    '''
    クラス宣言時に decorator によって生成される、インスタンス属性へのアクセッサ
    '''
    def __init__(self,init_value=None):
        self.init_value = init_value
        self.name = None # 最初にset/get/linkが呼び出されたときにオーナーを検索して取得
        self.from_rule = None
    def __get__(self, owner, ownertype):
        if owner == None: return self
        attr = self.get_attribute(owner)
        #
        # set イベント処理中には get 参照されてもイベントは発行せずに set された内容を返す
        #
        try: getattr(attr,'__set_event')
        except AttributeError:
            pass
        else:
            if TRACE: print '= get = %s.%s without notification' % (owner.__class__.__name__,self.name)
            if attr.evaluating_rule:
#                if TRACE: print '1: getlog of %s is appended %s' % (attr.term.name,attr.evaluating_rule[-1].term.name)
                attr.node.getlog[attr.evaluating_rule[-1]] = None # get 参照したことを対象の node.getlog へ記録
            # 2012.10.17 上の行が無効化されていたのでrule2(self,rule1)のように依存実行されるルールが複数回起動されてしまっていた
            return attr.node.value
        if TRACE: print '= get = %s.%s' % (owner.__class__.__name__,self.name)
        attr.node.notify('get')
        return attr.node.value
    def __set__(self, owner, value):
        node = self.get_attribute(owner).node
        node.value = value
        if TRACE: print '1: clear getlog of', self.name
        node.getlog.clear() # node を変更したので node.getlog を消去
        if TRACE: print '= set = %s.%s' % (owner.__class__.__name__,self.name)
        node.notify('set')
    def notify(self, attr, event):
        # 正しいイベントidが送られてきたか確認
        if event == 'get':
            if attr.evaluating_rule:
#                if TRACE: print '2: getlog of %s is appended %s' % (attr.term.name,attr.evaluating_rule[-1].term.name)
                attr.node.getlog[attr.evaluating_rule[-1]] = None # getlog に実行中のルールを記録する
            return
        if not event == 'set': return
        #
        # 再起呼び出しが発生しないようにフラグを立てる
        setattr(attr,'__set_event',True)
        if TRACE: print '- set -> %s.%s' % (attr.owner().__class__.__name__,self.name)
        if TRACE: print 'start blocking notification for', attr.term.name
        owner = attr.owner()
        #
        # 依存関係のある rule を起動
        #
        for rule_name, v in terminals(owner).iteritems(): # オーナーが保持しているターミナルのなかから
            if isinstance(v,Rule) and v.mode == 'interactive': # ルールが見つかったら
                if TRACE: print 'Rule found: %s.%s' % (owner.__class__.__name__,rule_name)#,
                #if TRACE: print 'evaluating with', [o.term.name for o in attr.evaluating_rule]
                rule_attr = v.get_attribute(owner)
                rule_attr.terminal().new_dependency(rule_attr) # ルールの依存リストが確かに存在するかどうかチェックする
                #if TRACE: print '2: clear getlog of', self.name
                #attr.node.getlog.clear() # 余分にチェックしてしまった未更新フラグをクリアする
                if rule_attr.evaluating_rule:
                    if rule_attr.evaluating_rule[-1] == rule_attr:
                        if TRACE: print 'This rule is evaluating now'
                        continue
                term = rule_attr.terminal()
                # 未更新の Terminal がひとつもなければルールを実行する
                for name in term.dependency:
                    if name == self.name: # １つでも自身に依存していたらルールを実行可能か評価する
                        if TRACE: print '%s.%s checks' % (owner.__class__.__name__,rule_name),
                        for myname in term.dependency: # 未更新の依存 Terminal がひとつでも見つかればルールを実行しない
                            if TRACE: print '[%s]' % myname,
                            if rule_attr in terminal(owner,myname).get_attribute(owner).node.getlog:
                                if TRACE: print 'not modified'
                                break # ログに attr が見つかれば未更新
                        else: # break で脱出しなかった場合
                            if not len(rule_attr.terminal().dependency) == 0: # 依存関係が空()でない場合には
                                if TRACE: print '\n%s.%s - get -> %s.%s' % (rule_attr.owner().__class__.__name__,self.name,rule_attr.owner().__class__.__name__,rule_name)
                                #
                                #
                                if rule_attr not in rule_attr.evaluating_rule: # これから実行しようとするルールが現在実行中でなければ
                                    #print 'notify(rule_attr,\'get\')', rule_attr.owner, rule_attr.terminal().name
                                    # __set_eventフラグがたっている状態なので、rule内からここへ発信されるgetイベントが抑圧されてしまう
                                    # ルールを実行した後に更新ログ getlog を登録しなければならない
                                    # 事前に登録すると、たとえばルールに影響を与えるターミナルがこれひとつしかなかった場合に
                                    # ルール側で更新の必要なしと判断されてしまうのでよくない。
                                    term.notify(rule_attr,'get')
#                                    if TRACE: print '3: getlog of %s is appended %s' % (attr.term.name,rule_attr.term.name)
                                    attr.node.getlog[rule_attr] = None # getlog に実行したルールを記録する
                                    #print 'notify(rule_attr,\'get\')', rule_attr.owner, 'finished'
                                #term.notify(rule_attr,'get') 
                                #
                                #
#                if TRACE: print '\n%s.%s - get ->' % (attr.owner().__class__.__name__,self.name)
#                term.notify(attr,'get')
        try: delattr(attr,'__set_event')
        except AttributeError: pass
        if TRACE: print 'end blocking notification for', attr.term.name
    def get_name(self, owner): # オーナーインスタンスからの参照名を取得する
        if self.name == None: # オーナーインスタンスが生成されてから最初に参照されたときには名称探索をする
            # 呼び出しのコンテキストから、オーナーインスタンスにオブジェクトが存在することが保証されているので（はずなので）チェック省略
            for name, v in terminals(owner).iteritems(): # オーナークラスのメンバ全体について
                if v == self:
                    self.name = name
                    return name # 自身と一致するインスタンスの名称を返す
        else:
            return self.name
    def get_terminals(self,owner):
        '''
        オーナが保持するすべてのターミナルのリストを取得する
        '''
        terminals = {}
        for cls in inspect.getmro(owner.__class__):
            for k in cls.__dict__:
                v = cls.__dict__[k]
                if isinstance(v,Terminal):
                    if not k in terminals: terminals[k] = v
        return terminals
    def new_attributes(self,owner):
        '''
        オーナーに属するすべてのターミナルの属性を生成する
        '''
        terminals = self.get_terminals(owner)
        for name, terminal in terminals.iteritems():
            owner.__dict__[name] = Attribute(owner,terminal,terminal.init_value)
    def init_getlog(self,owner):
        #
        # オーナーに属するすべてのターミナルに関連する getlog を初期化する
        # ルールはそれ自身については更新済み、依存ターミナルについては未更新とする
        # ルール以外については、自身のターミナルについて未更新とする
        #
        terminals = self.get_terminals(owner)
        for name, terminal in terminals.iteritems(): # すべての Terminal 一族について
            attr = owner.__dict__[name]
            if isinstance(terminal,Rule): # ルールにつて
                for myname in terminal.dependency:
#                    if TRACE: print '4: getlog of %s is appended %s' % (myname,attr.term.name)
                    owner.__dict__[myname].node.getlog[attr] = None
    def get_attribute(self,owner):
        #
        # オーナーインスタンスから属性を取得する
        #
        name = self.get_name(owner)
        #
        # 属性の生成
        #
        if not name in owner.__dict__: # まだオーナーに当該属性が生成されていなければすべての属性を生成する
            self.new_attributes(owner)
        return owner.__dict__[name] # 属性を返す
    attr = get_attribute

Cell = Terminal

class Share(Terminal): pass

class Rule(Terminal):
    def __call__(self,*args,**kw):
        return self.rule(*args,**kw)
    def __init__(self,*dependency,**kw):
        if 'init' in kw:
            init = kw['init']
            self._initialized_ = True
        else:
            init = None
            self._initialized_ = False
        Terminal.__init__(self,init_value=init)
        #
        # キーワードオプションの処理
        #
        if 'rule' in kw: self.rule = kw['rule']
        if 'mode' in kw: self.mode = kw['mode']
        else: self.mode = 'interactive'
        if 'arguments' in kw: self.arguments = kw['arguments']
        else: self.arguments = ()
        if 'defaults' in kw: self.defaults = kw['defaults']
        else: self.defaults = ()
        #
        # 依存関係リストの処理
        #
        dependency = list(dependency)
        if 'ignore' in kw:
            if kw['ignore'] == 'all':
                dependency = []
            else:
                if isinstance(kw['ignore'],list) or isinstance(kw['ignore'],tuple):
                    for ignore in kw['ignore']:
                        try: dependency.remove(ignore)
                        except ValueError: pass
                elif isinstance(kw['ignore'],str):
                    try: dependency.remove(kw['ignore'])
                    except ValueError: pass
        self.dependency = list(dependency)
    # 書き込みも許可する
    #def __set__(self, owner, value):
    #    raise RulePortSetError("cannot set() a rule cell")
    def notify(self,attr,event):
        #
        # ルールがgetされたら
        # １）依存しているターミナルがひとつでも更新されていたら
        # 　　１ー１）判定基準：ターミナルの関連ノードのgetlog辞書メンバに自身の属性子をキーとしたアイテムが保存されているか？
        # ２）ルールを実行して
        # ３）実行結果をノードに保存して
        # 　　３ー１）更新判定のため関連ノードのgetlog辞書メンバをクリアする
        # ４）自身の関連ノードを監視している属性子へsetを通知する
        # 　　４ー１）ただしignoreメンバに含まれる属性子は無視する
        # 　　４ー２）通知後にignoreメンバをクリアする
        # 　　４ー３）他のルール内から直接参照されている場合には通知漏れしてしまう
        # ５）更新結果が影響を与えるルールを起動する
        #
        if not event == 'get': return # get イベントのみ処理の対象とする
        #
        # もしも関連するルールですでに実行中のものがあれば getlog に直近のルールを記録する
        #
        if attr.evaluating_rule:
#            if TRACE: print '5: getlog of %s is appended %s' % (attr.term.name,attr.evaluating_rule[-1].term.name)
            attr.node.getlog[attr.evaluating_rule[-1]] = None
        #
        # もしもルール関数が定義されていなければエラー
        #
        try: self.rule
        except: return # undefined rule error!!
        if TRACE: print '- get -> %s.%s' % (attr.owner().__class__.__name__,self.name)
        #
        # Event からの循環参照を検出したら脱出する
        #
        for o in attr.node.get_observers(): # 関連ノードを監視しているすべてのターミナル属性子のなかの
            if isinstance(o.term,Event): # Event型の属性子について
                if attr == o.term.from_rule: # from_ruleってなに？
                    return
        # 
        # 循環参照を検出したら検出フラグをたてて脱出する
        #
        try: attr.passed # block recursive access
        except AttributeError: pass
        else:
            setattr(attr,'detected',True)
            return
        #
        # ひとつでも更新されている Terminal があればルールを実行する
        #
        self.new_dependency(attr)
#        if not self._initialized_: # 初期値がまだ設定されていなければ要更新
#            self._initialized_ = True
#        elif not self.require_update(attr): return
        if TRACE: print '[%s]:' % (self.name)
        if not self.require_update(attr):
            return
        owner = attr.owner()
        #
        # Event 内で自身を参照したときに無限循環してしまう不具合への対処
        # @event()
        # def event(self): self.rule
        # event.set -> rule.get -> 
        #
        for o in attr.node.get_observers(): # ルール属性子の関連ノードを監視しているすべての属性子のなかの
            if isinstance(o.terminal(),Event): # Event型の属性子について
                o.from_rule = attr # その属性子のfrom_ruleにルール属性子をセットする
        #
        # ルールの実行
        #
        if TRACE: print 'exec %s.%s.rule' % (attr.owner().__class__.__name__,self.name)
        for name in self.dependency:
            terminal(owner,name).attr(owner).evaluating_rule.append(attr) # 自身に影響を与える属性子のevaluating_ruleリストメンバ(LILO)に最後尾に自身の属性子を追加する
        attr.evaluating_rule.append(attr) # 自身の属性子のevaluating_ruleリストメンバの最後尾に自身の属性子を追加する
        arguments = [getattr(owner,name) for name in self.arguments] # 引数にリンクされたターミナルの値を取得する
        attr.node.value = self.rule(owner,*arguments) # rule を実行してその結果を node に保存する
        attr.evaluating_rule = attr.evaluating_rule[:-1]
        for name in self.dependency: terminal(owner,name).attr(owner).evaluating_rule = terminal(owner,name).attr(owner).evaluating_rule[:-1] # LILO からポップする
        if TRACE: print 'fin %s.%s.rule' % (attr.owner().__class__.__name__,self.name)
        if TRACE: print '3: clear getlog of', self.name
        attr.node.getlog.clear() # node を変更したので node.getlog を消去
        if TRACE: print '%s.%s - set ->' % (attr.owner().__class__.__name__,self.name),
        #if TRACE: print 'ignore with', [k.term.name for k,v in attr.ignore.iteritems()]
        #attr.node.notify('set',ignore=attr.ignore) # 自身に関連したターミナルにset(更新)イベントを送出して紐づけられたメソッドを実行する。ただし、ignoreに含まれる属性子は無視する。
        #attr.ignore.clear() # 無視リストをクリアする
        attr.node.notify('set') # 自身に関連したターミナルにset(更新)イベントを送出して紐づけられたメソッドを実行する
        #
        # 依存関係のあるカスケード接続ルールを起動（ルール中で自分を参照されたときは Event と同じように処理する）
        #
        influenced_rule = self.search_influenced_rule(owner)
        for term in influenced_rule:
            if TRACE: print '%s of getlog %s' % (self.name,dict(attr.node.getlog))
            if TRACE: print '[%s]' % term.name,
            self.try_rule(term,owner)
        #
        #
        #
    def new_dependency(self,attr):
        owner = attr.owner()
        if isinstance(self.dependency,list): # 依存ターミナルが実際に存在するのか一度だけチェックする
            dependency = []
            terms = terminals(owner)
            for depname in self.dependency:
                if depname in terms:
                    dependency.append(depname)
                    # terminal(owner,depname).attr(owner).node.getlog[attr] = None
                    #if self.name == 'theory_ang':
                    #    print self.name, '_initialized_', self._initialized_
                    #    print dict(terminal(owner,depname).attr(owner).node.getlog)
                    if self._initialized_:
#                        if TRACE: print '6: getlog of %s is appended %s' % (depname,attr.term.name)
                        terminal(owner,depname).attr(owner).node.getlog[attr] = None
#                    else:
#                        try:
#                            del terminal(owner,depname).attr(owner).node.getlog[attr]
#                        except:
#                            pass
            if not self._initialized_: self._initialized_ = True
            self.dependency = tuple(dependency)
    def search_influenced_rule(self,owner):
        #
        # 同一オーナのなかで影響を与えるルールを検索する
        #
        result = []
        for name, v in terminals(owner).iteritems(): # オーナの保持するすべてのターミナルのなかの
            if isinstance(v,Rule) and v.mode == 'interactive': # ルール型ターミナルそれぞれについて
                term = v.get_attribute(owner).terminal() # この行って無駄じゃない？
                for name in term.dependency: # 影響を受けるターミナルのなかで
                    if name == self.name: # 自身が存在するものを（自身が影響を与えるターミナルを）
                        result.append(v) # resultへ記録する
                        break
        return result
    def try_rule(self,
                 term, # 起動したいルール
                 owner # オーナオブジェクト
                 ):
        '''
        起動したいルールに影響を与えるターミナルがすべて更新済みであり、対象ターミナルのルールが実行中でなければルールを起動する
        例外として、
        '''
        #
        # 起動したいルールに影響を与えるターミナルがまったくなければ、なにもせず脱出する
        # 無限ループをさけるため？悪影響おおきすぎるかも
        #
        if len(term.dependency) == 0: return
        #
        # 起動したいルールに影響を与えるターミナルがすべて更新済みかどうか判定する
        #
        attr = term.get_attribute(owner) # 起動したいルールの属性子を取得する
        #
        # 起動したいルールに影響を与える属性子のうち Terminal のインスタンスのみを残す
        #
        for name in term.dependency:
            if terminal(owner,name) is None:
                term.dependency.remove(name)
        #
        for name in term.dependency: # 起動したいルールに影響を与える属性子について
            if attr in terminal(owner,name).get_attribute(owner).node.getlog:
            #if attr in owner.__class__.__dict__[name].get_attribute(owner).node.getlog:
                # 影響を与える属性子に関連づけられたノードのgetlogに起動したいルールの属性子が含まれていれば、なにもせず脱出する
                break
        else:
            #
            # 起動したいルールに影響を与えるターミナルがすべて更新済みであって
            #
            if TRACE: print '\n%s.%s - get ->' % (attr.owner().__class__.__name__,self.name)
            #setattr(attr,'from_rule',True)
            #
            #
            if attr not in attr.evaluating_rule: # 起動したいルールがまだ実行中でなければ
                term.notify(attr,'get') # ルールを起動する
            #term.notify(attr,'get')
            #
            #
            #delattr(attr,'from_rule')
            return True
        return
    def require_update(self,attr):
        self.new_dependency(attr)
        owner = attr.owner()
#        if self.name == 'theory_ang': print 'notify2', self._initialized_
        #if not self._initialized_: # 初期値がまだ設定されていなければ要更新
        #    self._initialized_ = True
        #    return True
#        if self.name == 'theory_ang': print 'notify3', self._initialized_
        if len(self.dependency) == 0: return True # 依存関係が()の場合には常に要更新
        for name in self.dependency:
            dependent = terminal(owner,name).get_attribute(owner)
            if TRACE: print 'checking getlog for %s =' % name,[k.term.name for k,v in dependent.node.getlog.iteritems()]
            rule = dependent.node.rule # このルールに影響を与えるターミナルに関連付けられたルール
            if rule: # ルールが存在していれば
                if TRACE: print '%s.%s' % (owner.__class__.__name__,name), # 影響を与えるターミナル
                if TRACE: print '= %s' % rule.owner().__class__.__name__ # チェックされるルール
                required = rule.term.require_update(rule)
                if required:
                    if TRACE: print 'requires update at least'
                else:
                    if TRACE: print 'skips update'
                if required: # 依存関係のある Rule が要更新であれば自身も要更新
                    return True
            if not attr in dependent.node.getlog: # 依存関係のある Terminal がひとつでも更新されていれば要更新
                return True
        return False
        
class Event(Terminal):
    def __init__(self,value=None,*args,**kw):
        Terminal.__init__(self,value)
        if 'rule' in kw: self.rule = kw['rule']
    def notify(self, attr, event):
        #if event == 'get':
        #    if attr.evaluating_rule: attr.node.getlog[attr.evaluating_rule[-1]] = None # getlog に実行中のルールを記録する
        #    return
        if not event == 'set': return
        try: self.rule
        except: return # undefined rule error!!
        setattr(attr,'__set_event',True)
        if TRACE: print '- set to Event -> %s.%s' % (attr.owner().__class__.__name__,self.name)
        if TRACE: print 'exec %s.%s.rule' % (attr.owner().__class__.__name__,self.name)
        self.rule(attr.owner())
        if TRACE: print 'fin %s.%s.rule' % (attr.owner().__class__.__name__,self.name)
        try: delattr(attr,'__set_event')
        except AttributeError:
            pass
        Terminal.notify(self,attr,event)
        
def new_rule(*args,**kw):
    def _(func):
        spec = inspect.getargspec(func)
        if len(spec.args) > 1:
            print spec.args
            print spec
    #
    if len(args) == 1 and not kw:
        if inspect.isfunction(args[0]):
            return _(args[0])
    return _
    
def rule(*args,**kw):
    # 引数が(func){}の場合には引数無しで表記されたものとして動作します
    def extract_arguments(func):
        spec = inspect.getargspec(func)
        if len(spec.args) > 1:
            arguments = tuple(spec.args[1:])
        else:
            arguments = ()
        if spec.defaults is None:
            defaults = ()
        else:
            defaults = spec.defaults
        return arguments, defaults
    def eliminate_comments(source):
        # コメントを削除する
        comment = re.compile('#.*\n')
        for s in comment.findall(source):
            source = source.replace(s,'\n')
        return source
    def extract_from_source(source):
        member = re.compile('self\.[a-z0-9_\-]*') # すべてのメンバ変数を抽出する
        get = re.compile('self\.[a-z0-9_\-]*.*=') # 参照されているすべてのメンバ変数を抽出する
        name = re.compile('self\.') # メンバ変数名を抽出する
        influence = [name.sub('',s) for s in member.findall(source)]
        for s in [name.sub('',member.match(s).group(0)) for s in get.findall(source)]: influence.remove(s)
        return influence
    def _(func):
        depends = {}
        source = eliminate_comments(inspect.getsource(func))
        for s in extract_from_source(source): depends[s] = None
        for s in args: depends[s] = None
        arguments, defaults = extract_arguments(func)
        for s in arguments: depends[s] = None
        return Rule(rule=func,*[key for key in depends.iterkeys()],arguments=arguments,defaults=defaults,**kw)
    if len(args) == 1 and not kw: # argsの要素がただひとつであり、kwが空であれば引数無し表記の可能性がある
        if inspect.isfunction(args[0]): # さらにただひとつの要素が関数オブジェクトであれば、引数無し表記である
            return _(args[0])
        if inspect.ismethod(args[0]):
            return _(args[0])
    return _
    
def event(*args,**kw):
    def _(func): return Event(rule=func,*args,**kw)
    return _
    
def query_updated(owner,name): # 以前このターミナルから get して以降に、いずこかより本体 node が set により書き換えられたかどうか
    attr = terminal(owner,name).get_attribute(owner)
    return not attr in attr.node.getlog # getlog に記録されていれば書き換えられていない
    
def terminal(owner,name):
    result = None
    terms = terminals(owner)
    if name in terms: result = terms[name]
    return result
    
def terminals(owner):
    '''
    オーナが保持するすべてのターミナルのリストを取得する
    '''
    result = {}
    for cls in inspect.getmro(owner.__class__):
        for k in cls.__dict__:
            v = cls.__dict__[k]
            if isinstance(v,Terminal):
                if not k in result: result[k] = v
    return result

def connect(primary=(None,''),*args):
    #
    # ターミナルを接続する
    #
    primary_node = terminal(*primary).get_attribute(primary[0]).node # primary ターミナルに紐づけられた node を取得
    #
    # 1 node 1 rule の原則チェック
    #
    counter = 0
    for o in primary_node.get_observers():
        if isinstance(o.terminal(),Rule): counter += 1
    for owner,name in args:
        for o in terminal(owner,name).get_attribute(owner).node.get_observers():
            if isinstance(o.terminal(),Rule): counter += 1
# ルールのオーバーライドは、もっとよく検討してから着手するべき
# 代替手段の提供として、大胆な実験であるが、複数の接続を許可して、単純な上書きも許可してみてはどうか。
#    if counter > 1:
#        for owner,name in args:
#            for o in terminal(owner,name).get_attribute(owner).node.get_observers():
#                print owner, o.terminal()
#            for o in terminal(owner,name).get_attribute(owner).node.get_observers():
#                if isinstance(o.terminal(),Rule):
#                    # ルールをオーバーライドする
#                    # ！！！このコードでは親オブジェクトのルールはオーバーライドできないので改善が必要です
#                    setattr(owner.__class__,name,Terminal(o.node.value))
#                    term = getattr(owner.__class__,name)
#                    term.name = name
#                    o.terminal = weakref.ref(term)
#                    print owner, term, getattr(owner,name)
#            for o in terminal(owner,name).get_attribute(owner).node.get_observers():
#                print owner, o.terminal()
    # 複数の接続を許可する
    #if counter > 1:
    #    warnings.warn('Node should be referred from Only One Rule Terminal',stacklevel=2)
    #    return
    #
    # 対象ターミナルの node に紐づけられたすべてのターミナルを primary_node に紐づけなおす
    #
    for owner,name in args:
        for o in terminal(owner,name).get_attribute(owner).node.get_observers():
            o.register(primary_node)
    for o in primary_node.get_observers():
        if o.terminal().__class__ == Event: o.notify('set')
            
_terminal = terminal

def disconnect(terminal=(None,'')):
    attr  = _terminal(*terminal).get_attribute(terminal[0])
    value = attr.node.value
    attr.unregister()
    attr.register(Node(value))
cut = disconnect

def insert(pos,head_tail):
    obj, head, tail = head_tail
    connect(pos,(obj,tail))
    disconnect(pos)
    connect(pos,(obj,head))
