# coding: utf-8
'''
FDTD Solver using Rectlinear Grid on Weave
'''

import numpy, pylaf
import vtk.util
from rlsolver import *

class UIntRectilinearGrid(vtk.vtkRectilinearGrid):
    def __init__(self,**kw):
        self.children  = {}
        self.buffer    = buffer = numpy.zeros((0,0,0),dtype=numpy.uint8)
        self.sigin     = pylaf.Port(buffer)
        self.olddataid = id(buffer)
        self.axes      = [numpy.ones(0,dtype=numpy.double),
                          numpy.ones(0,dtype=numpy.double),
                          numpy.ones(0,dtype=numpy.double)]
        self.range     = (0.,1.)
        self.rmin      = pylaf.Port(self.range[0])
        self.rmax      = pylaf.Port(self.range[1])
        self.reset()
        self.config(**kw)
    def _sigin(self):
        newdata = self.sigin.get()
        if newdata == None: return
        if not self.olddataid == id(newdata): self.reset()
        buffer = self.update(newdata)
        # スケーリング
        min, max = self.rmin.get(), self.rmax.get()
        numpy.clip(buffer,min,max,out=buffer)
        self.buffer[:,:,:] = (255 * ((buffer + min)/max)).astype(self.buffer.dtype)
    def reset(self):
        data           = self.sigin.get()
        self.olddataid = id(data)
        z, y, x        = data.shape
        self.buffer   = numpy.zeros((z, y, x),dtype=self.buffer.dtype)
        nparray        = vtk.util.numpy_support.numpy_to_vtk(self.buffer.reshape(z * y * x))
        self.SetDimensions(x,y,z)
        self.SetScalarTypeToUnsignedShort()
        self.GetPointData().SetScalars(nparray)
    def config(self,**kw):
        if kw == None: return
        if kw.has_key('Spacing'): self.SetSpacing(kw['Spacing'])
        if kw.has_key('Range'):
            self.range = tuple(kw['Range'])
            self.rmin.set(self.range[0])
            self.rmax.set(self.range[1])
    # カスタマイズ
    def update(self,data):
        return data.copy()
