# coding: utf-8
import Tkinter, pylaf
from pylaf import Console
from pylaf.recipes.fdtd import Fdtd
from plfdtd import PollingNew
from plfdtd import UpdatingETime, UpdatingHTime
from plfdtd import UpdatingEField, UpdatingHField
from plfdtd import UpdatingPMLE, UpdatingPMLH
from plfdtd import CubicSin, IProbe, Ymatrix2P, Admittance
from solvers.rlsolver import RectilinearFDTD, RectilinearPML

def invoke(dataset,port,shape,dt,maxiter,dielectric,metal,pmc,frequency=1.):
    tk = Tkinter.Tk()
    fdtd = Console(tk,Fdtd()).component()
    fdtd.config(dataset=dataset)
    fdtd.maxiter.set(maxiter)
    # print fdtd.yee.get().courant.get()
    initialize   = fdtd.initialize # 初期化マネージャの取得
    sequence     = fdtd.sequence   # シーケンスマネージャの取得
    yee, counter = fdtd.yee, fdtd.counter # 各種ポートの取得
    solver       = RectilinearFDTD()
    pml          = RectilinearPML(yee)
    # 初期化シーケンスの登録
    initialize.append(dielectric(dataset=yee))
    # プロセスシーケンスの登録
    sequence.append(UpdatingETime(dataset=yee,counter=counter))
    sequence.append(UpdatingEField(dataset=yee,solver=solver))
    sequence.append(UpdatingPMLE(dataset=yee,solver=pml,clear=fdtd.clear))
    sequence.append(metal(dataset=yee))
    source = CubicSin(dataset=yee,frequency=frequency,position=port[0][1:],direction=port[0][0]); sequence.append(source)
    sequence.append(UpdatingHTime(dataset=yee,counter=counter))
    sequence.append(UpdatingHField(dataset=yee,solver=solver))
    sequence.append(UpdatingPMLH(dataset=yee,solver=pml))
    sequence.append(pmc(dataset=yee))
    probe = IProbe(dataset=yee,elements=port); sequence.append(probe)
    #
    y2p = Tkinter.Frame(Tkinter.Toplevel(tk)); y2p.pack()
    ymat = pylaf.Embed(y2p,Ymatrix2P,pylaf.Standard,text='Ymatrix'); ymat.assign(Ymatrix2P(elements=port)); ymat.pack(side=Tkinter.TOP,fill=Tkinter.X); _ymat = ymat.component()
    #ymat = pylaf.Embed(tk,Ymatrix2P,pylaf.StandardH,text='Ymatrix'); ymat.assign(Ymatrix2P(elements=port)); ymat.pack(side=Tkinter.TOP); _ymat = ymat.component()
    probe.i.link(_ymat.i)
    source.v.link(_ymat.v)
    source.position.link(_ymat.position)
    source.direction.link(_ymat.direction)
    #
    yp1 = pylaf.Embed(y2p,Admittance,text='Port1'); yp1.assign(Admittance()); yp1.pack(side=Tkinter.TOP); _yp1 = yp1.component()
    _ymat.to_p1i.link(_yp1.i)
    _ymat.to_p1v.link(_yp1.v)
    for label in ['v','ix','yr','yi']: yp1.panel('plot').console(label).layout().children['plot'].resize(figsize=(5,4),dpi=50)
    for label in ['yr','yi']:
        yp1.panel('plot').console(label).panel('plot').ax.set_xlim([0.,4.])
        yp1.panel('plot').console(label).panel('plot').ax.set_ylim([-.01,.01])
    #
    yp2 = pylaf.Embed(y2p,Admittance,text='Port2'); yp2.assign(Admittance()); yp2.pack(side=Tkinter.TOP); _yp2 = yp2.component()
    _ymat.to_p2i.link(_yp2.i)
    _ymat.to_p2v.link(_yp2.v)
    for label in ['v','ix','yr','yi']: yp2.panel('plot').console(label).layout().children['plot'].resize(figsize=(5,4),dpi=50)
    for label in ['yr','yi']:
        yp2.panel('plot').console(label).panel('plot').ax.set_xlim([0.,4.])
        yp2.panel('plot').console(label).panel('plot').ax.set_ylim([-.01,.01])
    #
    #timer = Polling(tk,interval=500)
    #fdtd.yee.link(timer.sigin)
    #timer.start()
    #
    #vtkview = Console(Tkinter.Toplevel(tk),pylaf.vtkext.VtkView(),pylaf.StandardH); _vtkview = vtkview.component()
    #vtkview.panel('plot').AddPort('yee')
    #timer_new = pylaf.Embed(vtkview.panel('control'),PollingNew,pylaf.Standard,text='Polling'); timer_new.assign(PollingNew()); timer_new.grid(sticky=Tkinter.E+Tkinter.W); _timer_new = timer_new.component()
    #fdtd.yee.link(_timer_new.sigin)
    #_timer_new.sigout.link(vtkview.panel('plot').yee)
    #timer.sigout.link(vtkview.panel('plot').yee)
    #
    #ssp = YeeUIntScalarStructuredPoints(Range=(.0,.1)) # 表示色の範囲 最大(0.,1.)
    #vtkview.panel('plot').RenderWidget().AddDataSet(ssp)
    #vtkview.panel('plot').yee.link(ssp.sigin)
    #
    #vtkview.panel('plot').RenderWidget().AddActor(pylaf.vtkext.OutlineActor(Color=(0,0,0),Input=ssp))
    #vtkview.panel('plot').RenderWidget().AddVolume(pylaf.vtkext.RayCastVolume(Input=ssp,Alpha=0.1))
    #
    Tkinter.mainloop()
    