# coding: utf-8
import Tkinter, pylaf
from pylaf import Console
from pylaf.recipes.fdtd import Fdtd
from plfdtd import UpdatingETime, UpdatingHTime
from plfdtd import UpdatingEField, UpdatingHField
from plfdtd import UpdatingPMLE, UpdatingPMLH
from plfdtd import CubicSin, ImpedanceDY, Logger, Adapter, ImpedanceView, Polling, YeeViewer
from solvers.rlsolver import RectilinearFDTD, RectilinearPML

def invoke(dataset,port,shape,dt,maxiter,dielectric,metal,pmc,frequency=1.):
    tk = Tkinter.Tk()
    fdtd = Console(tk,Fdtd()).component()
    fdtd.config(dataset=dataset)
    fdtd.maxiter.set(maxiter)
    initialize   = fdtd.initialize # 初期化マネージャの取得
    sequence     = fdtd.sequence   # シーケンスマネージャの取得
    yee, counter = fdtd.yee, fdtd.counter # 各種ポートの取得
    solver       = RectilinearFDTD()
    pml          = RectilinearPML(yee)
    # 初期化シーケンスの登録
    initialize.append(dielectric(dataset=yee))
    # プロセスシーケンスの登録
    sequence.append(UpdatingETime(dataset=yee,counter=counter))
    sequence.append(UpdatingEField(dataset=yee,solver=solver))
    sequence.append(UpdatingPMLE(dataset=yee,solver=pml,clear=fdtd.clear))
    sequence.append(metal(dataset=yee))
    source = CubicSin(dataset=yee,frequency=frequency,position=port[0][1:],direction=port[0][0]); sequence.append(source)
    sequence.append(UpdatingHTime(dataset=yee,counter=counter))
    sequence.append(UpdatingHField(dataset=yee,solver=solver))
    sequence.append(UpdatingPMLH(dataset=yee,solver=pml))
    sequence.append(pmc(dataset=yee))
    probe = ImpedanceDY(dataset=yee); sequence.append(probe)
    #
    view = Console(Tkinter.Toplevel(tk),YeeViewer()); _view = view.component()
    #
    timer = Polling(tk,interval=2000)
    fdtd.yee.link(timer.sigin)
    timer.sigout.link(_view.sigin)
    #
    frm = Tkinter.Frame(Tkinter.Toplevel(tk)); frm.pack()
    logger  = pylaf.Embed(frm,Logger ,pylaf.Standard,text='Logger');  logger.assign( Logger());  logger.pack(side=Tkinter.TOP,anchor=Tkinter.E,fill=Tkinter.X)
    adapter = pylaf.Embed(frm,Adapter,pylaf.Standard,text='Adapter'); adapter.assign(Adapter(dataset=yee)); adapter.pack(side=Tkinter.TOP,anchor=Tkinter.E,fill=Tkinter.X)
    viewer  = pylaf.Embed(frm,ImpedanceView,pylaf.Standard,text='Impedance'); viewer.assign(ImpedanceView()); viewer.pack(side=Tkinter.TOP,anchor=Tkinter.E,fill=Tkinter.X)
    adapter.component().from_probe_i.link(probe.i)
    adapter.component().from_probe_v.link(probe.v)
    adapter.component().to_logger.link(logger.component().value)
    adapter.component().from_logger.link(logger.component().storage)
    adapter.component().to_viewer.link(viewer.component().sigin)
    #
    timer.start()
    Tkinter.mainloop()
    