# coding: utf-8

import numpy, scipy, Tkinter, pylaf.recipes.fdtd
import pylaf
from scipy.interpolate import interp1d
from pylaf import Component, Panel, Port
from pylaf.recipes.fdtd import UpdatingETime, UpdatingHTime
from pylaf.coms.general import Logger
from Tkinter import Text
from numpy import array
import tkFileDialog

# units
# time  : us(1e-9)
# length: mm(1e-3)

# 50 OHM MSTL : EPR = 2.17, H = 0.8, W = 1.6

class Adapter(pylaf.Component):
    class Control(pylaf.Panel): pass
        #def __init__(self,master=None,cnf={},**kw):
        #    pylaf.Panel.__init__(self,master,cnf,**kw)
    def __init__(self,master=None,name=None,dataset=None):
        pylaf.Component.__init__(self,master,name)
        self.dataset = Port(dataset)
        self.from_probe_i = Port(0.).bind(self._from_probe_i)
        self.from_probe_v = Port(0.).bind(self._from_probe_v)
        self.to_logger = Port([])
        self.from_logger = Port([]).bind(self._from_logger)
        self.to_viewer = Port(array([]))
    def _from_probe_i(self):
        self._from_probe_i_updated = True
        try: self._from_probe_v_updated
        except: return
        self._from_probe()
    def _from_probe_v(self):
        self._from_probe_v_updated = True
        try: self._from_probe_i_updated
        except: return
        self._from_probe()
    def _from_probe(self):
        del self._from_probe_i_updated
        del self._from_probe_v_updated
        i, v  = self.from_probe_i.get(), self.from_probe_v.get()
        yee   = self.dataset.get()
        ctime = yee.time[0]
        self.to_logger.set([ctime, i, v])
    def _from_logger(self):
        a = array(self.from_logger.get()).astype('float64')
        self.to_viewer.set(a[:,0],a[:,1:])
        
# (((pylaf.Label,kw(text='Progress'),),(pylaf.Entry,kw(name='progress'),)),
#  ((pylaf.Button,kw(name='trig',text='Trigger')),kw{columnspan=2}))

class GridFrame(Tkinter.Frame):
    def __init__(self,master=None,items=(),cnf={},**kw):
        Tkinter.Frame.__init__(self,master,cnf,**kw)
        for record in items: self.add_row(record)
    def add_row(self,record):
        for field in record: self.add_col(field)

class ImpedanceView(pylaf.Component):
    class Plot(pylaf.Panel):
        def __init__(self,master=None,cnf={},**kw):
            pylaf.Panel.__init__(self,master,cnf,**kw)
            pylaf.Embed(self,pylaf.BasePlot,name='waveform',text='Waveform').pack(side=Tkinter.TOP)
            pylaf.Embed(self,pylaf.BasePlot,name='impedance',text='Impedance').pack(side=Tkinter.TOP)
        def assign(self,component):
            pylaf.Panel.assign(self,component)
            component.waveform.link(self.console('waveform').component().sigin)
            component.impedance.link(self.console('impedance').component().sigin)
    class Control(pylaf.Panel):
        def __init__(self,master=None,cnf={},**kw):
            Panel.__init__(self,master,cnf,**kw)
            def kw(**kwargs): return kwargs
            b, l, e = pylaf.TableBuilder(self), Tkinter.Label, pylaf.Entry
            b.add(pylaf.Button,name='trig',text='Trigger').grid(columnspan=2)
            pylaf.thread.Polling(self,interval=1000,name='polling').start() #@UndefinedVariable
            self.port('polling').bind(self._polling)
        def _polling(self):
            self.component().update()
            pylaf.Panel.update_idletasks(self)
    def __init__(self,master=None,name=None):
        pylaf.Component.__init__(self,master,name)
        self.sigin    = Port(array([])).bind(self._sigin)
        self.waveform = Port(array([]))
        self.impedance = Port(array([]))
        self.trig     = Port(None).bind(self.update)
    def _sigin(self):
        self._sigin_updated = True
    def update(self):
        try: self._sigin_updated
        except: return
        del self._sigin_updated
        sigin = self.sigin.get()
        data  = sigin[1] / abs(sigin[1]).max(axis=0).reshape(1,2)
        self.waveform.set(sigin[0],data)
        i, v = sigin[1][::10,0], sigin[1][::10,1]
        try: impedance = numpy.fft.fft(v) / numpy.fft.fft(i)
        except: return
        t = sigin[0][::10]
        n = len(t)
        m = int(n/2+.5)
        data = numpy.zeros((m,2))
        data[:,0] = numpy.real(impedance)[:m]
        data[:,1] = numpy.imag(impedance)[:m]
        try: freq = numpy.fft.fftfreq(n,t[1]-t[0])[:m] # [GHz]
        except: return
        self.impedance.set(freq,data)
        
class YeeViewer(pylaf.BasePlot):
    def _sigin(self):
        yee = self.sigin.get()
        dx, dy, dz = yee.axes
        ex, ey, ez = yee.e
        hx, hy, hz = yee.h
        ax = [dx[i]+dx[:i].sum() for i,v in enumerate(dx)]
        ay = [dy[i]+dy[:i].sum() for i,v in enumerate(dy)]
        az = [dz[i]+dz[:i].sum() for i,v in enumerate(dz)]
        ax.insert(0,0); ay.insert(0,0); az.insert(0,0)
        ax, ay, az = numpy.array(ax), numpy.array(ay), numpy.array(az)
        px       = .5 * (ax[1:] + ax[:-1])
        py       = .5 * (ay[1:] + ay[:-1])
        pz       = .5 * (az[1:] + az[:-1])
        cx,cy,cz = 1,40,20
        v        = numpy.r_[-1.:1.:21j] ** 5 * .002
        #x = numpy.r_[-.1:.1:21j]
        #v = numpy.sign(x) * (10 ** numpy.abs(x) - 1) / (10 ** .1 - 1)
        #print v
        self.sigout.set(ax[1:],az,numpy.transpose(ey[1:,cy,:]),v)
    class Plot(pylaf.BasePlot.Plot):
        def plot(self,*args,**kwargs):
            self.ax.cla()
            self.ax.contourf(*args,**kwargs)
            self.canvas.show()
            self.update_idletasks() # スレッド処理でButtonに対応するにはupdate_idletasksを使う。updateではButtonがロックすることがある。
            
class PollingNew(pylaf.Component):
    class Control(pylaf.Panel):
        def __init__(self,master=None,cnf={},**kw):
            pylaf.Panel.__init__(self,master,cnf,**kw)
            def kw(**kwargs): return kwargs
            b, l, e = pylaf.TableBuilder(self), Tkinter.Label, pylaf.Entry
            b.add(l,text='Interval').grid().add(e,name='interval').grid()
            b.add(pylaf.Button,name='trig',text='Pause').grid(columnspan=2)
            self.port('interval').set(1000)
            self.port('interval').bind(self._interval)
            self.port('trig').bind(self._trig)
            pylaf.thread.Polling(self,interval=1000,name='polling').start() #@UndefinedVariable
            self.port('polling').bind(self._polling)
            self.counter = 0
        def _interval(self):
            self.children['polling'].stop()
            self.children['polling'].interval = self.port('interval').get()
            self.children['polling'].start()
        def _polling(self):
            self.component().update()
            pylaf.Panel.update_idletasks(self)
        def _trig(self):
            state = self.children['trig'].configure('text')[4]
            if state == 'Pause':
                self.children['trig'].configure(text='Resume')
                self.children['polling'].stop()
            else:
                self.children['trig'].configure(text='Pause')
                self.children['polling'].start()
    def __init__(self,master=None,name=None,interval=200):
        pylaf.Component.__init__(self,master,name)
        self.sigin    = pylaf.Port(None).bind(self._sigin)
        self.sigout   = pylaf.Port(None)
    def _sigin(self): self.__updated = None
    def update(self):
        try: del self.__updated
        except AttributeError: return
        self.sigout.subject.value = self.sigin.subject.value
        self.sigout.subject.notify(pylaf.EVENT_SET)
        
class Polling(Tkinter.Frame):
    def __init__(self,master=None,interval=200,cnf={},**kw):
        Tkinter.Frame.__init__(self,master,cnf,**kw)
        self.sigin    = pylaf.Port(None).bind(self._sigin)
        self.sigout   = pylaf.Port(None)
        self.interval = interval
        self._id      = None
    def start(self):
        self._polling()
    def stop(self):
        if not self._id == None:
            self.after_cancel(self._id)
    def _sigin(self):
        self.__updated = None
    def _polling(self):
        try: self.__updated
        except AttributeError: pass
        else:
            del self.__updated
            self.sigout.subject.value = self.sigin.subject.value
            self.sigout.subject.notify(pylaf.EVENT_SET)
        self._id = self.after(self.interval,self._polling)
        
#class Metal(pylaf.recipes.fdtd.Plugin):
#    def __call__(self):
#        yee = self.dataset.get()
#        ex, ey, ez = yee.e
#        ex[19:21,1,1:-1], ez[19:22,1,1:-1] = 0., 0. # ストリップ線
#        ex[:,0,:], ez[:,0,:] = 0., 0. # 地板（なくても自動的になってる）
        
class Source(pylaf.recipes.fdtd.Plugin):
    def __call__(self):
        yee = self.dataset.get()
        omg = 2 * numpy.pi * 10. # 正弦波源の各周波数
        dx, dy, dz = yee.axes
        ex, ey, ez = yee.e
        hx, hy, hz = yee.h
        # 波源
        i0 = (hx[20,0,0] - hx[20,1,0]) * dx[20]\
           + (hy[20,1,0] - hy[19,1,0]) * dy[1]
        ez[20,1,0] = (numpy.sin(omg * yee.time[1]) + 50. * i0) / dz[0]
        # 終端抵抗
        i1 = (hx[20,0,-1] - hx[20,1,-1]) * dx[20]\
           + (hy[20,1,-1] - hy[19,1,-1]) * dy[1]
        ez[20,1,-1] = 50. * i1 / dz[-1]
        
class DifferentiatedGaussian(pylaf.recipes.fdtd.Plugin):
    def __call__(self):
        yee = self.dataset.get()
        tau0 = .0017 * 10
        if yee.time[1] > 2 * tau0: return 0.
        dx, dy, dz = yee.axes
        ex, ey, ez = yee.e
        hx, hy, hz = yee.h
        # 波源
        i0 = (hx[20,0,0] - hx[20,1,0]) * dx[20]\
           + (hy[20,1,0] - hy[19,1,0]) * dy[1]
        ez[20,1,0] = (self.waveform(yee.time[1],tau0) + 50. * i0) / dz[0]
        # 終端抵抗
        i1 = (hx[20,0,-1] - hx[20,1,-1]) * dx[20]\
           + (hy[20,1,-1] - hy[19,1,-1]) * dy[1]
        ez[20,1,-1] = 50. * i1 / dz[-1]
    def waveform(self,tau,tau0):
        alpha = (4 / tau0) ** 2
        p = 10 * (tau - tau0) / tau0 * numpy.exp(-alpha * (tau - tau0) ** 2)
        print p
        return p

#class CubicSin(pylaf.recipes.fdtd.Plugin):
#    def __call__(self):
#        yee = self.dataset.get()
#        frq0 = 1. # [GHz]
#        omg0 = 2 * numpy.pi * frq0 # 正弦波源の角周波数
#        tau0 = .5 / frq0 # パルス持続半周期
#        dx, dy, dz = yee.axes
#        ex, ey, ez = yee.e
#        hx, hy, hz = yee.h
#        if yee.time[1] > 2. * tau0:
#            v = 0.
#        else:
#            v = self.waveform(yee.time[1],omg0)
#            #ez[20,40,40] = v / dz[40]
#            #ey[:,1:-1,10] = v / dy[1:-1]
#        ey[20,28:-27,20] = 0.
#        ey[20,40,20] = - v / dy[40]
#        #ey[20,30: 40,40] = 0.
#        #ey[20,41:-29,40] = 0.
##        # 波源
##        i0 = (hx[20,0,0] - hx[20,1,0]) * dx[20]\
##           + (hy[20,1,0] - hy[19,1,0]) * dy[1]
##        ez[20,1,0] = (v + 50. * i0) / dz[0]
##        # 終端抵抗
##        i1 = (hx[20,0,-1] - hx[20,1,-1]) * dx[20]\
##           + (hy[20,1,-1] - hy[19,1,-1]) * dy[1]
##        ez[20,1,-1] = 50. * i1 / dz[-1]
#    def waveform(self,tau,omg0):
#        return numpy.sin(omg0 * tau) ** 3

class IProbe(pylaf.recipes.fdtd.Plugin):
    def __init__(self,elements=[('y',20,40,20)],**kw):
        pylaf.recipes.fdtd.Plugin.__init__(self,**kw)
        self.index     = pylaf.Port([(i,j,k) for d,i,j,k in elements])
        self.direction = pylaf.Port([d for d,i,j,k in elements])
        self.i         = pylaf.Port([0. for i in range(len(elements))])
    def __call__(self):
        yee = self.dataset.get()
        dx, dy, dz = yee.axes
        hx, hy, hz = yee.h
        current = [yee.time[0],]
        for n,z in enumerate(zip(self.direction.get(),self.index.get())):
            i,j,k = z[1]
            if   z[0] == 'x':
                c = (hz[i,j,k] - hz[i,j-1,k]) * .5 * (dz[k] + dz[k-1])\
                  + (hy[i,j,k-1] - hy[i,j,k]) * .5 * (dy[j] + dy[j-1])
            elif z[0] == 'y':
                c = (hx[i,j,k] - hx[i,j,k-1]) * .5 * (dx[i] + dx[i-1])\
                  + (hz[i-1,j,k] - hz[i,j,k]) * .5 * (dz[k] + dz[k-1])
            else:
                c = (hy[i,j,k] - hy[i-1,j,k]) * .5 * (dy[j] + dy[j-1])\
                  + (hx[i,j-1,k] - hx[i,j,k]) * .5 * (dx[i] + dx[i-1])
            current.append(c)
        self.i.set(current)
        
class Admittance(pylaf.Component):
    class Plot(pylaf.Panel):
        def __init__(self,master=None,cnf={},**kw):
            pylaf.Panel.__init__(self,master,cnf,**kw)
            pylaf.Embed(self,pylaf.BasePlot,name='v',text='v').pack(side=Tkinter.LEFT)
            pylaf.Embed(self,pylaf.BasePlot,name='ix',text='ix').pack(side=Tkinter.LEFT)
            pylaf.Embed(self,pylaf.BasePlot,name='yr',text='yr').pack(side=Tkinter.LEFT)
            pylaf.Embed(self,pylaf.BasePlot,name='yi',text='yi').pack(side=Tkinter.LEFT)
            pylaf.thread.Polling(self,interval=1000,name='polling').start() #@UndefinedVariable
            self.port('polling').bind(self._polling)
            self.y = pylaf.Port(numpy.array([]))
        def _polling(self):
            self.component().update()
            self.plot_y()
            pylaf.Panel.update_idletasks(self)
        def assign(self,component):
            pylaf.Panel.assign(self,component)
            component.to_v.link(self.console('v').component().sigin)
            component.to_ix.link(self.console('ix').component().sigin)
            component.y.link(self.y)
        def plot_y(self):
            try: del self.component().updated_y
            except: return
            y = self.y.get()
            if y.shape == (0,):
                self.console('yr').component().sigin.set(array([]))
                self.console('yi').component().sigin.set(array([]))
                return
            freq, y = numpy.real(y[:,0]), y[:,1:]
            self.console('yr').component().sigin.set(freq, numpy.real(y))
            self.console('yi').component().sigin.set(freq, numpy.imag(y))
    class Control(pylaf.Panel):
        def __init__(self,master=None,cnf={},**kw):
            pylaf.Panel.__init__(self,master,cnf,**kw)
            s = {'sticky' : Tkinter.W+Tkinter.E}
            b, l, e = pylaf.TableBuilder(self,column=3), Tkinter.Label, pylaf.Entry
            b.add(l,text='Port').grid(**s).add(e,name='pno').grid(columnspan=2,**s)
            b.add(l,text='Freq').grid(**s).add(e,name='freq').grid(columnspan=2,**s)
            b.add(l,text='Y').grid(**s).add(e,name='yr').grid(**s).add(e,name='yi').grid(**s)
            b.add(l,text='Time').grid(**s).add(e,name='time').grid(columnspan=2,**s)
            b.add(l,text='VI').grid(**s).add(e,name='viv').grid(**s).add(e,name='vii').grid(**s)
            for k,v in [('pno',1),('freq',2.45),('time',0.)]: self.port(k).set(v)
            self.port('pno').bind(self.interpolate_y)
            self.port('freq').bind(self.interpolate_y)
            self.port('time').bind(self.interpolate_y)
        def interpolate_y(self):
            port = self.port('pno').get()
            freq, time = self.port('freq').get(), self.port('time').get()
            #
            yo = self.component().y.get()
            try:
                fo, yo = numpy.real(yo[:,0]), yo[:,1:]
            except IndexError: pass
            else:
                try:
                    self.port('yr').set(interp1d(fo,numpy.real(yo[:,port - 1]),kind='linear')(freq))
                    self.port('yi').set(interp1d(fo,numpy.imag(yo[:,port - 1]),kind='linear')(freq))
                except ValueError: pass
                except IndexError: pass
            #
            buf = numpy.array(self.component().vbuf)
            try:
                to, vo = buf[:,0], buf[:,1]
            except IndexError: pass
            else:
                try:
                    self.port('viv').set(interp1d(to,vo,kind='cubic')(time))
                except ValueError: pass
                except IndexError: pass
            buf = numpy.array(self.component().ibuf)
            try:
                to, io = buf[:,0], buf[:,1:]
            except IndexError: pass
            else:
                try:
                    self.port('vii').set(interp1d(to,io[:,port - 1],kind='cubic')(time))
                except ValueError: pass
                except IndexError: pass
    class Menu(pylaf.DefaultMenu):
        kw = lambda **kw: kw
        ITEMS = [
                 ['Edit',
                  ['add_command', pylaf.kw(label='Copy i',command='_copy_i')],
                  ['add_command', pylaf.kw(label='Copy v',command='_copy_v')],
                  ['add_command', pylaf.kw(label='Copy y',command='_copy_y')],
                  ['add_separator', {}],
                  ['add_command', pylaf.kw(label='Clear',command='_clear')],
                  ]
                 ]
        def _copy_i(self): self._copy(self.component().ibuf)
        def _copy_v(self): self._copy(self.component().vbuf)
        def _copy(self,buffer):
            text = Tkinter.Text(self)
            text.clipboard_clear()
            for record in buffer:
                for i, value in enumerate(record):
                    text.clipboard_append('%16.14f' % value)
                    if not i == len(record) - 1: text.clipboard_append(' ')
                text.clipboard_append('\n')
            text.destroy()
        def _copy_y(self):
            text = Tkinter.Text(self)
            text.clipboard_clear()
            buffer = self.component().y.get()
            for record in buffer:
                text.clipboard_append('%16.14f ' % numpy.real(record[0])) # Frequency [GHz]
                for i, value in enumerate(record[1:]):
                    text.clipboard_append('%16.14f %16.14f' % (numpy.real(value), numpy.imag(value)))
                    if not i == len(record[1:]) - 1: text.clipboard_append(' ')
                text.clipboard_append('\n')
            text.destroy()
        def _clear(self):
            self.component().ibuf = []
            self.component().vbuf = []
            self.component().update_v()
            self.component().update_i()
            self.component().update_y()
    def __init__(self,master=None,name=None):
        pylaf.Component.__init__(self,master,name)
        self.v     = pylaf.Port([]).bind(self._v)
        self.i     = pylaf.Port([]).bind(self._i)
        self.to_v  = pylaf.Port(numpy.array([]))
        self.to_ix = pylaf.Port(numpy.array([]))
        self.y     = pylaf.Port(numpy.array([]))
        self.ibuf  = []
        self.vbuf  = []
    def _v(self):
        c = self.v.get()
        self.vbuf.append(c)
        self.updated_v = True
    def _i(self):
        c = self.i.get()
        self.ibuf.append(c)
        self.updated_i = True
    def update(self):
        try: del self.updated_v
        except: return
        try: del self.updated_i
        except: return
        self.update_v()
        self.update_i()
        self.update_y()
    def update_i(self):
        if len(self.ibuf) == 0:
            self.to_ix.set(array([]))
            return
        buf = numpy.array(self.ibuf)
        self.to_ix.set(buf[:,0],buf[:,1:])
    def update_v(self):
        if len(self.vbuf) == 0:
            self.to_v.set(array([]))
            return
        buf = numpy.array(self.vbuf)
        self.to_v.set(buf[:,0],buf[:,1:])
    def update_y(self):
        if len(self.vbuf) == 0 or len(self.ibuf) == 0:
            self.y.set(array([]))
            self.updated_y = True
            return
        vbuf = numpy.array(self.vbuf); v = vbuf[:,1:]
        ibuf = numpy.array(self.ibuf); i = ibuf[:,1:]
        t = vbuf[:,0]
        n = len(t)
        if n < 10: return
        i = .5 * (i[1:,:] + i[:-1,:])
        if   len(v) < i.shape[0]: i = i[:len(v),:]
        elif len(v) > i.shape[0]:
            v = v[:i.shape[0]]
            t = t[:i.shape[0]]
        try: y = numpy.fft.fft(i,axis=0) / numpy.fft.fft(v,axis=0)
        except: return
        m = int(n/2+.5)
        freq = numpy.fft.fftfreq(n,t[1]-t[0])[:m] # [GHz]
        data = numpy.zeros((m,i.shape[1]+1)).astype('complex128')
        data[:,0 ] = freq
        data[:,1:] = y[:m,:]
        self.y.set(data)
        self.updated_y = True

class Ymatrix2P(pylaf.Component):
    class Control(pylaf.Panel):
        def __init__(self,master=None,cnf={},**kw):
            pylaf.Panel.__init__(self,master,cnf,**kw)
            b, l, e = pylaf.TableBuilder(self), Tkinter.Label, pylaf.Entry
            b.add(l,text='Source').grid().add(e,name='source').grid()
    def __init__(self,master=None,name=None,elements=[('y',20,40,15),('y',20,40,25)]):
        pylaf.Component.__init__(self,master,name)
        self.source = pylaf.Port(1).bind(self.change_source)
        self.position = pylaf.Port(elements[0][1:])
        self.direction = pylaf.Port(elements[0][0])
        self.i   = pylaf.Port([]).bind(self.bypass_i)
        self.v   = pylaf.Port([]).bind(self.bypass_v)
        self.to_p1i = pylaf.Port([])
        self.to_p1v = pylaf.Port([])
        self.to_p2i = pylaf.Port([])
        self.to_p2v = pylaf.Port([])
        self.elements = elements[:]
    def change_source(self):
        e = self.elements
        s = self.source.get()
        dict = {1:0, 2:1}
        try: i = dict[s]
        except: return
        self.position.set(e[i][1:])
        self.direction.set(e[i][0])
    def bypass_v(self):
        i = self.source.get()
        if   i == 1: self.to_p1v.set(self.v.get())
        elif i == 2: self.to_p2v.set(self.v.get())
    def bypass_i(self):
        i = self.source.get()
        if   i == 1: self.to_p1i.set(self.i.get())
        elif i == 2: self.to_p2i.set(self.i.get())
        
class CubicSin(pylaf.recipes.fdtd.Plugin):
    def __init__(self,frequency=1.,position=(20,40,20),direction='y',**kw):
        pylaf.recipes.fdtd.Plugin.__init__(self,**kw)
        self.frequency = pylaf.Port(frequency)
        self.position  = pylaf.Port(position)
        self.direction = pylaf.Port(direction)
        self.v         = pylaf.Port([0., 0.])
        self.rin       = pylaf.Port(10000.)
    def config(self,**kw):
        pylaf.recipes.fdtd.Plugin.config(self,**kw)
        if kw.has_key('frequency'): self.frequency.set(kw['frequency'])
        if kw.has_key('position') : self.position.set(kw['position'])
        if kw.has_key('direction'): self.direction.set(kw['direction'])
    def __call__(self):
        yee = self.dataset.get()
        frq0 = self.frequency.get() # [GHz]
        omg0 = 2 * numpy.pi * frq0 # 正弦波源の角周波数
        tau0 = .5 / frq0 # パルス持続半周期
        time = yee.time[1]
        if time > 2. * tau0:
            v = 0.
        else:
            v = self.waveform(time,omg0)
        v = v - self.rin.get() * self.current() * yee.dt.get()
        dx, dy, dz = yee.axes
        ex, ey, ez = yee.e
        ix, iy, iz = self.position.get()
        direction  = self.direction.get()
        if   direction == 'x':
            ex[ix,iy,iz] = - v / dx[ix]
        elif direction == 'y':
            ey[ix,iy,iz] = - v / dy[iy]
        else:
            ez[ix,iy,iz] = - v / dz[iz]
        self.v.set([time, v])
    def current(self):
        i, j, k = self.position.get()
        direction = self.direction.get()
        yee = self.dataset.get()
        dx, dy, dz = yee.axes
        hx, hy, hz = yee.h
        if   direction == 'x':
            c = ((hz[i,j,k] - hz[i,j-1,k]) * .5 * (dz[k] + dz[k-1]) +
                 (hy[i,j,k-1] - hy[i,j,k]) * .5 * (dy[j] + dy[j-1]))
        elif direction == 'y':
            c = ((hx[i,j,k] - hx[i,j,k-1]) * .5 * (dx[i] + dx[i-1]) +
                 (hz[i-1,j,k] - hz[i,j,k]) * .5 * (dz[k] + dz[k-1]))
        else:
            c = ((hy[i,j,k] - hy[i-1,j,k]) * .5 * (dy[j] + dy[j-1]) +
                 (hx[i,j-1,k] - hx[i,j,k]) * .5 * (dx[i] + dx[i-1]))
        return c
    def waveform(self,tau,omg0):
        return numpy.sin(omg0 * tau) ** 3

class Sin(pylaf.recipes.fdtd.Plugin):
    def __init__(self,frequency=1.,position=(20,40,20),direction='y',**kw):
        pylaf.recipes.fdtd.Plugin.__init__(self,**kw)
        self.frequency = pylaf.Port(frequency)
        self.position  = pylaf.Port(position)
        self.direction = pylaf.Port(direction)
        self.v         = pylaf.Port([0., 0.])
        self.rin       = pylaf.Port(10000.)
    def config(self,**kw):
        pylaf.recipes.fdtd.Plugin.config(self,**kw)
        if kw.has_key('frequency'): self.frequency.set(kw['frequency'])
        if kw.has_key('position') : self.position.set(kw['position'])
        if kw.has_key('direction'): self.direction.set(kw['direction'])
    def __call__(self):
        yee = self.dataset.get()
        frq0 = self.frequency.get() # [GHz]
        omg0 = 2 * numpy.pi * frq0 # 正弦波源の角周波数
        tau0 = .5 / frq0 # パルス持続半周期
        time = yee.time[1]
#        if time > 2. * tau0:
#            v = 0.
#        else:
#            v = self.waveform(time,omg0)
        v = self.waveform(time,omg0)
        v = v - self.rin.get() * self.current() * yee.dt.get()
        dx, dy, dz = yee.axes
        ex, ey, ez = yee.e
        ix, iy, iz = self.position.get()
        direction  = self.direction.get()
        if   direction == 'x':
            ex[ix,iy,iz] = - v / dx[ix]
        elif direction == 'y':
            ey[ix,iy,iz] = - v / dy[iy]
        else:
            ez[ix,iy,iz] = - v / dz[iz]
        self.v.set([time, v])
    def current(self):
        i, j, k = self.position.get()
        direction = self.direction.get()
        yee = self.dataset.get()
        dx, dy, dz = yee.axes
        hx, hy, hz = yee.h
        if   direction == 'x':
            c = ((hz[i,j,k] - hz[i,j-1,k]) * .5 * (dz[k] + dz[k-1]) +
                 (hy[i,j,k-1] - hy[i,j,k]) * .5 * (dy[j] + dy[j-1]))
        elif direction == 'y':
            c = ((hx[i,j,k] - hx[i,j,k-1]) * .5 * (dx[i] + dx[i-1]) +
                 (hz[i-1,j,k] - hz[i,j,k]) * .5 * (dz[k] + dz[k-1]))
        else:
            c = ((hy[i,j,k] - hy[i-1,j,k]) * .5 * (dy[j] + dy[j-1]) +
                 (hx[i,j-1,k] - hx[i,j,k]) * .5 * (dx[i] + dx[i-1]))
        return c
    def waveform(self,tau,omg0):
        return numpy.sin(omg0 * tau)

class Dielectric(pylaf.recipes.fdtd.Plugin):
    def __call__(self):
        yee = self.dataset.get()
        yee.epr[:,0,:] = 2.17
        
class Metal(pylaf.recipes.fdtd.Plugin):
    def __call__(self):
        yee = self.dataset.get()
        ex, ey, ez = yee.e
        hx, hy, hz = yee.h
        #
        ey[20,28:-27,20] = 0.
        
class ImpedanceDY(pylaf.recipes.fdtd.Plugin):
    def __init__(self,**kw):
        self.i = pylaf.Port(0.)
        self.v = pylaf.Port(0.)
        self.iold = 0.
        pylaf.recipes.fdtd.Plugin.__init__(self,**kw)
    def __call__(self):
        yee = self.dataset.get()
        i, j, k = 20, 40, 20
        dx, dy, dz = yee.axes
        ex, ey, ez = yee.e
        hx, hy, hz = yee.h
        iy  = (hx[i,j,k] - hx[i,j,k-1]) * dx[i] + (hz[i-1,j,k] - hz[i,j,k]) * dz[k]
        self.i.set(.5 * (self.iold + iy))
        self.v.set(- ey[i,j,k] * dy[j])
        self.iold = iy
        
class UpdatingTime(pylaf.recipes.fdtd.Plugin):
    def __init__(self,**kw):
        self.counter = pylaf.Port(None)
        self.offset  = pylaf.Port(0.)
        pylaf.recipes.fdtd.Plugin.__init__(self,**kw)
    def config(self,**kw):
        pylaf.recipes.fdtd.Plugin.config(self,**kw)
        if kw.has_key('counter'): kw['counter'].link(self.counter)
        if kw.has_key('offset') : self.offset.set(kw['offset'])
    def __call__(self):
        dataset = self.dataset.get()
        dt      = dataset.dt.get()
        if self.offset.get() == 0.:
            dataset.time[1] = dt * (self.counter.get() + self.offset.get())
        else:
            dataset.time[0] = dt * (self.counter.get() + self.offset.get())
        
class UpdatingEField(pylaf.recipes.fdtd.Plugin):
    def config(self,**kw):
        pylaf.recipes.fdtd.Plugin.config(self,**kw)
        if kw.has_key('solver'): self.solver = kw['solver']
    def __call__(self):
        dataset = self.dataset.get()
        self.solver.calcex(dataset)
        self.solver.calcey(dataset)
        self.solver.calcez(dataset)
        
class UpdatingPML(pylaf.recipes.fdtd.Plugin):
    def config(self,**kw):
        pylaf.recipes.fdtd.Plugin.config(self,**kw)
        if kw.has_key('solver'): self.solver = kw['solver']
        if kw.has_key('clear'):
            self.clear = pylaf.Port(None).bind(self._clear)
            kw['clear'].link(self.clear)
    def _clear(self): self.solver.clear()
class UpdatingPMLE(UpdatingPML):
    def __call__(self): self.solver.calce(self.dataset.get())
class UpdatingPMLH(UpdatingPML):
    def __call__(self): self.solver.calch(self.dataset.get())

class UpdatingHField(pylaf.recipes.fdtd.Plugin):
    def config(self,**kw):
        pylaf.recipes.fdtd.Plugin.config(self,**kw)
        if kw.has_key('solver'): self.solver = kw['solver']
    def __call__(self):
        dataset = self.dataset.get()
        self.solver.calchx(dataset)
        self.solver.calchy(dataset)
        self.solver.calchz(dataset)
        
if __name__ == '__main__':
    from pylaf import Console
#    from pylaf.vtkext import VtkView, OutlineActor, RayCastVolume, HedgeHog
#    from pylaf.recipes.fdtd import StructuredYee, YeeUIntScalarStructuredPoints, YeeEStructuredPoints
    from pylaf.recipes.fdtd import Fdtd, UpdatingTime#, UpdatingEField, UpdatingHField
    from solvers.rlsolver import RectilinearYee, RectilinearFDTD, RectilinearPML
    import pylaf.recipes.fdtd
    #import pylaf.vtkext
    
    tk = Tkinter.Tk()
    fdtd = Console(tk,Fdtd()).component()
    dataset = RectilinearYee(shape=(40,80,40),dt=.010) # [ns]
    dx, dy, dz = dataset.axes
    dx[:] = dx * 6   # mm
    dy[:] = dy * 6   # mm
    dz[:] = dz * 6   # mm
    fdtd.config(dataset=dataset)
    fdtd.maxiter.set(2400)
    #print fdtd.yee.get().calc_courant()
    initialize   = fdtd.initialize # 初期化マネージャの取得
    sequence     = fdtd.sequence   # シーケンスマネージャの取得
    yee, counter = fdtd.yee, fdtd.counter # 各種ポートの取得
    solver       = RectilinearFDTD()
    pml          = RectilinearPML(yee)
    # 初期化シーケンスの登録
    #initialize.append(Dielectric(dataset=yee))
    # プロセスシーケンスの登録
    sequence.append(UpdatingETime(dataset=yee,counter=counter))
    sequence.append(UpdatingEField(dataset=yee,solver=solver))
    sequence.append(UpdatingPMLE(dataset=yee,solver=pml))
    sequence.append(Metal(dataset=yee))
    sequence.append(CubicSin(dataset=yee))
    #sequence.append(Source(dataset=yee))
    sequence.append(UpdatingHTime(dataset=yee,counter=counter))
    sequence.append(UpdatingHField(dataset=yee,solver=solver))
    sequence.append(UpdatingPMLH(dataset=yee,solver=pml))
    probe = ImpedanceDY(dataset=yee)
    sequence.append(probe)
    #
    view = Console(Tkinter.Toplevel(tk),YeeViewer()); _view = view.component()
    #
#    timer = Polling(tk,interval=1000)
    timer = Polling(tk,interval=2000)
    fdtd.yee.link(timer.sigin)
    timer.sigout.link(_view.sigin)
    #
    #vtkview = Console(Tkinter.Toplevel(tk),pylaf.vtkext.VtkView(),pylaf.StandardH); _vtkview = vtkview.component()
    #vtkview.panel('plot').AddPort('yee')
    #timer.sigout.link(vtkview.panel('plot').yee)
    #
    #ssp = YeeUIntScalarStructuredPoints(Range=(.0,.02))
    #ssp = YeeUIntScalarStructuredPoints(Range=(.0,1.))
    #vtkview.panel('plot').RenderWidget().AddDataSet(ssp)
    #vtkview.panel('plot').yee.link(ssp.sigin)
    #
    #vtkview.panel('plot').RenderWidget().AddActor(pylaf.vtkext.OutlineActor(Color=(0,0,0),Input=ssp))
    #vtkview.panel('plot').RenderWidget().AddVolume(pylaf.vtkext.RayCastVolume(Input=ssp,Alpha=0.1))
    #
    frm = Tkinter.Frame(Tkinter.Toplevel(tk)); frm.pack()
    logger  = pylaf.Embed(frm,Logger ,pylaf.Standard,text='Logger');  logger.assign( Logger());  logger.pack(side=Tkinter.TOP,anchor=Tkinter.E,fill=Tkinter.X)
    adapter = pylaf.Embed(frm,Adapter,pylaf.Standard,text='Adapter'); adapter.assign(Adapter(dataset=yee)); adapter.pack(side=Tkinter.TOP,anchor=Tkinter.E,fill=Tkinter.X)
    viewer  = pylaf.Embed(frm,ImpedanceView,pylaf.Standard,text='Impedance'); viewer.assign(ImpedanceView()); viewer.pack(side=Tkinter.TOP,anchor=Tkinter.E,fill=Tkinter.X)
    adapter.component().from_probe_i.link(probe.i)
    adapter.component().from_probe_v.link(probe.v)
    adapter.component().to_logger.link(logger.component().value)
    adapter.component().from_logger.link(logger.component().storage)
    adapter.component().to_viewer.link(viewer.component().sigin)
#    yesp = YeeEStructuredPoints()
#    vtkview.panel('plot').RenderWidget().AddDataSet(yesp)
#    vtkview.panel('plot').yee.link(yesp.sigin)
#    #
#    vtkview.panel('plot').RenderWidget().AddActor(HedgeHog(ScaleFactor=10,Input=yesp))
#    #
    timer.start()
    Tkinter.mainloop()