# coding: utf-8

import utils.weakvaluelist as weakvaluelist
import weakref, inspect, warnings

# class ConcreteTerminal(object)

# TRACE = True
try: TRACE #@UndefinedVariable
except NameError: TRACE=False

class _PortException(Exception):
    def __init__(self, value):
        self.value = value
    def __str__(self):
        return repr(self.value)

class RulePortSetError(_PortException): pass

class RuleRecursiveCall(Exception): pass

class Node:
    '''監視対象。いずれからも監視されなくなったら自動的に削除される。メンバ変数による参照禁止'''
    def __init__(self,value):
        self.value = value
        self.getlog = weakref.WeakKeyDictionary() # この node に依存するを get 参照した Rule Terminal の attr を記録
        self.observers = weakvaluelist.WeakValueList() # オブザーバへの逆参照を格納する弱参照リスト（循環参照を防止するために逆参照を用いた）
    def register(self,observer):
        if not self.observers.count(observer): # もし、observerに対する弱参照を保持していなければ
            self.observers.append(observer) # オブザーバの弱参照をリストに保持
    def unregister(self,observer):
        self.observers.cleanup() # 削除したオブジェクトをコールしないよう空になった弱参照をクリア
        self.observers.remove(observer) # 与えられたobserverに対する弱参照をリストから削除
    def notify(self,event,ignore={}):
        '''監視者へ変更を通知する。observer.update(event)を起動する。起動の順番は登録順。'''
        ''' ！！！【変更予定】Ruleを優先しないとだめ！！！'''
        self.observers.cleanup() # 削除したオブジェクトをコールしないよう空になった弱参照をクリア
        for o in self.observers.tolist():
            #if TRACE:
            #    if o in ignore:
            #        print 'ignored %s set event' % o.term.name
            #if not o in ignore: o.notify(event) # オブザーバひとつひとつのupdate()をobserversの順番に起動
            o.notify(event)
    def get_observers(self):
        self.observers.cleanup()
        return self.observers.tolist()
    @property
    def observers_(self):
        self.observers.cleanup()
        return self.observers.tolist()
    @property
    def rule(self):
        for attr in self.observers_:
            if attr:
                if isinstance(attr.term,Rule):
                    return attr
        return
        
class Attribute(object):
    def __init__(self,owner,terminal,value):
        self.owner    = weakref.ref(owner)
        self.terminal = weakref.ref(terminal)
        self.ignore   = weakref.WeakKeyDictionary()
        self.node     = None
        self.evaluating_rule = []
        self.register(Node(value))
    def register(self,node):
        self.unregister() # 監視を解除
        node.register(self) # 監視していることを通知
        self.node = node # 監視対象を保持するために参照を保持する
    def unregister(self):
        if not self.node == None: # すでになにかを監視しているならば
            self.node.unregister(self) # 監視をやめることを通知
            self.node = None # 監視対象を保持するための参照を削除
    def notify(self,event):
        self.terminal().notify(self,event)
    @property
    def term(self): return self.terminal()
        
# Generator ?
class Terminal(object):
    '''
    クラス宣言時に decorator によって生成される、インスタンス属性へのアクセッサ
    '''
    def __init__(self,init_value=None):
        self.init_value = init_value
        self.name = None # 最初にset/get/linkが呼び出されたときにオーナーを検索して取得
        self.from_rule = None
    def __get__(self, owner, ownertype):
        if owner == None: return self
        attr = self.get_attribute(owner)
        #
        # set イベント処理中には get 参照されてもイベントは発行せずに set された内容を返す
        #
        try: getattr(attr,'__set_event')
        except AttributeError:
            pass
        else:
            if TRACE: print '= get = %s.%s without notification' % (owner.__class__.__name__,self.name)
            return attr.node.value
#            attr.node.getlog[attr] = None # get 参照したことを対象の node.getlog へ記録
        if TRACE: print '= get = %s.%s' % (owner.__class__.__name__,self.name)
        attr.node.notify('get')
        return attr.node.value
    def __set__(self, owner, value):
        node = self.get_attribute(owner).node
        node.value = value
        node.getlog.clear() # node を変更したので node.getlog を消去
        if TRACE: print '= set = %s.%s' % (owner.__class__.__name__,self.name)
        node.notify('set')
    def notify(self, attr, event):
        if event == 'get':
            if attr.evaluating_rule: attr.node.getlog[attr.evaluating_rule[-1]] = None # getlog に実行中のルールを記録する
            return
        if not event == 'set': return
        setattr(attr,'__set_event',True)
        if TRACE: print '- set -> %s.%s' % (attr.owner().__class__.__name__,self.name)
        if TRACE: print 'start blocking notification for', attr.term.name
        owner = attr.owner()
        #
        # 依存関係のある rule を起動
        #
        for rule_name, v in terminals(owner).iteritems():
            if isinstance(v,Rule) and v.mode == 'interactive': # ルールが見つかったら
                if TRACE: print 'Rule found: %s.%s' % (owner.__class__.__name__,rule_name)#,
                #if TRACE: print 'evaluating with', [o.term.name for o in attr.evaluating_rule]
                rule_attr = v.get_attribute(owner)
                if rule_attr.evaluating_rule:
                    if rule_attr.evaluating_rule[-1] == rule_attr:
                        if TRACE: print 'This rule is evaluating now'
                        continue
                term = rule_attr.terminal()
                for name in term.dependency: # 未更新の Terminal がひとつもなければルールを実行する
                    if name == self.name: # １つでも自身に依存していたらルールを実行可能か評価する
                        if TRACE: print '%s.%s checks' % (owner.__class__.__name__,rule_name),
                        for myname in term.dependency: # 未更新の依存 Terminal がひとつでも見つかればルールを実行しない
                            if TRACE: print '[%s]' % myname,
                            if rule_attr in terminal(owner,myname).get_attribute(owner).node.getlog:
                                if TRACE: print 'not modified'
                                break # ログに attr が見つかれば未更新
                        else: # break で脱出しなかった場合
                            if not len(rule_attr.terminal().dependency) == 0:
                                if TRACE: print '\n%s.%s - get -> %s.%s' % (rule_attr.owner().__class__.__name__,self.name,rule_attr.owner().__class__.__name__,rule_name)
                                term.notify(rule_attr,'get') # かつ依存関係が空()でない場合にはルールを実行する
#                if TRACE: print '\n%s.%s - get ->' % (attr.owner().__class__.__name__,self.name)
#                term.notify(attr,'get')
        try: delattr(attr,'__set_event')
        except AttributeError: pass
        if TRACE: print 'end blocking notification for', attr.term.name
    def get_name(self, owner): # オーナーインスタンスからの参照名を取得する
        if self.name == None: # オーナーインスタンスが生成されてから最初に参照されたときには名称探索をする
            # 呼び出しのコンテキストから、オーナーインスタンスにオブジェクトが存在することが保証されているので（はずなので）チェック省略
            for name, v in terminals(owner).iteritems(): # オーナークラスのメンバ全体について
                if v == self:
                    self.name = name
                    return name # 自身と一致するインスタンスの名称を返す
        else:
            return self.name
    def get_terminals(self,owner):
        '''
        オーナが保持するすべてのターミナルのリストを取得する
        '''
        terminals = {}
        for cls in inspect.getmro(owner.__class__):
            for k in cls.__dict__:
                v = cls.__dict__[k]
                if isinstance(v,Terminal):
                    if not k in terminals: terminals[k] = v
        return terminals
    def new_attributes(self,owner):
        '''
        オーナーに属するすべてのターミナルの属性を生成する
        '''
        terminals = self.get_terminals(owner)
        for name, terminal in terminals.iteritems():
            owner.__dict__[name] = Attribute(owner,terminal,terminal.init_value)
    def init_getlog(self,owner):
        #
        # オーナーに属するすべてのターミナルに関連する getlog を初期化する
        # ルールはそれ自身については更新済み、依存ターミナルについては未更新とする
        # ルール以外については、自身のターミナルについて未更新とする
        #
        terminals = self.get_terminals(owner)
        for name, terminal in terminals.iteritems(): # すべての Terminal 一族について
            attr = owner.__dict__[name]
            if isinstance(terminal,Rule): # ルールにつて
                for myname in terminal.dependency:
                    owner.__dict__[myname].node.getlog[attr] = None
    def get_attribute(self,owner):
        #
        # オーナーインスタンスから属性を取得する
        #
        name = self.get_name(owner)
        #
        # 属性の生成
        #
        if not name in owner.__dict__: # まだオーナーに当該属性が生成されていなければすべての属性を生成する
            self.new_attributes(owner)
        return owner.__dict__[name] # 属性を返す
    attr = get_attribute
    
class Share(Terminal): pass
    
class Rule(Terminal):
    def __init__(self,*dependency,**kw):
        if 'init' in kw: init = kw['init']
        else: init = None
        Terminal.__init__(self,init_value=init)
        if 'rule' in kw: self.rule = kw['rule']
        if 'mode' in kw: self.mode = kw['mode']
        else: self.mode = 'interactive'
        self.dependency = dependency
    def __set__(self, owner, value):
        raise RulePortSetError("cannot set() a rule cell")
    def notify(self,attr,event):
        if not event == 'get': return
        if attr.evaluating_rule: attr.node.getlog[attr.evaluating_rule[-1]] = None # getlog に実行中のルールを記録する
        try: self.rule
        except: return # undefined rule error!!
        if TRACE: print '- get -> %s.%s' % (attr.owner().__class__.__name__,self.name)
        #
        # Event からの循環参照を検出したら脱出する
        #
        for o in attr.node.get_observers():
            if isinstance(o,Event):
                if attr == o.from_rule:
                    return
        # 
        # 循環参照を検出したら検出フラグをたてて脱出する
        #
        try: attr.passed # block recursive access
        except AttributeError: pass
        else:
            setattr(attr,'detected',True)
            return
        #
        # ひとつでも更新されている Terminal があればルールを実行する
        #
        #print '%s.%s' % (attr.owner().__class__.__classname__,attr.terminal())
        if not self.require_update(attr): return
        owner = attr.owner()
#        for name in self.dependency: # 依存関係のある Terminal がひとつでも更新されていれば else 節を実行してなにもせず脱出
#            myattr = terminal(owner,name).get_attribute(owner)
#            if TRACE: print '[%s]' % name,
#            if not attr in myattr.node.getlog:
#                if TRACE: print 'modified'
#                break
#        else: # 依存関係のある Terminal がひとつも更新されていなかった場合（break で脱出しなかった場合）
#            if not len(self.dependency) == 0:
#                return # 依存関係が()の場合にも else 節が実行されてしまう例外処理
        #
        # ルールの実行に先立って自身に影響を与えるターミナルへ get を通知し（リンクを遡り） getlog を更新する
        #
#        setattr(attr,'passed',True) # block recursive access
#        for name in self.dependency:
#            dependent = terminal(owner,name).attr(owner)
#            if dependent.node.rule: dependent.node.rule.ignore[dependent] = None # 影響ターミナルに関連するルールからの逆流ブロックマーカをつける
            #for o in dependent.node.get_observers():
            #    if isinstance(o.terminal(),Rule):
            #        o.ignore[dependent] = None # 影響ターミナルに関連するルールからの逆流ブロックマーカをつける
            #getattr(owner,name) # 依存ターミナルを参照してルール起動を試みる
            #for o in dependent.node.get_observers():
            #    try:
            #        o.detected
            #    except AttributeError:
            #        pass
            #    else:
            #        delattr(o,'detected')
            #dependent.node.getlog[attr] = None
#        delattr(attr,'passed')
        #
        # Event 内で自身を参照したときに無限循環してしまう不具合への対処
        #
        for o in attr.node.get_observers():
            if isinstance(o.terminal(),Event):
                o.from_rule = attr
        #
        # ルールの実行
        #
        if TRACE: print 'exec %s.%s.rule' % (attr.owner().__class__.__name__,self.name)
        for name in self.dependency: terminal(owner,name).attr(owner).evaluating_rule.append(attr) # LILO にプッシュする
        attr.evaluating_rule.append(attr)
        attr.node.value = self.rule(owner) # rule を実行してその結果を node に保存する
        attr.evaluating_rule = attr.evaluating_rule[:-1]
        for name in self.dependency: terminal(owner,name).attr(owner).evaluating_rule = terminal(owner,name).attr(owner).evaluating_rule[:-1] # LILO からポップする
        if TRACE: print 'fin %s.%s.rule' % (attr.owner().__class__.__name__,self.name)
        attr.node.getlog.clear() # node を変更したので node.getlog を消去
        if TRACE: print '%s.%s - set ->' % (attr.owner().__class__.__name__,self.name),
        if TRACE: print 'ignore with', [k.term.name for k,v in attr.ignore.iteritems()]
        attr.node.notify('set',ignore=attr.ignore)
        attr.ignore.clear()
        #
        # 依存関係のあるカスケード接続ルールを起動（ルール中で自分を参照されたときは Event と同じように処理する）
        #
        influenced_rule = self.search_influenced_rule(owner)
        for term in influenced_rule:
            if TRACE: print '[%s]' % term.name,
            self.try_rule(term,owner)
        #
        #
        #
    def search_influenced_rule(self,owner):
        result = []
        for name, v in terminals(owner).iteritems():
            if isinstance(v,Rule) and v.mode == 'interactive':
                term = v.get_attribute(owner).terminal()
                for name in term.dependency:
                    if name == self.name:
                        result.append(v)
                        break
        return result
    def try_rule(self,term,owner):
        attr = term.get_attribute(owner)
        for name in term.dependency:
            if attr in terminal(owner,name).get_attribute(owner).node.getlog:
                break
        else:
            if not len(term.dependency) == 0:
                if TRACE: print '\n%s.%s - get ->' % (attr.owner().__class__.__name__,self.name)
                #setattr(attr,'from_rule',True)
                term.notify(attr,'get')
                #delattr(attr,'from_rule')
                return True
        return
    def require_update(self,attr):
        owner = attr.owner()
        if len(self.dependency) == 0: return True # 依存関係が()の場合には常に要更新
        for name in self.dependency:
            dependent = terminal(owner,name).get_attribute(owner)
            if TRACE: print 'checking getlog for %s =' % name,[k.term.name for k,v in dependent.node.getlog.iteritems()]
            rule = dependent.node.rule # このルールに影響を与えるターミナルに関連付けられたルール
            if rule: # ルールが存在していれば
                if TRACE: print '%s.%s' % (owner.__class__.__name__,name), # 影響を与えるターミナル
                if TRACE: print '= %s' % rule.owner().__class__.__name__ # チェックされるルール
                required = rule.term.require_update(rule)
                if required:
                    if TRACE: print 'requires update at least'
                else:
                    if TRACE: print 'skips update'
                if required: # 依存関係のある Rule が要更新であれば自身も要更新
                    return True
            if not attr in dependent.node.getlog: # 依存関係のある Terminal がひとつでも更新されていれば要更新
                return True
        return False
        
class Event(Terminal):
    def __init__(self,value=None,*args,**kw):
        Terminal.__init__(self,value)
        if 'rule' in kw: self.rule = kw['rule']
    def notify(self, attr, event):
        #if event == 'get':
        #    if attr.evaluating_rule: attr.node.getlog[attr.evaluating_rule[-1]] = None # getlog に実行中のルールを記録する
        #    return
        if not event == 'set': return
        try: self.rule
        except: return # undefined rule error!!
        setattr(attr,'__set_event',True)
        if TRACE: print '- set to Event -> %s.%s' % (attr.owner().__class__.__name__,self.name)
        if TRACE: print 'exec %s.%s.rule' % (attr.owner().__class__.__name__,self.name)
        self.rule(attr.owner())
        if TRACE: print 'fin %s.%s.rule' % (attr.owner().__class__.__name__,self.name)
        try: delattr(attr,'__set_event')
        except AttributeError:
            pass
        Terminal.notify(self,attr,event)
        
def rule(*args,**kw):
    def _(func): return Rule(rule=func,*args,**kw)
    return _

def event(*args,**kw):
    def _(func): return Event(rule=func,*args,**kw)
    return _
    
def query_updated(owner,name): # 以前このターミナルから get して以降に、いずこかより本体 node が set により書き換えられたかどうか
    attr = terminal(owner,name).get_attribute(owner)
    return not attr in attr.node.getlog # getlog に記録されていれば書き換えられていない
    
def terminal(owner,name):
    result = None
    terms = terminals(owner)
    if name in terms: result = terms[name]
    return result
    
def terminals(owner):
    '''
    オーナが保持するすべてのターミナルのリストを取得する
    '''
    result = {}
    for cls in inspect.getmro(owner.__class__):
        for k in cls.__dict__:
            v = cls.__dict__[k]
            if isinstance(v,Terminal):
                if not k in result: result[k] = v
    return result

def connect(primary=(None,''),*args):
    #
    # ターミナルを接続する
    #
    primary_node = terminal(*primary).get_attribute(primary[0]).node # primary ターミナルに紐づけられた node を取得
    #
    # 1 node 1 rule の原則チェック
    #
    counter = 0
    for o in primary_node.get_observers():
        if isinstance(o.terminal(),Rule): counter += 1
    for owner,name in args:
        for o in terminal(owner,name).get_attribute(owner).node.get_observers():
            if isinstance(o.terminal(),Rule): counter += 1
    if counter > 1:
        warnings.warn('Node should be referred from Only One Rule Terminal',stacklevel=2)
        return
    #
    # 対象ターミナルの node に紐づけられたすべてのターミナルを primary_node に紐づけなおす
    #
    for owner,name in args:
        for o in terminal(owner,name).get_attribute(owner).node.get_observers():
            o.register(primary_node)
    for o in primary_node.get_observers():
        if o.terminal().__class__ == Event: o.notify('set')
            
_terminal = terminal

def disconnect(terminal=(None,'')):
    attr  = _terminal(*terminal).get_attribute(terminal[0])
    value = attr.node.value
    attr.unregister()
    attr.register(Node(value))
cut = disconnect

def insert(pos,head_tail):
    obj, head, tail = head_tail
    connect(pos,(obj,tail))
    disconnect(pos)
    connect(pos,(obj,head))
