# coding: utf-8
from term import Terminal, event, connect, rule
from tkext import Entry, Button, LatchedButton , MultipleEntries
from inst import Logic, Panel, Embed
from pylafii.utils.tk import TableBuilder
from numpy import array
import utils.mpl_tk
import Tkinter
import weakref

class BasePlot(Logic):
    value = Terminal()
    xlim = Terminal()
    ylim = Terminal()
    base_plot = Terminal()
    @rule('value')
    def result(self): return self.value
    @property
    def plot(self): return self.base_plot()
    class Plot(utils.mpl_tk.BasePlot,object):
        xlim = Terminal()
        ylim = Terminal()
        @event()
        def value(self):
            if self.value is None: return
            args,kw = utils.parse_port_args(self.value)
            self._plot(*args,**kw)
        def connect(self,logic):
            for name in ['xlim','ylim']: connect((self,name),(logic,name))
            for src,dest in [('value','result')]: connect((self,src),(logic,dest))
            logic.base_plot = weakref.ref(self)
        def __init__(self,master=None,figsize=(5,4),dpi=75,align=111,projection='rectilinear',cnf={},**kw):
            utils.mpl_tk.BasePlot.__init__(self,master,figsize,dpi,align,projection,cnf,**kw)
            self._update_xlim(None)
            self._update_ylim(None)
            self._connect()
        def _connect(self):
            #
            # プロット範囲更新イベントの設定
            #
            self._callbacks = cb = {}
            cb['cid_xlim']  = self.ax.callbacks.connect('xlim_changed',self._update_xlim)
            cb['cid_ylim']  = self.ax.callbacks.connect('ylim_changed',self._update_ylim)
        def _update_xlim(self,e): # ax の xlim が更新されたときに control の GUI を更新する
            self._update_xlim_called = True
            self.xlim = self.ax.get_xlim()
            del self._update_xlim_called
        def _update_ylim(self,e): # ax の xlim が更新されたときに control の GUI を更新する
            self._update_ylim_called = True
            self.ylim = self.ax.get_ylim()
            del self._update_ylim_called
        def _disconnect(self):
            self.ax.callbacks.disconnect(self._callbacks['cid_xlim'])
            self.ax.callbacks.disconnect(self._callbacks['cid_ylim'])
        def destroy(self):
            self._disconnect()
            utils.mpl_tk.BasePlot.destroy(self)
        def _plot(self,*args,**kwargs):
            self.clear()
            self.ax.plot(*args,**kwargs)
            self.canvas.show()
            self.update_idletasks() # スレッド処理でButtonに対応するにはupdate_idletasksを使う。updateではButtonがロックすることがある。
        def resize(self,dpi=None,figsize=None):
            if (dpi is None or figsize is None): return
            subplotpars = self.ax.figure.subplotpars
            left   = subplotpars.left
            right  = subplotpars.right
            bottom = subplotpars.bottom
            top    = subplotpars.top
            title  = self.ax.get_title()
            xlabel = self.ax.get_xlabel()
            ylabel = self.ax.get_ylabel()
            self._disconnect()
            utils.mpl_tk.BasePlot.resize(self,dpi=dpi,figsize=figsize)
            self._connect()
            self.ax.set_ylabel(ylabel)
            self.ax.set_xlabel(xlabel)
            self.ax.set_title(title)
            self.ax.figure.subplots_adjust(left = left, right = right, bottom = bottom, top = top)
            self.value = self.value
    class Control(Panel):
        base_plot = Terminal()
        @event([0.,1.])
        def xlim(self): self._changed_xlim()
        @event([0.,1.])
        def ylim(self): self._changed_ylim()
        @event(True)
        def autoscalex_on(self): self._changed_autoscalex()
        @event(True)
        def autoscaley_on(self): self._changed_autoscaley()
        def connect(self,logic):
            plot = logic.base_plot() # plot pane を先に connect しなければならない
            autoscalex_on = plot.ax.get_autoscalex_on() # xlim を connect すると変化してしまうのでボタンの状態をバックアップ
            autoscaley_on = plot.ax.get_autoscaley_on()
            for name in ['base_plot','xlim','ylim']: connect((logic,name),(self,name))
            self.autoscalex_on = autoscalex_on
            self.autoscaley_on = autoscaley_on
        def __init__(self,master=None,cnf={},**kw):
            Panel.__init__(self,master,cnf,**kw)
            #
            Tkinter.Label(self,text='X Axis').grid(row=1,column=0)
            MultipleEntries(self,column=2,name='xlim').grid(row=1,column=1)
            LatchedButton(self,text='auto',name='autoscalex_on',positive=False).grid(row=1,column=3)
            #
            Tkinter.Label(self,text='Y Axis').grid(row=2,column=0)
            MultipleEntries(self,column=2,name='ylim').grid(row=2,column=1)
            LatchedButton(self,text='auto',name='autoscaley_on',positive=False).grid(row=2,column=3)
            for name in ['xlim','ylim','autoscalex_on','autoscaley_on']:
                connect((self,name),(self.children[name],'value'))
        def _changed_xlim(self):
            '''
            xlim エントリーが変更されたらば、
            autoscalex を disable し、
            autoscalex ボタンを enable し、
            xlim を更新し、
            プロットを再描画する
            '''
            if self.base_plot is None: return # もしまだ PlotWidget が接続されていなければ無視する
            plot = self.base_plot()
            try: plot._update_xlim_called # plot 内部で使用しているコールバックが逆流しないように
            except AttributeError:
                plot.ax.set_xlim(*self.xlim) # xlim をアップデート
                self.autoscalex_on = plot.ax.get_autoscalex_on() # ボタンの状態をアップデート
                plot.canvas.show() # キャンバスを再表示
        def _changed_ylim(self):
            if self.base_plot is None: return
            plot = self.base_plot()
            try: plot._update_ylim_called
            except AttributeError:
                plot.ax.set_ylim(*self.ylim)
                self.autoscaley_on = plot.ax.get_autoscaley_on()
                plot.canvas.show()
        def _changed_autoscalex(self):
            '''
            autoscalexボタンを押したらば、
            autoscalexをenableし、
            autoscalexボタンをdisableし、
            再プロットする
            '''
            if self.base_plot is None: return
            plot = self.base_plot()
            plot.ax.set_autoscalex_on(self.autoscalex_on)
            BasePlot.Plot.value.rule(plot)
        def _changed_autoscaley(self):
            if self.base_plot is None: return
            plot = self.base_plot()
            plot.ax.set_autoscaley_on(self.autoscaley_on)
            BasePlot.Plot.value.rule(plot)
    class Config:
        class Decolation(Panel):
            base_plot = Terminal()
            LAYOUT = [
                      (Tkinter.Label,{'text':'PADL'}),(Entry,{'name':'padl'}),
                      (Tkinter.Label,{'text':'PADR'}),(Entry,{'name':'padr'}),
                      (Tkinter.Label,{'text':'PADB'}),(Entry,{'name':'padb'}),
                      (Tkinter.Label,{'text':'PADT'}),(Entry,{'name':'padt'}),
                      (Button,{'name':'reset_pad','text':'reset'},{'columnspan':2}),
                      (Tkinter.Label,{'text':'TITLE'}),(Entry,{'name':'title'}),
                      (Tkinter.Label,{'text':'XLABEL'}),(Entry,{'name':'xlabel'}),
                      (Tkinter.Label,{'text':'YLABEL'}),(Entry,{'name':'ylabel'}),
                      (Button,{'name':'reset_label','text':'reset'},{'columnspan':2}),
                      (Tkinter.Label,{'text':'DPI'}),(Entry,{'name':'dpi'}),
                      (Tkinter.Label,{'text':'FIGSIZE'}),(MultipleEntries,{'name':'figsize'}),
                      ]
            def __init__(self,master=None,cnf={},**kw):
                Panel.__init__(self,master,cnf,**kw)
                self.__initializing = True
            def connect(self,logic):
                connect((logic,'base_plot'),(self,'base_plot'))
                if self.base_plot is None: return
                plot = self.base_plot()
                subplotpars = plot.ax.figure.subplotpars
                self._config = {
                                'left'   : subplotpars.left,
                                'right'  : subplotpars.right,
                                'bottom' : subplotpars.bottom,
                                'top'    : subplotpars.top,
                                'title'  : plot.ax.get_title(),
                                'xlabel' : plot.ax.get_xlabel(),
                                'ylabel' : plot.ax.get_ylabel(),
                                'figsize' : plot.figure.get_size_inches(),
                                'dpi'     : plot.figure.get_dpi(),
                                }
                self.children['padl'].value = subplotpars.left
                self.children['padr'].value = subplotpars.right
                self.children['padb'].value = subplotpars.bottom
                self.children['padt'].value = subplotpars.top
                self.children['title'].value = plot.ax.get_title()
                self.children['xlabel'].value = plot.ax.get_xlabel()
                self.children['ylabel'].value = plot.ax.get_ylabel()
                self.children['figsize'].value = self._config['figsize']
                self.children['dpi'].value = self._config['dpi']
                for name in ['padl','padr','padb','padt','reset_pad','reset_label','title','xlabel','ylabel','figsize','dpi']:
                    connect((self.children[name],'value'),(self,name))
                self.__initializing = False
            @event()
            def padl(self): self._update_adjust()
            @event()
            def padr(self): self._update_adjust()
            @event()
            def padb(self): self._update_adjust()
            @event()
            def padt(self): self._update_adjust()
            @event()
            def reset_pad(self): self._reset_pad()
            @event()
            def reset_label(self): self._reset_label()
            @event()
            def figsize(self): self._resize()
            @event()
            def dpi(self): self._resize()
            @event()
            def title(self):
                if self.__initializing: return
                plot = self.base_plot()
                plot.ax.set_title(self.title)
                plot.canvas.show()
            @event()
            def xlabel(self):
                if self.__initializing: return
                plot = self.base_plot()
                plot.ax.set_xlabel(self.xlabel)
                plot.canvas.show()
            @event()
            def ylabel(self):
                if self.__initializing: return
                plot = self.base_plot()
                plot.ax.set_ylabel(self.ylabel)
                plot.canvas.show()
            def _resize(self):
                if self.__initializing: return
                figsize = self.figsize
                dpi     = self.dpi
                self.base_plot().resize(dpi,figsize)
            def _update_adjust(self):
                if self.__initializing: return
                plot = self.base_plot()
                plot.ax.figure.subplots_adjust(left   = self.padl,
                                               right  = self.padr,
                                               bottom = self.padb,
                                               top    = self.padt)
                plot.canvas.show()
            def _reset_pad(self):
                if self.__initializing: return
                self.padl = self._config['left']
                self.padr = self._config['right']
                self.padb = self._config['bottom']
                self.padt = self._config['top']
            def _reset_label(self):
                if self.__initializing: return
                self.title = self._config['title']
                self.xlabel = self._config['xlabel']
                self.ylabel = self._config['ylabel']
                
class BasePlotPanel(Panel):
    def layout(self):
        Embed(self,BasePlot,name='result').pack()
        
class ScalarTable(Logic):
    value = Terminal()
    format = Terminal('-')
    @rule('value')
    def result(self):
        if self.value is None: return (array([0.,1.]),array([0.,1.]))
        return (self.value[:,0],self.value[:,1:],self.format)
        
class MatrixPlot(BasePlot):
    result = Terminal()
    def __init__(self,master=None,name=None):
        BasePlot.__init__(self,master,name)
        o = ScalarTable(self,name='scalartable')
        for name in ['value','result']: connect((self,name),(o,name))
        
class MatrixPlotPanel(Panel):
    def layout(self):
        Embed(self,MatrixPlot,name='result').pack()
        
class PlotPanel(Panel):
    Plot = BasePlot
    def layout(self):
        Embed(self,self.Plot,name='result').pack()
        