# coding: utf-8
import Tkinter
import ttk
import weakref
import inspect
import platform
from term import Terminal, Rule, event, connect
from tkext import Entry, Checkbutton, Button, Label, AutoTrigWidget
from utils.tk import TableBuilder
from utils.singleton import Singleton

import types
import numpy

kw = lambda **kwargs: kwargs

class Root(object):
    __metaclass__ = Singleton
    def __init__(self):
        self.children = {}
    def destroy(self):
        for c in self.children.values(): c.destroy()
        
class Logic(object):
    def __init__(self,master=None,name=None):
        self.children = {}
        if master == None:
            self.master = Root()
        else:
            self.master = master
        if name == None:
            self._name = repr(id(self))
        else:
            self._name = name
        if self._name in self.master.children: # master.childrenにおけるidの唯一性を保証する
            self.master.children[self._name].destroy()
        self.master.children[self._name] = self
    def _remove_from_master(self): # master.childrenから自身へのオブジェクト参照を廃棄する
        if self._name in self.master.children:
            del self.master.children[self._name]
    def destroy(self):
        ''' Destroy this and all descendants nodes.'''
        for c in self.children.values(): c.destroy() # 子オブジェクトを巡回してdestroy()をコールする
        self._remove_from_master() # 親オブジェクトのchildren辞書から自身の参照を削除する
        # ^^^ 辞書の巡回中に辞書を変更しちゃって大丈夫？
        # self.children.clear() で一気に削除するほうが行儀いいのでは？
        # self.master.children.clear()

Parts = Logic

class Panel(Tkinter.Frame,object):
    COLUMN = 2
    CONNECTION = [] # logic: self
    def __init__(self,master=None,cnf={},**kw):
        Tkinter.Frame.__init__(self,master,cnf,**kw)
        self.layout()
    def layout(self):
        try: self.LAYOUT
        except AttributeError: return
        description = []
        for o in self.LAYOUT:
            if len(o) is not 2 and len(o) is not 3: continue # skip item (ERROR!)
            description.append((o[0],o[1],{'sticky':Tkinter.W+Tkinter.E}))
            if len(o) is 3:
                for k,v in o[2].iteritems():
                    description[-1][2][k] = v
        TableBuilder(self,column=self.COLUMN,description=description)
    def widget(self,name):
        #
        # 論理的に最も近い name のウィジェットを検索する
        #
        if name in self.children: return self.children[name]
        # ！！下層へのウィジェットの検索を追加したい
#        for key,value in self.children.iteritems():
#            self.children[key]
        return
    def connect(self,logic):
        #
        # コネクションリストを生成する
        #
        connection = []
        # Logic の各ターミナルと同一名称の論理的に最も近い子 Widget の value をリストに追加する
        terms = inspect.getmembers(logic.__class__,lambda x: isinstance(x,Terminal))
        tmp = {}
        for name,value in terms: tmp[name] = value
        terms = tmp
        for name,value in terms.iteritems():
            if self.widget(name) is None: continue
            connection.append(('#%s' % name,'%s#value' % name))
        # CONNECTION の記述内容を追加する
        # 標準記法
        # self.terminal_name > '~terminal_name'
        # logic.terminal_name > '#terminal_name'
        # self.children['name1'].children['name2'].terminal_name > 'name1.name2#terminal_name'
        # 短縮形
        # '#terminal_name' -> 'name'
        # 'widget#value' -> 'name'
        # 'widget1.widget2#value' -> 'name1.name2'
        for o in self.CONNECTION:
            c = []
            for id in o:
                if '#' in id or id.startswith('~'): # #term or widget#term or widget.widget#term or ~term
                    c.append(id)
                    continue
                path = ''
                if '.' in id: # widget.widget (パスの抽出)
                    for pathi in id.split('.')[:-1]: path = path + '%s.' % pathi
                    id = id.split('.')[-1]
                # widget#value or #term (contraction)
                if path == '' and id in terms: # #term
                    c.append('#%s' % id)
                else:
                    c.append('%s%s#value' % (path,id))
            if c: connection.append(tuple(c))
            
#        print logic.__class__, connection
        for record in connection:
            record = [self.id2tpl(field,logic) for field in record]
#            print record
            connect(record[0],*record[1:])
    def id2tpl(self,id,logic):
        if id.startswith('~'): return (self,id[1:])
        if id.startswith('#'): return (logic,id[1:])
        path, term_name = id.split('#') # ターミナル名を抽出
        # ウィジェットツリーを検索
        owner = self 
        for name in path.split('.'):
            if name in owner.children: owner = owner.children[name]
        if isinstance(owner,BaseEquipment): owner = owner.logic
        return (owner,term_name)
        
class Config(ttk.Notebook):
    def __init__(self,master=None,panel_klass=None,**kw):
        ttk.Notebook.__init__(self,master,**kw)
        self.subpanel = weakref.WeakValueDictionary()
        if panel_klass is None: return
        for key,klass in panel_klass.iteritems():
            self.subpanel[key] = klass(self)
            self.add(self.subpanel[key],text=key.capitalize())

class Layout(Tkinter.Frame):
    def __init__(self,master=None,panel_klass=None,cnf={},**kw):
        Tkinter.Frame.__init__(self,master,cnf,**kw)
        self.panel = weakref.WeakValueDictionary()
        self.config_panel = weakref.WeakValueDictionary()
        self.config_panel_klass = {}
        if panel_klass is None: return
        #
        self.panel['config'] = self.config_panel
        for key,klass in panel_klass.iteritems():
            if key == 'config':
                #self.panel[key] = self.config_panel
                for mykey,myklass in inspect.getmembers(klass,inspect.isclass):
                    self.config_panel_klass[mykey.lower()] = myklass
                continue
            self.panel[key] = klass(self)
        if not 'rack' in self.panel: self.panel['rack'] = Panel(self)
        self.layout(self.panel)
    def layout(self,panel):
        if 'toolbar' in panel:
            panel['toolbar'].grid(row=0,column=0,sticky=Tkinter.E+Tkinter.W+Tkinter.N+Tkinter.S)
        if 'plot' in panel:
            panel['plot'].grid(row=1,column=0,rowspan=2,sticky=Tkinter.E+Tkinter.W+Tkinter.N+Tkinter.S)
            self.grid_rowconfigure(1,weight=1)
        if 'control' in panel:
            panel['control'].grid(row=1,column=1,sticky=Tkinter.E+Tkinter.W+Tkinter.N+Tkinter.S)
        if 'rack' in panel:
            panel['rack'].grid(row=2,column=1,sticky=Tkinter.E+Tkinter.W+Tkinter.N+Tkinter.S)
        if 'status' in panel:
            panel['status'].grid(row=3,column=0,sticky=Tkinter.E+Tkinter.W+Tkinter.N+Tkinter.S)
        self.grid_columnconfigure(0,weight=1)
    @property
    def rack(self):
        if 'rack' in self.panel:
            return self.panel['rack']
        else:
            return
    def connect(self,logic):
        for name in ['plot','control','status','toolbar','rack']:
            if name in self.panel: self.panel[name].connect(logic)
    @property
    def logic(self): return self.master.logic
    def popup_config(self,master,**kw):
        if not self.config_panel_klass: return
        c = Config(master,self.config_panel_klass,**kw)
        c.pack(expand=True,fill=Tkinter.X)
        for key,value in c.subpanel.iteritems():
            self.panel['config'][key] = value
            value.connect(self.logic)
        return self.panel['config']
        
class LayoutV(Layout):
    def layout(self,panel):
        if 'toolbar' in panel:
            panel['toolbar'].grid(row=0,column=0,sticky=Tkinter.E+Tkinter.W+Tkinter.N+Tkinter.S)
        if 'plot' in panel:
            panel['plot'].grid(row=1,column=0,sticky=Tkinter.E+Tkinter.W+Tkinter.N+Tkinter.S)
            self.grid_rowconfigure(1,weight=1)
        if 'control' in panel:
            panel['control'].grid(row=2,column=0,sticky=Tkinter.E+Tkinter.W+Tkinter.N+Tkinter.S)
        if 'rack' in panel:
            panel['rack'].grid(row=3,column=0,sticky=Tkinter.E+Tkinter.W+Tkinter.N+Tkinter.S)
        if 'status' in panel:
            panel['status'].grid(row=4,column=0,sticky=Tkinter.E+Tkinter.W+Tkinter.N+Tkinter.S)
        self.grid_columnconfigure(0,weight=1)

class PlotLayout(Layout):
    def __init__(self,master=None,panel_klass=None,cnf={},**kw):
        Layout.__init__(self,master,panel_klass,cnf,**kw)
        self.config_panel_klass['control'] = panel_klass['control']
    def connect(self,logic):
        for name in ['plot']:
            if name in self.panel: self.panel[name].connect(logic)
    def layout(self,panel):
        if 'plot' in panel:
            panel['plot'].grid(row=0,column=0,sticky=Tkinter.E+Tkinter.W+Tkinter.N+Tkinter.S)
            self.grid_rowconfigure(1,weight=1)
        self.grid_columnconfigure(0,weight=1)
        
class ControlLayout(Layout):
    def connect(self,logic):
        for name in ['control']:
            if name in self.panel: self.panel[name].connect(logic)
    def layout(self,panel):
        if 'control' in panel:
            panel['control'].grid(row=0,column=0,sticky=Tkinter.E+Tkinter.W+Tkinter.N+Tkinter.S)
            self.grid_rowconfigure(1,weight=1)
        self.grid_columnconfigure(0,weight=1)

class BaseEquipment(object):
    def __init__(self,logic_klass=None,layout_klass=Layout,auto_trig=False,mount=True,panel_klass={}):
        self.logic_klass = logic_klass
        self.panel_klass = {}
        self.extract('plot',logic_klass,**panel_klass)
        self.extract('control',logic_klass,**panel_klass)
        self.extract('config',logic_klass,**panel_klass)
        self.extract('menu',logic_klass,**panel_klass)
        if 'menu' in self.panel_klass:
            self._menu = self.panel_klass['menu']
            del self.panel_klass['menu']
        else:
            self._menu = DefaultMenu
        if layout_klass:
            layout = layout_klass(self,self.panel_klass)
            layout.pack(expand=True,fill=Tkinter.BOTH)
            self._layout = weakref.ref(layout)
        else:
            self._layout = None
        if auto_trig:
            Embed(self.layout.rack,AutoTrig,ControlLayout,name='autotrig').pack(fill=Tkinter.X,expand=True)
        if mount: self.mount(logic_klass(self))
    def mount(self,logic):
        self._logic = weakref.ref(logic)
        self.layout.connect(logic)
        if 'autotrig' in self.layout.rack.children: connect((logic,'result'),(self.layout.rack.children['autotrig'].logic,'value'))
        return self
    @property
    def layout(self):
        if self._layout:
            return self._layout()
        else:
            return
    def extract(self,name,logic_klass,**kw):
        klass_name = '%s_klass' % name
        if klass_name in kw:
            self.panel_klass[name] = kw[klass_name]
            del kw[klass_name]
        else:
            try: getattr(logic_klass,name.capitalize())
            except AttributeError: pass
            else: self.panel_klass[name] = getattr(logic_klass,name.capitalize())
    @property
    def panel(self):
        return self.layout.panel
    @property
    def logic(self):
        if self._logic:
            return self._logic()
        else:
            return
        
class Equipment(Tkinter.Frame,BaseEquipment):
    def __init__(self,master=None,logic_klass=None,layout_klass=Layout,auto_trig=False,mount=True,panel_klass={},cnf={},**kw):
        Tkinter.Frame.__init__(self,master,cnf,**kw)
        BaseEquipment.__init__(self,logic_klass,layout_klass,auto_trig,mount,panel_klass)
        self.master.config(menu=self._menu(master=self,name='menu'))
        self.pack(expand=True,fill=Tkinter.BOTH)
        
class Embed(Tkinter.LabelFrame,BaseEquipment):
    def __init__(self,master=None,logic_klass=None,layout_klass=PlotLayout,auto_trig=False,mount=True,panel_klass={},cnf={},**kw):
        Tkinter.LabelFrame.__init__(self,master,cnf,**kw)
        BaseEquipment.__init__(self,logic_klass,layout_klass,auto_trig,mount,panel_klass)
        if logic_klass: self.config(text=logic_klass.__name__)
        #
        # ポップアップメニュー
        #
        self._menu(master=self,name='menu')
        # ポップアップイベントのバインド
        self.bind('<Control-Button-1>', self._rclicked) # Ctrl+右クリック
        if platform.system() == 'Darwin': # Darwinでは右クリックが異なる
            self.bind('<Button-2>', self._rclicked) # DarwinだったらB2
        else:
            self.bind('<Button-3>', self._rclicked) # Windows,LinuxだったらB3
    def _rclicked(self,e):
        self.children['menu'].tk_popup(e.x_root,e.y_root)
    def pack(self,*args,**kw):
        Tkinter.LabelFrame.pack(self,*args,**kw)
        return self
    def grid(self,*args,**kw):
        Tkinter.LabelFrame.grid(self,*args,**kw)
        return self

class ControlPanelFactory(Panel):
    GRID_OPTION={'sticky':Tkinter.W+Tkinter.E}
    def layout(self):
        #
        # Logic のクラスメンバのうち Terminal のインスタンスを抽出
        #
        master = self.master
        while not isinstance(master,BaseEquipment): master = master.master
        members = inspect.getmembers(master.logic_klass,lambda x: isinstance(x,Terminal))
        #
        #
        #
        try: self.SEQUENCE
        except AttributeError:
            for k,v in members:
                if not self.item(k,v): continue
        else:
            temp = {}
            for k,v in members: temp[k] = v
            for k in self.SEQUENCE:
                if k in temp:
                    if not self.item(k,temp[k]): continue
    def item(self,name,value):
        if (value.init_value is None or
            type(value.init_value) == types.InstanceType or
            type(value.init_value) == numpy.ndarray):
            if isinstance(value,Rule): self.button(name)
            return False
        if isinstance(value,Rule):
            self.buttonlabel(name)
        else:
            self.labelentry(name)
        return True
    def button(self,name):
        kw = lambda **kwargs:kwargs
        o = TableBuilder(self)
        o.add(Button,**kw(name=name,text=name)).grid(columnspan=2,**self.GRID_OPTION)
    def labelentry(self,name):
        kw = lambda **kwargs:kwargs
        o = TableBuilder(self)
        o.add(Tkinter.Label,**kw(text=name)).grid(**self.GRID_OPTION)
        o.add(Entry,**kw(name=name)).grid(**self.GRID_OPTION)
    def buttonlabel(self,name):
        kw = lambda **kwargs:kwargs
        o = TableBuilder(self)
        o.add(Button,**kw(text=name)).grid(**self.GRID_OPTION)
        item = o._item()
        o.add(Label,**kw(name=name)).grid(**self.GRID_OPTION)
        connect((self.children[name],'value'),(item,'value'))
        
class Menu(Tkinter.Menu):
    TYPE_CASCADE, TYPE_ITEM = range(2)
    ITEMS = []
    def __init__(self,master=None,cnf={},**kw):
        Tkinter.Menu.__init__(self,master,cnf,**kw)
        self.make()
    def make(self,items=None):
        if items is None: items = self.__class__.ITEMS
        for child in items:
            self.add_child(self,child)
    def add_child(self,parent,child):
        def nocommand(command=None,**kw): return kw
        cls = self.__class__
        itemtype = self.itemtype(child) # child がどのような要素か調べる
        if itemtype == cls.TYPE_CASCADE: # child が カスケード であるならば
            label, item = self.parse_cascade(child) # label と item を抽出して
            index = self.labeltoindex(label)
            if index is None: # label が 不在 ならば
                if not repr(type(item)) == '<type \'classobj\'>':
                    cascade = Menu(parent,name=label.lower()) # あたらしいカスケード要素を生成して
                    parent.add_cascade(label=label,menu=cascade)
                    parent = cascade # 生成したカスケードを parent とする
            else:
                old = self.item(label)
                if old is None: # old が カスケード でなければ
                    self.delete(index) # 元の要素を削除して
                    if not repr(type(item)) == '<type \'classobj\'>':
                        cascade = Menu(parent,name=label.lower()) # 新しいカスケード要素で上書き
                        parent.add_cascade(label=label,menu=cascade)
                        parent = cascade
                    else:
                        pass
                else:
                    parent = old
            if   item == None:
                pass
            elif repr(type(item)) == '<type \'classobj\'>':
                parent.add_cascade(label=label,menu=item(parent,name=label.lower()))
            elif type(item) == list:
                for o in item:
                    self.add_child(parent,o)
        elif itemtype == cls.TYPE_ITEM:
            name, kwargs = child
            if kwargs.has_key('command'): # もしコマンドが定義されていて
                if type(kwargs['command']) == str: # オペランドがメソッド名ならば
                    command = getattr(self,kwargs['command']) # 自身のメソッドをコマンドに割り当てる
                    getattr(parent,name)(command=command,**nocommand(**kwargs))
                    return
            getattr(parent,name)(**kwargs)
    def itemtype(self,item):
        cls = self.__class__
        if len(item) == 1: return cls.TYPE_CASCADE
        if type(item[1]) == list: return cls.TYPE_CASCADE
        if repr(type(item[1])) == '<type \'classobj\'>': return cls.TYPE_CASCADE
        if type(item[1]) == dict: return cls.TYPE_ITEM
    def parse_cascade(self,item):
        if len(item) == 1: return item[0], None
        if type(item[1]) == list: return item[0], item[1:]
        if repr(type(item[1])) == '<type \'classobj\'>': return item[0], item[1]
    def labeltoindex(self,label):
        index = 0
        while index == self.index(index):
            try: self.entrycget(index,'label')
            except: pass
            else:
                if label == self.entrycget(index,'label'):
                    return index
            index = index + 1
        return
    def item(self,label):
        index = self.labeltoindex(label)
        if not index: return
        return self.nametowidget(self.entrycget(index,'menu'))
    def remove_empty_items(self,cascade):
        length = cascade.len()
        for index in range(length):
            if cascade.type(index) == 'cascade':
                label = cascade.entrycget(index,'label')
                menu  = cascade.nametowidget(cascade.entrycget(index,'menu'))
                self.remove_empty_items(menu)
#                if isinstance(menu,ChildrenMenu): continue
                if menu.len() == 0:
                    cascade.delete(index)
    def len(self):
        index = 0
        while index == self.index(index):
            index = index + 1
        return index

class FileMenu(Menu):
    ITEMS = []
    RESTS = [
             ['add_command', kw(label='Config',command='popup_config')],
             ]
    def make_rest(self):
        if not self.len() == 0: self.add_separator()
        self.make(self.__class__.RESTS)
    def popup_config(self):
        if 'config' in self.children: return
        equip = self
        while not isinstance(equip,BaseEquipment): equip = equip.master
        toplevel = Tkinter.Toplevel(self,name='config')
        panels = equip.layout.popup_config(toplevel)
        if panels == None:
            toplevel.destroy()
            return
        
class DefaultMenu(Menu):
    DEFAULT_ITEMS = [
                     ['File', FileMenu],
                     ]
    ITEMS = []
    def __init__(self,master=None,cnf={},**kw):
        cls = self.__class__
        Menu.__init__(self,master,cnf,**kw)
        self.make(cls.DEFAULT_ITEMS)
        self.make(cls.ITEMS)
        self.make_rest(self.children)
        self.remove_empty_items(self)
    def make_rest(self,children): # メニューの末尾にアイテムを追加する
        for key in children:
            child = children[key]
            if isinstance(child,Menu):
                try: make_rest = getattr(child,'make_rest')
                except AttributeError: continue
                make_rest()
                self.make_rest(child.children)

class AutoTrig(Logic):
    value = Terminal()
    interval = Terminal()
    switch = Terminal()
    class Control(Panel):
        COLUMN = 1
        LAYOUT = [(AutoTrigWidget,{'name':'value'}),(Label,{'name':'indicator'}),]
        CONNECTION = [('interval','~interval'),('value#switch','switch','~switch'),('value#interval','interval')]
        @event()
        def interval(self): self._update_indicator()
        @event()
        def switch(self): self._update_indicator()
        def _update_indicator(self):
            if self.switch:
                self.children['indicator'].config(text='%d ms' % self.children['value'].interval)
            else:
                self.children['indicator'].config(text='OFF')
        def layout(self):
            Panel.layout(self)
            self.children['value'].switch = True
    class Config:
        class Config(Panel):
            LAYOUT = [(Checkbutton,{'name':'switch','text':'interval'}),(Entry,{'name':'interval'}),]
            